/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregator;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregatorSupplier;
import org.elasticsearch.search.aggregations.metrics.GlobalOrdCardinalityAggregator;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.InternalCardinality;
import org.elasticsearch.search.aggregations.metrics.NonCollectingSingleMetricAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.TimeSeriesValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;

public class CardinalityAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Long precisionThreshold;
    private final CardinalityAggregatorSupplier aggregatorSupplier;
    private final ExecutionMode executionMode;

    CardinalityAggregatorFactory(String name, ValuesSourceConfig config, Long precisionThreshold, String executionHint, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, CardinalityAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.precisionThreshold = precisionThreshold;
        this.executionMode = executionHint == null ? ExecutionMode.SAVE_TIME_HEURISTIC : ExecutionMode.fromString(executionHint);
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(CardinalityAggregationBuilder.REGISTRY_KEY, Stream.concat(CoreValuesSourceType.ALL_CORE.stream(), Stream.of(TimeSeriesValuesSourceType.COUNTER)).toList(), (name, valuesSourceConfig, precision, executionMode, context, parent, metadata) -> {
            ValuesSource.Bytes.WithOrdinals source;
            ValuesSource patt6780$temp;
            if (valuesSourceConfig.hasValues() && (patt6780$temp = valuesSourceConfig.getValuesSource()) instanceof ValuesSource.Bytes.WithOrdinals && executionMode.useGlobalOrdinals(context, source = (ValuesSource.Bytes.WithOrdinals)patt6780$temp, precision)) {
                String field = valuesSourceConfig.alignesWithSearchIndex() ? valuesSourceConfig.fieldType().name() : null;
                long maxOrd = source.globalMaxOrd(context.searcher().getIndexReader());
                return new GlobalOrdCardinalityAggregator(name, source, field, precision, Math.toIntExact(maxOrd), context, parent, metadata);
            }
            return new CardinalityAggregator(name, valuesSourceConfig, precision, executionMode, context, parent, metadata);
        }, true);
    }

    private static boolean useGlobalOrds(AggregationContext context, ValuesSource.Bytes.WithOrdinals source, int precision) throws IOException {
        List<LeafReaderContext> leaves = context.searcher().getIndexReader().leaves();
        long total = 0L;
        for (LeafReaderContext leaf : leaves) {
            total += source.ordinalsValues(leaf).getValueCount();
        }
        long countsMemoryUsage = HyperLogLogPlusPlus.memoryUsage(precision);
        long ordinalsMemoryUsage = leaves.size() == 1 ? total * 4L : total * 3L;
        return ordinalsMemoryUsage < countsMemoryUsage;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        InternalCardinality empty = InternalCardinality.empty(this.name, metadata);
        return new NonCollectingSingleMetricAggregator(this.name, this.context, parent, empty, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.config, this.precision(), this.executionMode, this.context, parent, metadata);
    }

    private int precision() {
        return this.precisionThreshold == null ? 14 : HyperLogLogPlusPlus.precisionFromThreshold(this.precisionThreshold);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ExecutionMode {
        GLOBAL_ORDINALS(false){

            @Override
            public boolean useGlobalOrdinals(AggregationContext context, ValuesSource.Bytes.WithOrdinals source, int precision) {
                return true;
            }

            @Override
            public boolean useSegmentOrdinals(long maxOrd, int precision) {
                return false;
            }
        }
        ,
        SEGMENT_ORDINALS(false){

            @Override
            public boolean useGlobalOrdinals(AggregationContext context, ValuesSource.Bytes.WithOrdinals source, int precision) {
                return false;
            }

            @Override
            public boolean useSegmentOrdinals(long maxOrd, int precision) {
                return true;
            }
        }
        ,
        DIRECT(false){

            @Override
            public boolean useGlobalOrdinals(AggregationContext context, ValuesSource.Bytes.WithOrdinals source, int precision) {
                return false;
            }

            @Override
            public boolean useSegmentOrdinals(long maxOrd, int precision) {
                return false;
            }
        }
        ,
        SAVE_MEMORY_HEURISTIC(true){

            @Override
            public boolean useGlobalOrdinals(AggregationContext context, ValuesSource.Bytes.WithOrdinals source, int precision) throws IOException {
                return CardinalityAggregatorFactory.useGlobalOrds(context, source, precision);
            }

            @Override
            public boolean useSegmentOrdinals(long maxOrd, int precision) {
                long countsMemoryUsage;
                long ordinalsMemoryUsage = CardinalityAggregator.OrdinalsCollector.memoryOverhead(maxOrd);
                return ordinalsMemoryUsage < (countsMemoryUsage = HyperLogLogPlusPlus.memoryUsage(precision)) / 4L;
            }
        }
        ,
        SAVE_TIME_HEURISTIC(true){

            @Override
            public boolean useGlobalOrdinals(AggregationContext context, ValuesSource.Bytes.WithOrdinals source, int precision) throws IOException {
                return CardinalityAggregatorFactory.useGlobalOrds(context, source, precision);
            }

            @Override
            public boolean useSegmentOrdinals(long maxOrd, int precision) {
                return true;
            }
        };

        final boolean isHeuristicBased;

        public static ExecutionMode fromString(String value) {
            if (value == null) {
                return null;
            }
            try {
                return ExecutionMode.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid execution mode for cardinality aggregation.  Got [" + value + "]expected one of [global_ordinal, segment_ordinal, direct]");
            }
        }

        private ExecutionMode(boolean isHeuristicBased) {
            this.isHeuristicBased = isHeuristicBased;
        }

        public boolean isHeuristicBased() {
            return this.isHeuristicBased;
        }

        public abstract boolean useGlobalOrdinals(AggregationContext var1, ValuesSource.Bytes.WithOrdinals var2, int var3) throws IOException;

        public abstract boolean useSegmentOrdinals(long var1, int var3);
    }
}

