/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;

public class DateNanosDocValuesField
extends AbstractScriptFieldFactory<ZonedDateTime>
implements Field<ZonedDateTime>,
DocValuesScriptFieldFactory,
ScriptDocValues.Supplier<ZonedDateTime> {
    protected final SortedNumericDocValues input;
    protected final String name;
    protected ZonedDateTime[] values = new ZonedDateTime[0];
    protected int count;
    private ScriptDocValues.Dates dates = null;

    public DateNanosDocValuesField(SortedNumericDocValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = ZonedDateTime.ofInstant(DateUtils.toInstant(this.input.nextValue()), ZoneOffset.UTC);
            }
        } else {
            this.resize(0);
        }
    }

    protected void resize(int newSize) {
        this.count = newSize;
        assert (this.count >= 0) : "size must be positive (got " + this.count + "): likely integer overflow?";
        this.values = ArrayUtil.grow(this.values, this.count);
    }

    public ScriptDocValues<ZonedDateTime> toScriptDocValues() {
        if (this.dates == null) {
            this.dates = new ScriptDocValues.Dates(this);
        }
        return this.dates;
    }

    @Override
    public ZonedDateTime getInternal(int index) {
        return this.values[index];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public ZonedDateTime get(ZonedDateTime defaultValue) {
        return this.get(0, defaultValue);
    }

    public ZonedDateTime get(int index, ZonedDateTime defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public Iterator<ZonedDateTime> iterator() {
        return new Iterator<ZonedDateTime>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DateNanosDocValuesField.this.count;
            }

            @Override
            public ZonedDateTime next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DateNanosDocValuesField.this.values[this.index++];
            }
        };
    }
}

