/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.common.util.CachedSupplier;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.script.StatsSummary;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class ScriptTermStats {
    public static final NodeFeature TERM_STAT_FEATURE = new NodeFeature("script.term_stats", true);
    private final IntSupplier docIdSupplier;
    private final Term[] terms;
    private final IndexSearcher searcher;
    private final LeafReaderContext leafReaderContext;
    private final StatsSummary statsSummary = new StatsSummary();
    private final Supplier<TermStates[]> termContextsSupplier;
    private final Supplier<PostingsEnum[]> postingsSupplier;
    private final Supplier<StatsSummary> docFreqSupplier;
    private final Supplier<StatsSummary> totalTermFreqSupplier;

    public ScriptTermStats(IndexSearcher searcher, LeafReaderContext leafReaderContext, IntSupplier docIdSupplier, Set<Term> terms) {
        this.searcher = searcher;
        this.leafReaderContext = leafReaderContext;
        this.docIdSupplier = docIdSupplier;
        this.terms = terms.toArray(new Term[0]);
        this.termContextsSupplier = CachedSupplier.wrap(this::loadTermContexts);
        this.postingsSupplier = CachedSupplier.wrap(this::loadPostings);
        this.docFreqSupplier = CachedSupplier.wrap(this::loadDocFreq);
        this.totalTermFreqSupplier = CachedSupplier.wrap(this::loadTotalTermFreq);
    }

    public int uniqueTermsCount() {
        return this.terms.length;
    }

    public int matchedTermsCount() {
        int docId = this.docIdSupplier.getAsInt();
        int matchedTerms = 0;
        this.advancePostings(docId);
        for (PostingsEnum postingsEnum : this.postingsSupplier.get()) {
            if (postingsEnum == null || postingsEnum.docID() != docId) continue;
            ++matchedTerms;
        }
        return matchedTerms;
    }

    public StatsSummary docFreq() {
        return this.docFreqSupplier.get();
    }

    private StatsSummary loadDocFreq() {
        StatsSummary docFreqStats = new StatsSummary();
        TermStates[] termContexts = this.termContextsSupplier.get();
        try {
            for (int i = 0; i < termContexts.length; ++i) {
                IndexSearcher indexSearcher = this.searcher;
                if (indexSearcher instanceof ContextIndexSearcher) {
                    ContextIndexSearcher contextIndexSearcher = (ContextIndexSearcher)indexSearcher;
                    docFreqStats.accept(contextIndexSearcher.docFreq(this.terms[i], termContexts[i].docFreq()));
                    continue;
                }
                docFreqStats.accept(termContexts[i].docFreq());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return docFreqStats;
    }

    public StatsSummary totalTermFreq() {
        return this.totalTermFreqSupplier.get();
    }

    private StatsSummary loadTotalTermFreq() {
        StatsSummary totalTermFreqStats = new StatsSummary();
        TermStates[] termContexts = this.termContextsSupplier.get();
        try {
            for (int i = 0; i < termContexts.length; ++i) {
                IndexSearcher indexSearcher = this.searcher;
                if (indexSearcher instanceof ContextIndexSearcher) {
                    ContextIndexSearcher contextIndexSearcher = (ContextIndexSearcher)indexSearcher;
                    totalTermFreqStats.accept(contextIndexSearcher.totalTermFreq(this.terms[i], termContexts[i].totalTermFreq()));
                    continue;
                }
                totalTermFreqStats.accept(termContexts[i].totalTermFreq());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return totalTermFreqStats;
    }

    public StatsSummary termFreq() {
        this.statsSummary.reset();
        int docId = this.docIdSupplier.getAsInt();
        try {
            this.advancePostings(docId);
            for (PostingsEnum postingsEnum : this.postingsSupplier.get()) {
                if (postingsEnum == null || postingsEnum.docID() != docId) {
                    this.statsSummary.accept(0.0);
                    continue;
                }
                this.statsSummary.accept(postingsEnum.freq());
            }
            return this.statsSummary;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public StatsSummary termPositions() {
        this.statsSummary.reset();
        int docId = this.docIdSupplier.getAsInt();
        try {
            this.advancePostings(docId);
            for (PostingsEnum postingsEnum : this.postingsSupplier.get()) {
                if (postingsEnum == null || postingsEnum.docID() != docId) continue;
                for (int i = 0; i < postingsEnum.freq(); ++i) {
                    this.statsSummary.accept(postingsEnum.nextPosition() + 1);
                }
            }
            return this.statsSummary;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TermStates[] loadTermContexts() {
        try {
            TermStates[] termContexts = new TermStates[this.terms.length];
            for (int i = 0; i < this.terms.length; ++i) {
                termContexts[i] = TermStates.build(this.searcher, this.terms[i], true);
            }
            return termContexts;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private PostingsEnum[] loadPostings() {
        try {
            PostingsEnum[] postings = new PostingsEnum[this.terms.length];
            for (int i = 0; i < this.terms.length; ++i) {
                postings[i] = this.leafReaderContext.reader().postings(this.terms[i], 24);
            }
            return postings;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void advancePostings(int targetDocId) {
        try {
            for (PostingsEnum posting : this.postingsSupplier.get()) {
                if (posting == null || posting.docID() >= targetDocId || posting.docID() == Integer.MAX_VALUE) continue;
                posting.advance(targetDocId);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

