/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.xcontent.ToXContent;

public record ScriptCacheStats(Map<String, ScriptStats> context, ScriptStats general) implements Writeable,
ChunkedToXContent
{
    public ScriptCacheStats(Map<String, ScriptStats> context) {
        this(Collections.unmodifiableMap(context), null);
    }

    public ScriptCacheStats(ScriptStats general) {
        this(null, Objects.requireNonNull(general));
    }

    public static ScriptCacheStats read(StreamInput in) throws IOException {
        boolean isContext = in.readBoolean();
        if (!isContext) {
            return new ScriptCacheStats(ScriptStats.read(in));
        }
        int size = in.readInt();
        Map<String, ScriptStats> context = Maps.newMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readString();
            context.put(name, ScriptStats.read(in));
        }
        return new ScriptCacheStats(context);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.general != null) {
            out.writeBoolean(false);
            this.general.writeTo(out);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.context.size());
        for (String name : this.context.keySet().stream().sorted().toList()) {
            out.writeString(name);
            this.context.get(name).writeTo(out);
        }
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        Function<ScriptStats, ToXContent> statsFields = s -> (b, p) -> b.field("compilations", s.getCompilations()).field("cache_evictions", s.getCacheEvictions()).field("compilation_limit_triggered", s.getCompilationLimitTriggered());
        return ChunkedToXContent.builder(outerParams).object("script_cache", sb -> {
            if (this.general != null) {
                sb.xContentObject("sum", (ToXContent)statsFields.apply(this.general));
            } else {
                sb.xContentObject("sum", (ToXContent)statsFields.apply(this.sum()));
                sb.array("contexts", this.context.entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator(), (eb, e) -> eb.object(ebo -> {
                    ebo.field("context", (String)e.getKey());
                    ebo.append((ToXContent)statsFields.apply((ScriptStats)e.getValue()));
                }));
            }
        });
    }

    public Map<String, ScriptStats> getContextStats() {
        return this.context;
    }

    public ScriptStats getGeneralStats() {
        return this.general;
    }

    public ScriptStats sum() {
        if (this.general != null) {
            return this.general;
        }
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptStats stat : this.context.values()) {
            compilations += stat.getCompilations();
            cacheEvictions += stat.getCacheEvictions();
            compilationLimitTriggered += stat.getCompilationLimitTriggered();
        }
        return new ScriptStats(compilations, cacheEvictions, compilationLimitTriggered, null, null);
    }

    static final class Fields {
        static final String SCRIPT_CACHE_STATS = "script_cache";
        static final String CONTEXT = "context";
        static final String SUM = "sum";
        static final String CONTEXTS = "contexts";

        Fields() {
        }
    }
}

