/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import org.elasticsearch.action.admin.cluster.node.hotthreads.TransportNodesHotThreadsAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestResponseListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestNodesHotThreadsAction
extends BaseRestHandler {
    private static final String formatDeprecatedMessageWithoutNodeID = "[%s] is a deprecated endpoint. Please use [/_nodes/hot_threads] instead.";
    private static final String formatDeprecatedMessageWithNodeID = "[%s] is a deprecated endpoint. Please use [/_nodes/{nodeId}/hot_threads] instead.";
    private static final String DEPRECATED_MESSAGE_CLUSTER_NODES_HOT_THREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/hot_threads] instead.", "/_cluster/nodes/hot_threads");
    private static final String DEPRECATED_MESSAGE_CLUSTER_NODES_NODEID_HOT_THREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/{nodeId}/hot_threads] instead.", "/_cluster/nodes/{nodeId}/hot_threads");
    private static final String DEPRECATED_MESSAGE_CLUSTER_NODES_HOTTHREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/hot_threads] instead.", "/_cluster/nodes/hotthreads");
    private static final String DEPRECATED_MESSAGE_CLUSTER_NODES_NODEID_HOTTHREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/{nodeId}/hot_threads] instead.", "/_cluster/nodes/{nodeId}/hotthreads");
    private static final String DEPRECATED_MESSAGE_NODES_HOTTHREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/hot_threads] instead.", "/_nodes/hotthreads");
    private static final String DEPRECATED_MESSAGE_NODES_NODEID_HOTTHREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/{nodeId}/hot_threads] instead.", "/_nodes/{nodeId}/hotthreads");

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_nodes/hot_threads"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/hot_threads"), RestHandler.Route.builder(RestRequest.Method.GET, "/_cluster/nodes/hot_threads").deprecated(DEPRECATED_MESSAGE_CLUSTER_NODES_HOT_THREADS, DeprecationLogger.CRITICAL, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.GET, "/_cluster/nodes/{nodeId}/hot_threads").deprecated(DEPRECATED_MESSAGE_CLUSTER_NODES_NODEID_HOT_THREADS, DeprecationLogger.CRITICAL, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.GET, "/_cluster/nodes/hotthreads").deprecated(DEPRECATED_MESSAGE_CLUSTER_NODES_HOTTHREADS, DeprecationLogger.CRITICAL, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.GET, "/_cluster/nodes/{nodeId}/hotthreads").deprecated(DEPRECATED_MESSAGE_CLUSTER_NODES_NODEID_HOTTHREADS, DeprecationLogger.CRITICAL, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.GET, "/_nodes/hotthreads").deprecated(DEPRECATED_MESSAGE_NODES_HOTTHREADS, DeprecationLogger.CRITICAL, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.GET, "/_nodes/{nodeId}/hotthreads").deprecated(DEPRECATED_MESSAGE_NODES_NODEID_HOTTHREADS, DeprecationLogger.CRITICAL, RestApiVersion.V_7).build());
    }

    @Override
    public String getName() {
        return "nodes_hot_threads_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        NodesHotThreadsRequest nodesHotThreadsRequest = new NodesHotThreadsRequest(nodesIds, new HotThreads.RequestOptions(request.paramAsInt("threads", HotThreads.RequestOptions.DEFAULT.threads()), HotThreads.ReportType.of(request.param("type", HotThreads.RequestOptions.DEFAULT.reportType().getTypeValue())), HotThreads.SortOrder.of(request.param("sort", HotThreads.RequestOptions.DEFAULT.sortOrder().getOrderValue())), request.paramAsTime("interval", HotThreads.RequestOptions.DEFAULT.interval()), request.paramAsInt("snapshots", HotThreads.RequestOptions.DEFAULT.snapshots()), request.paramAsBoolean("ignore_idle_threads", HotThreads.RequestOptions.DEFAULT.ignoreIdleThreads())));
        nodesHotThreadsRequest.timeout(RestUtils.getTimeout(request));
        return channel -> client.execute(TransportNodesHotThreadsAction.TYPE, nodesHotThreadsRequest, new RestResponseListener<NodesHotThreadsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesHotThreadsResponse response) {
                response.mustIncRef();
                return RestResponse.chunked(RestStatus.OK, ChunkedRestResponseBodyPart.fromTextChunks("text/plain; charset=UTF-8", response.getTextChunks()), response::decRef);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

