/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.api;

import java.util.Arrays;
import org.elasticsearch.common.network.CIDRUtils;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.core.Tuple;

public class CIDR {
    private final byte[] lower;
    private final byte[] upper;

    public CIDR(String cidr) {
        if (cidr.contains("/")) {
            Tuple<byte[], byte[]> range = CIDRUtils.getLowerUpper(InetAddresses.parseCidr(cidr));
            this.lower = range.v1();
            this.upper = range.v2();
        } else {
            this.lower = InetAddresses.forString(cidr).getAddress();
            this.upper = this.lower;
        }
    }

    public boolean contains(String addressToCheck) {
        if (addressToCheck == null || "".equals(addressToCheck)) {
            return false;
        }
        byte[] parsedAddress = InetAddresses.forString(addressToCheck).getAddress();
        return CIDR.isBetween(parsedAddress, this.lower, this.upper);
    }

    private static boolean isBetween(byte[] addr, byte[] lower, byte[] upper) {
        if (addr.length != lower.length) {
            addr = CIDRUtils.encode(addr);
            lower = CIDRUtils.encode(lower);
            upper = CIDRUtils.encode(upper);
        }
        return Arrays.compareUnsigned(lower, addr) <= 0 && Arrays.compareUnsigned(upper, addr) >= 0;
    }
}

