/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.Strings;
import org.elasticsearch.painless.DefBootstrap;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.LambdaBootstrap;
import org.elasticsearch.painless.Utility;
import org.elasticsearch.painless.api.ValueIterator;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.symbol.FunctionTable;

public final class Def {
    private static final MethodHandle MAP_GET;
    private static final MethodHandle MAP_PUT;
    private static final MethodHandle LIST_GET;
    private static final MethodHandle LIST_SET;
    private static final MethodHandle OBJECT_ITERATOR;
    private static final MethodHandle MAP_INDEX_NORMALIZE;
    private static final MethodHandle LIST_INDEX_NORMALIZE;
    private static final MethodHandle ARRAY_LENGTH;
    public static final Map<Class<?>, MethodHandle> DEF_TO_BOXED_TYPE_IMPLICIT_CAST;

    static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }

    static MethodHandle arrayLengthGetter(Class<?> arrayType) {
        try {
            return ARRAY_LENGTH.invokeExact(arrayType);
        }
        catch (Throwable t) {
            Def.rethrow(t);
            throw new AssertionError((Object)t);
        }
    }

    static MethodHandle lookupMethod(PainlessLookup painlessLookup, FunctionTable functions, Map<String, Object> constants, MethodHandles.Lookup methodHandlesLookup, MethodType callSiteType, Class<?> receiverClass, String name, Object[] args) throws Throwable {
        String recipeString = (String)args[0];
        int numArguments = callSiteType.parameterCount();
        if (recipeString.isEmpty()) {
            PainlessMethod painlessMethod = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, numArguments - 1);
            if (painlessMethod == null) {
                throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + (numArguments - 1) + "] not found");
            }
            MethodHandle handle = painlessMethod.methodHandle();
            Object[] injections = PainlessLookupUtility.buildInjections(painlessMethod, constants);
            if (injections.length > 0) {
                handle = MethodHandles.insertArguments(handle, 1, injections);
            }
            return handle;
        }
        BitSet lambdaArgs = new BitSet(recipeString.length());
        for (int i = 0; i < recipeString.length(); ++i) {
            lambdaArgs.set(recipeString.charAt(i));
        }
        int arity = callSiteType.parameterCount() - 1;
        int upTo = 1;
        for (int i = 1; i < numArguments; ++i) {
            if (!lambdaArgs.get(i - 1)) continue;
            Encoding signature = new Encoding((String)args[upTo++]);
            arity -= signature.numCaptures;
            if (!signature.needsInstance) continue;
            --arity;
        }
        PainlessMethod method = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, arity);
        if (method == null) {
            throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + arity + "] not found");
        }
        MethodHandle handle = method.methodHandle();
        Object[] injections = PainlessLookupUtility.buildInjections(method, constants);
        if (injections.length > 0) {
            handle = MethodHandles.insertArguments(handle, 1, injections);
        }
        int replaced = 0;
        upTo = 1;
        for (int i = 1; i < numArguments; ++i) {
            MethodHandle filter;
            if (!lambdaArgs.get(i - 1)) continue;
            Encoding defEncoding = new Encoding((String)args[upTo++]);
            Class<?> interfaceType = method.typeParameters().get(i - 1 - replaced - (defEncoding.needsInstance ? 1 : 0));
            if (defEncoding.isStatic) {
                filter = Def.lookupReferenceInternal(painlessLookup, functions, constants, methodHandlesLookup, interfaceType, defEncoding.symbol, defEncoding.methodName, defEncoding.numCaptures, defEncoding.needsInstance);
            } else {
                Class[] captures = new Class[defEncoding.numCaptures];
                for (int capture = 0; capture < captures.length; ++capture) {
                    captures[capture] = callSiteType.parameterType(i + 1 + capture);
                }
                MethodType nestedType = MethodType.methodType(interfaceType, captures);
                CallSite nested = DefBootstrap.bootstrap(painlessLookup, functions, constants, methodHandlesLookup, defEncoding.methodName, nestedType, 0, 6, PainlessLookupUtility.typeToCanonicalTypeName(interfaceType));
                filter = nested.dynamicInvoker();
            }
            filter = MethodHandles.dropArguments(filter, 0, new Class[]{String.class});
            handle = MethodHandles.collectArguments(handle, i - (defEncoding.needsInstance ? 1 : 0), filter);
            i += defEncoding.numCaptures;
            replaced += defEncoding.numCaptures;
        }
        return handle;
    }

    static MethodHandle lookupReference(PainlessLookup painlessLookup, FunctionTable functions, Map<String, Object> constants, MethodHandles.Lookup methodHandlesLookup, String interfaceClass, Class<?> receiverClass, String name) throws Throwable {
        Class<?> interfaceType = painlessLookup.canonicalTypeNameToType(interfaceClass);
        if (interfaceType == null) {
            throw new IllegalArgumentException("type [" + interfaceClass + "] not found");
        }
        PainlessMethod interfaceMethod = painlessLookup.lookupFunctionalInterfacePainlessMethod(interfaceType);
        if (interfaceMethod == null) {
            throw new IllegalArgumentException("Class [" + interfaceClass + "] is not a functional interface");
        }
        int arity = interfaceMethod.typeParameters().size();
        PainlessMethod implMethod = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, arity);
        if (implMethod == null) {
            throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + arity + "] not found");
        }
        return Def.lookupReferenceInternal(painlessLookup, functions, constants, methodHandlesLookup, interfaceType, PainlessLookupUtility.typeToCanonicalTypeName(implMethod.targetClass()), implMethod.javaMethod().getName(), 1, false);
    }

    private static MethodHandle lookupReferenceInternal(PainlessLookup painlessLookup, FunctionTable functions, Map<String, Object> constants, MethodHandles.Lookup methodHandlesLookup, Class<?> clazz, String type, String call, int captures, boolean needsScriptInstance) throws Throwable {
        FunctionRef ref = FunctionRef.create(painlessLookup, functions, null, clazz, type, call, captures, constants, needsScriptInstance);
        Class<?>[] parameters = ref.factoryMethodParameters(needsScriptInstance ? methodHandlesLookup.lookupClass() : null);
        MethodType factoryMethodType = MethodType.methodType(clazz, parameters);
        CallSite callSite = LambdaBootstrap.lambdaBootstrap(methodHandlesLookup, ref.interfaceMethodName, factoryMethodType, ref.interfaceMethodType, ref.delegateClassName, ref.delegateInvokeType, ref.delegateMethodName, ref.delegateMethodType, ref.isDelegateInterface ? 1 : 0, ref.isDelegateAugmented ? 1 : 0, ref.delegateInjections);
        return callSite.dynamicInvoker().asType(MethodType.methodType(clazz, parameters));
    }

    static MethodHandle lookupGetter(PainlessLookup painlessLookup, Class<?> receiverClass, String name) {
        MethodHandle getter = painlessLookup.lookupRuntimeGetterMethodHandle(receiverClass, name);
        if (getter != null) {
            return getter;
        }
        if (receiverClass.isArray() && "length".equals(name)) {
            return Def.arrayLengthGetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MethodHandles.insertArguments(MAP_GET, 1, name);
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            try {
                int index = Integer.parseInt(name);
                return MethodHandles.insertArguments(LIST_GET, 1, index);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Illegal list shortcut value [" + name + "].");
            }
        }
        throw new IllegalArgumentException("dynamic getter [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "] not found");
    }

    static MethodHandle lookupSetter(PainlessLookup painlessLookup, Class<?> receiverClass, String name) {
        MethodHandle setter = painlessLookup.lookupRuntimeSetterMethodHandle(receiverClass, name);
        if (setter != null) {
            return setter;
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MethodHandles.insertArguments(MAP_PUT, 1, name);
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            try {
                int index = Integer.parseInt(name);
                return MethodHandles.insertArguments(LIST_SET, 1, index);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Illegal list shortcut value [" + name + "].");
            }
        }
        throw new IllegalArgumentException("dynamic setter [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "] not found");
    }

    static MethodHandle lookupIndexNormalize(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return ArrayIndexNormalizeHelper.arrayIndexNormalizer(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_INDEX_NORMALIZE;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_INDEX_NORMALIZE;
        }
        throw new IllegalArgumentException("Attempting to address a non-array-like type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    static MethodHandle lookupArrayStore(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return MethodHandles.arrayElementSetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_PUT;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_SET;
        }
        throw new IllegalArgumentException("Attempting to address a non-array type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    static MethodHandle lookupArrayLoad(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return MethodHandles.arrayElementGetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_GET;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_GET;
        }
        throw new IllegalArgumentException("Attempting to address a non-array type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    private static ClassCastException castException(Class<?> sourceClass, Class<?> targetClass, Boolean implicit) {
        Object[] objectArray = new Object[3];
        objectArray[0] = implicit != null ? (implicit.booleanValue() ? "implicitly " : "explicitly ") : "";
        objectArray[1] = PainlessLookupUtility.typeToUnboxedType(sourceClass).getCanonicalName();
        objectArray[2] = targetClass.getCanonicalName();
        return new ClassCastException(Strings.format("cannot %scast def [%s] to %s", objectArray));
    }

    static MethodHandle lookupIterator(Class<?> receiverClass) {
        if (Iterable.class.isAssignableFrom(receiverClass)) {
            return OBJECT_ITERATOR;
        }
        if (receiverClass.isArray()) {
            return ArrayIteratorHelper.newIterator(receiverClass);
        }
        throw new IllegalArgumentException("Cannot iterate over [" + receiverClass.getCanonicalName() + "]");
    }

    public static boolean defToboolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw Def.castException(value.getClass(), Boolean.TYPE, null);
    }

    public static byte defTobyteImplicit(Object value) {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        throw Def.castException(value.getClass(), Byte.TYPE, true);
    }

    public static short defToshortImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        throw Def.castException(value.getClass(), Short.TYPE, true);
    }

    public static char defTocharImplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw Def.castException(value.getClass(), Character.TYPE, true);
    }

    public static int defTointImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw Def.castException(value.getClass(), Integer.TYPE, true);
    }

    public static long defTolongImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw Def.castException(value.getClass(), Long.TYPE, true);
    }

    public static float defTofloatImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        throw Def.castException(value.getClass(), Float.TYPE, true);
    }

    public static double defTodoubleImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        throw Def.castException(value.getClass(), Double.TYPE, true);
    }

    public static byte defTobyteExplicit(Object value) {
        if (value instanceof Character) {
            return (byte)((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).byteValue();
        }
        throw Def.castException(value.getClass(), Byte.TYPE, false);
    }

    public static short defToshortExplicit(Object value) {
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).shortValue();
        }
        throw Def.castException(value.getClass(), Short.TYPE, false);
    }

    public static char defTocharExplicit(Object value) {
        if (value instanceof String) {
            return Utility.StringTochar((String)value);
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return (char)((Number)value).intValue();
        }
        throw Def.castException(value.getClass(), Character.TYPE, false);
    }

    public static int defTointExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).intValue();
        }
        throw Def.castException(value.getClass(), Integer.TYPE, false);
    }

    public static long defTolongExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).longValue();
        }
        throw Def.castException(value.getClass(), Long.TYPE, false);
    }

    public static float defTofloatExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).floatValue();
        }
        throw Def.castException(value.getClass(), Float.TYPE, false);
    }

    public static double defTodoubleExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).doubleValue();
        }
        throw Def.castException(value.getClass(), Byte.TYPE, false);
    }

    public static Boolean defToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw Def.castException(value.getClass(), Boolean.class, false);
    }

    public static Byte defToByteImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        throw Def.castException(value.getClass(), Byte.class, false);
    }

    public static Short defToShortImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (short)((Byte)value);
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        throw Def.castException(value.getClass(), Short.class, false);
    }

    public static Character defToCharacterImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        throw Def.castException(value.getClass(), Character.class, false);
    }

    public static Integer defToIntegerImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (int)((Byte)value);
        }
        if (value instanceof Short) {
            return (int)((Short)value);
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw Def.castException(value.getClass(), Integer.class, false);
    }

    public static Long defToLongImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (long)((Byte)value);
        }
        if (value instanceof Short) {
            return (long)((Short)value);
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return (long)((Integer)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw Def.castException(value.getClass(), Long.class, false);
    }

    public static Float defToFloatImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return Float.valueOf(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return Float.valueOf(((Short)value).shortValue());
        }
        if (value instanceof Character) {
            return Float.valueOf(((Character)value).charValue());
        }
        if (value instanceof Integer) {
            return Float.valueOf(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return Float.valueOf(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        throw Def.castException(value.getClass(), Float.class, false);
    }

    public static Double defToDoubleImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (double)((Byte)value);
        }
        if (value instanceof Short) {
            return (double)((Short)value);
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return (double)((Integer)value);
        }
        if (value instanceof Long) {
            return (double)((Long)value);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        throw Def.castException(value.getClass(), Double.class, false);
    }

    public static Byte defToByteExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (byte)((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).byteValue();
        }
        throw Def.castException(value.getClass(), Byte.class, false);
    }

    public static Short defToShortExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).shortValue();
        }
        throw Def.castException(value.getClass(), Short.class, false);
    }

    public static Character defToCharacterExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Character.valueOf(Utility.StringTochar((String)value));
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return Character.valueOf((char)((Number)value).intValue());
        }
        throw Def.castException(value.getClass(), Character.class, false);
    }

    public static Integer defToIntegerExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).intValue();
        }
        throw Def.castException(value.getClass(), Integer.class, false);
    }

    public static Long defToLongExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).longValue();
        }
        throw Def.castException(value.getClass(), Long.class, false);
    }

    public static Float defToFloatExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return Float.valueOf(((Character)value).charValue());
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return Float.valueOf(((Number)value).floatValue());
        }
        throw Def.castException(value.getClass(), Float.class, false);
    }

    public static Double defToDoubleExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ((Number)value).doubleValue();
        }
        throw Def.castException(value.getClass(), Double.class, false);
    }

    public static String defToStringImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw Def.castException(value.getClass(), String.class, true);
    }

    public static String defToStringExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return Utility.charToString(((Character)value).charValue());
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw Def.castException(value.getClass(), String.class, false);
    }

    public static Object mapIndexNormalize(Map<?, ?> value, Object index) {
        return index;
    }

    public static int listIndexNormalize(List<?> value, int index) {
        return index >= 0 ? index : value.size() + index;
    }

    static {
        MethodHandles.Lookup methodHandlesLookup = MethodHandles.lookup();
        try {
            MAP_GET = methodHandlesLookup.findVirtual(Map.class, "get", MethodType.methodType(Object.class, Object.class));
            MAP_PUT = methodHandlesLookup.findVirtual(Map.class, "put", MethodType.methodType(Object.class, Object.class, Object.class));
            LIST_GET = methodHandlesLookup.findVirtual(List.class, "get", MethodType.methodType(Object.class, Integer.TYPE));
            LIST_SET = methodHandlesLookup.findVirtual(List.class, "set", MethodType.methodType(Object.class, Integer.TYPE, Object.class));
            OBJECT_ITERATOR = MethodHandles.filterReturnValue(methodHandlesLookup.findVirtual(Iterable.class, "iterator", MethodType.methodType(Iterator.class)), methodHandlesLookup.findConstructor(ObjectIterator.class, MethodType.methodType(Void.TYPE, Iterator.class)));
            MAP_INDEX_NORMALIZE = methodHandlesLookup.findStatic(Def.class, "mapIndexNormalize", MethodType.methodType(Object.class, Map.class, Object.class));
            LIST_INDEX_NORMALIZE = methodHandlesLookup.findStatic(Def.class, "listIndexNormalize", MethodType.methodType(Integer.TYPE, List.class, Integer.TYPE));
            ARRAY_LENGTH = methodHandlesLookup.findStatic(MethodHandles.class, "arrayLength", MethodType.methodType(MethodHandle.class, Class.class));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError((Object)roe);
        }
        HashMap<Class<Double>, MethodHandle> defToBoxedTypeImplicitCast = new HashMap<Class<Double>, MethodHandle>();
        try {
            defToBoxedTypeImplicitCast.put(Byte.class, methodHandlesLookup.findStatic(Def.class, "defToByteImplicit", MethodType.methodType(Byte.class, Object.class)));
            defToBoxedTypeImplicitCast.put(Short.class, methodHandlesLookup.findStatic(Def.class, "defToShortImplicit", MethodType.methodType(Short.class, Object.class)));
            defToBoxedTypeImplicitCast.put(Character.class, methodHandlesLookup.findStatic(Def.class, "defToCharacterImplicit", MethodType.methodType(Character.class, Object.class)));
            defToBoxedTypeImplicitCast.put(Integer.class, methodHandlesLookup.findStatic(Def.class, "defToIntegerImplicit", MethodType.methodType(Integer.class, Object.class)));
            defToBoxedTypeImplicitCast.put(Long.class, methodHandlesLookup.findStatic(Def.class, "defToLongImplicit", MethodType.methodType(Long.class, Object.class)));
            defToBoxedTypeImplicitCast.put(Float.class, methodHandlesLookup.findStatic(Def.class, "defToFloatImplicit", MethodType.methodType(Float.class, Object.class)));
            defToBoxedTypeImplicitCast.put(Double.class, methodHandlesLookup.findStatic(Def.class, "defToDoubleImplicit", MethodType.methodType(Double.class, Object.class)));
        }
        catch (IllegalAccessException | NoSuchMethodException exception) {
            throw new IllegalStateException(exception);
        }
        DEF_TO_BOXED_TYPE_IMPLICIT_CAST = Collections.unmodifiableMap(defToBoxedTypeImplicitCast);
    }

    public static class Encoding {
        public final boolean isStatic;
        public final boolean needsInstance;
        public final String symbol;
        public final String methodName;
        public final int numCaptures;
        public final String encoding;
        private static final String FORMAT = "[SD][tf]symbol.methodName,numCaptures";

        public Encoding(boolean isStatic, boolean needsInstance, String symbol, String methodName, int numCaptures) {
            this.isStatic = isStatic;
            this.needsInstance = needsInstance;
            this.symbol = Objects.requireNonNull(symbol);
            this.methodName = Objects.requireNonNull(methodName);
            this.numCaptures = numCaptures;
            this.encoding = (isStatic ? "S" : "D") + (needsInstance ? "t" : "f") + symbol + "." + methodName + "," + numCaptures;
            if ("this".equals(symbol)) {
                if (!isStatic) {
                    throw new IllegalArgumentException("Def.Encoding must be static if symbol is 'this', encoding [" + this.encoding + "]");
                }
            } else if (needsInstance) {
                throw new IllegalArgumentException("Def.Encoding symbol must be 'this', not [" + symbol + "] if needsInstance, encoding [" + this.encoding + "]");
            }
            if (methodName.isEmpty()) {
                throw new IllegalArgumentException("methodName must be non-empty, encoding [" + this.encoding + "]");
            }
            if (numCaptures < 0) {
                throw new IllegalArgumentException("numCaptures must be non-negative, not [" + numCaptures + "], encoding: [" + this.encoding + "]");
            }
        }

        public Encoding(String encoding) {
            this.encoding = Objects.requireNonNull(encoding);
            if (encoding.length() < 6) {
                throw new IllegalArgumentException("Encoding too short. Minimum 6, given [" + encoding.length() + "], encoding: [" + encoding + "], format: [SD][tf]symbol.methodName,numCaptures");
            }
            this.isStatic = encoding.charAt(0) == 'S';
            this.needsInstance = encoding.charAt(1) == 't';
            int dotIndex = encoding.lastIndexOf(46);
            if (dotIndex < 2) {
                throw new IllegalArgumentException("Invalid symbol, could not find '.' at expected position after index 1, instead found index [" + dotIndex + "], encoding: [" + encoding + "], format: [SD][tf]symbol.methodName,numCaptures");
            }
            this.symbol = encoding.substring(2, dotIndex);
            int commaIndex = encoding.indexOf(44);
            if (commaIndex <= dotIndex) {
                throw new IllegalArgumentException("Invalid symbol, could not find ',' at expected position after '.' at [" + dotIndex + "], instead found index [" + commaIndex + "], encoding: [" + encoding + "], format: [SD][tf]symbol.methodName,numCaptures");
            }
            this.methodName = encoding.substring(dotIndex + 1, commaIndex);
            if (commaIndex == encoding.length() - 1) {
                throw new IllegalArgumentException("Invalid symbol, could not find ',' at expected position, instead found index [" + commaIndex + "], encoding: [" + encoding + "], format: [SD][tf]symbol.methodName,numCaptures");
            }
            this.numCaptures = Integer.parseUnsignedInt(encoding.substring(commaIndex + 1));
        }

        public String toString() {
            return this.encoding;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Encoding)) {
                return false;
            }
            Encoding encoding1 = (Encoding)o;
            return this.isStatic == encoding1.isStatic && this.needsInstance == encoding1.needsInstance && this.numCaptures == encoding1.numCaptures && Objects.equals(this.symbol, encoding1.symbol) && Objects.equals(this.methodName, encoding1.methodName) && Objects.equals(this.encoding, encoding1.encoding);
        }

        public int hashCode() {
            return Objects.hash(this.isStatic, this.needsInstance, this.symbol, this.methodName, this.numCaptures, this.encoding);
        }
    }

    private static final class ArrayIndexNormalizeHelper {
        private static final MethodHandles.Lookup PRIVATE_METHOD_HANDLES_LOOKUP = MethodHandles.lookup();
        private static final Map<Class<?>, MethodHandle> ARRAY_TYPE_MH_MAPPING = Collections.unmodifiableMap(Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, Object[].class).collect(Collectors.toMap(Function.identity(), type -> {
            try {
                return PRIVATE_METHOD_HANDLES_LOOKUP.findStatic(PRIVATE_METHOD_HANDLES_LOOKUP.lookupClass(), "normalizeIndex", MethodType.methodType(Integer.TYPE, type, Integer.TYPE));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        })));
        private static final MethodHandle OBJECT_ARRAY_MH = ARRAY_TYPE_MH_MAPPING.get(Object[].class);

        static int normalizeIndex(boolean[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(byte[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(short[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(int[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(long[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(char[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(float[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(double[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(Object[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static MethodHandle arrayIndexNormalizer(Class<?> arrayType) {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type must be an array");
            }
            MethodHandle handle = ARRAY_TYPE_MH_MAPPING.get(arrayType);
            return handle != null ? handle : OBJECT_ARRAY_MH.asType(OBJECT_ARRAY_MH.type().changeParameterType(0, arrayType));
        }

        private ArrayIndexNormalizeHelper() {
        }
    }

    private static final class ArrayIteratorHelper {
        private static final MethodHandles.Lookup PRIVATE_METHOD_HANDLES_LOOKUP = MethodHandles.lookup();
        private static final Map<Class<?>, MethodHandle> ARRAY_TYPE_MH_MAPPING = Collections.unmodifiableMap(Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, Object[].class).collect(Collectors.toMap(Function.identity(), type -> {
            try {
                return PRIVATE_METHOD_HANDLES_LOOKUP.findStatic(PRIVATE_METHOD_HANDLES_LOOKUP.lookupClass(), "iterator", MethodType.methodType(ValueIterator.class, type));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        })));
        private static final MethodHandle OBJECT_ARRAY_MH = ARRAY_TYPE_MH_MAPPING.get(Object[].class);

        static ValueIterator<Boolean> iterator(final boolean[] array) {
            return new BaseIterator<Boolean>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public boolean nextBoolean() {
                    return array[this.index++];
                }

                @Override
                public Boolean next() {
                    return this.nextBoolean();
                }
            };
        }

        static ValueIterator<Byte> iterator(final byte[] array) {
            return new BaseIterator<Byte>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public byte nextByte() {
                    return array[this.index++];
                }

                @Override
                public short nextShort() {
                    return this.nextByte();
                }

                @Override
                public char nextChar() {
                    return (char)this.nextByte();
                }

                @Override
                public int nextInt() {
                    return this.nextByte();
                }

                @Override
                public long nextLong() {
                    return this.nextByte();
                }

                @Override
                public float nextFloat() {
                    return this.nextByte();
                }

                @Override
                public double nextDouble() {
                    return this.nextByte();
                }

                @Override
                public Byte next() {
                    return this.nextByte();
                }
            };
        }

        static ValueIterator<Short> iterator(final short[] array) {
            return new BaseIterator<Short>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public byte nextByte() {
                    return (byte)this.nextShort();
                }

                @Override
                public short nextShort() {
                    return array[this.index++];
                }

                @Override
                public char nextChar() {
                    return (char)this.nextShort();
                }

                @Override
                public int nextInt() {
                    return this.nextShort();
                }

                @Override
                public long nextLong() {
                    return this.nextShort();
                }

                @Override
                public float nextFloat() {
                    return this.nextShort();
                }

                @Override
                public double nextDouble() {
                    return this.nextShort();
                }

                @Override
                public Short next() {
                    return this.nextShort();
                }
            };
        }

        static ValueIterator<Integer> iterator(final int[] array) {
            return new BaseIterator<Integer>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public byte nextByte() {
                    return (byte)this.nextInt();
                }

                @Override
                public short nextShort() {
                    return (short)this.nextInt();
                }

                @Override
                public char nextChar() {
                    return (char)this.nextInt();
                }

                @Override
                public int nextInt() {
                    return array[this.index++];
                }

                @Override
                public long nextLong() {
                    return this.nextInt();
                }

                @Override
                public float nextFloat() {
                    return this.nextInt();
                }

                @Override
                public double nextDouble() {
                    return this.nextInt();
                }

                @Override
                public Integer next() {
                    return this.nextInt();
                }
            };
        }

        static ValueIterator<Long> iterator(final long[] array) {
            return new BaseIterator<Long>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public byte nextByte() {
                    return (byte)this.nextLong();
                }

                @Override
                public short nextShort() {
                    return (short)this.nextLong();
                }

                @Override
                public char nextChar() {
                    return (char)this.nextLong();
                }

                @Override
                public int nextInt() {
                    return (int)this.nextLong();
                }

                @Override
                public long nextLong() {
                    return array[this.index++];
                }

                @Override
                public float nextFloat() {
                    return this.nextLong();
                }

                @Override
                public double nextDouble() {
                    return this.nextLong();
                }

                @Override
                public Long next() {
                    return this.nextLong();
                }
            };
        }

        static ValueIterator<Character> iterator(final char[] array) {
            return new BaseIterator<Character>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public byte nextByte() {
                    return (byte)this.nextChar();
                }

                @Override
                public short nextShort() {
                    return (short)this.nextChar();
                }

                @Override
                public char nextChar() {
                    return array[this.index++];
                }

                @Override
                public int nextInt() {
                    return this.nextChar();
                }

                @Override
                public long nextLong() {
                    return this.nextChar();
                }

                @Override
                public float nextFloat() {
                    return this.nextChar();
                }

                @Override
                public double nextDouble() {
                    return this.nextChar();
                }

                @Override
                public Character next() {
                    return Character.valueOf(this.nextChar());
                }
            };
        }

        static ValueIterator<Float> iterator(final float[] array) {
            return new BaseIterator<Float>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public byte nextByte() {
                    return (byte)this.nextFloat();
                }

                @Override
                public short nextShort() {
                    return (short)this.nextFloat();
                }

                @Override
                public char nextChar() {
                    return (char)this.nextFloat();
                }

                @Override
                public int nextInt() {
                    return (int)this.nextFloat();
                }

                @Override
                public long nextLong() {
                    return (long)this.nextFloat();
                }

                @Override
                public float nextFloat() {
                    return array[this.index++];
                }

                @Override
                public double nextDouble() {
                    return this.nextFloat();
                }

                @Override
                public Float next() {
                    return Float.valueOf(this.nextFloat());
                }
            };
        }

        static ValueIterator<Double> iterator(final double[] array) {
            return new BaseIterator<Double>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public byte nextByte() {
                    return (byte)this.nextDouble();
                }

                @Override
                public short nextShort() {
                    return (short)this.nextDouble();
                }

                @Override
                public char nextChar() {
                    return (char)this.nextDouble();
                }

                @Override
                public int nextInt() {
                    return (int)this.nextDouble();
                }

                @Override
                public long nextLong() {
                    return (long)this.nextDouble();
                }

                @Override
                public float nextFloat() {
                    return (float)this.nextDouble();
                }

                @Override
                public double nextDouble() {
                    return array[this.index++];
                }

                @Override
                public Double next() {
                    return this.nextDouble();
                }
            };
        }

        static ValueIterator<Object> iterator(final Object[] array) {
            return new BaseIterator<Object>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Object next() {
                    return array[this.index++];
                }
            };
        }

        static MethodHandle newIterator(Class<?> arrayType) {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type must be an array");
            }
            MethodHandle iterator = ARRAY_TYPE_MH_MAPPING.get(arrayType);
            return iterator != null ? iterator : OBJECT_ARRAY_MH.asType(OBJECT_ARRAY_MH.type().changeParameterType(0, arrayType));
        }

        private ArrayIteratorHelper() {
        }
    }

    private static class ObjectIterator<T>
    extends BaseIterator<T> {
        private final Iterator<T> iterator;

        ObjectIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.iterator.forEachRemaining(action);
        }
    }

    private static abstract class BaseIterator<T>
    implements ValueIterator<T> {
        private BaseIterator() {
        }

        @Override
        public boolean nextBoolean() {
            Object next = this.next();
            try {
                return (Boolean)next;
            }
            catch (ClassCastException e) {
                throw Def.castException(next.getClass(), Boolean.TYPE, null);
            }
        }

        @Override
        public byte nextByte() {
            Object next = this.next();
            try {
                return ((Number)next).byteValue();
            }
            catch (ClassCastException e) {
                throw Def.castException(next.getClass(), Byte.TYPE, null);
            }
        }

        @Override
        public short nextShort() {
            Object next = this.next();
            try {
                return ((Number)next).shortValue();
            }
            catch (ClassCastException e) {
                throw Def.castException(next.getClass(), Short.TYPE, null);
            }
        }

        @Override
        public char nextChar() {
            Object next = this.next();
            try {
                return ((Character)next).charValue();
            }
            catch (ClassCastException e) {
                throw Def.castException(next.getClass(), Character.TYPE, null);
            }
        }

        @Override
        public int nextInt() {
            Object next = this.next();
            try {
                return ((Number)next).intValue();
            }
            catch (ClassCastException e) {
                throw Def.castException(next.getClass(), Integer.TYPE, null);
            }
        }

        @Override
        public long nextLong() {
            Object next = this.next();
            try {
                return ((Number)next).longValue();
            }
            catch (ClassCastException e) {
                throw Def.castException(next.getClass(), Long.TYPE, null);
            }
        }

        @Override
        public float nextFloat() {
            Object next = this.next();
            try {
                return ((Number)next).floatValue();
            }
            catch (ClassCastException e) {
                throw Def.castException(next.getClass(), Float.TYPE, null);
            }
        }

        @Override
        public double nextDouble() {
            Object next = this.next();
            try {
                return ((Number)next).doubleValue();
            }
            catch (ClassCastException e) {
                throw Def.castException(next.getClass(), Double.TYPE, null);
            }
        }
    }
}

