/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.geoip.Database;
import org.elasticsearch.ingest.geoip.IpDataLookup;
import org.elasticsearch.ingest.geoip.IpDatabase;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.DatabaseRecord;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.MaxMindDbConstructor;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.MaxMindDbParameter;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.Reader;

final class IpinfoIpDataLookups {
    private static final Logger logger = LogManager.getLogger(IpinfoIpDataLookups.class);
    static final String IPINFO_PREFIX = "ipinfo";
    private static final Set<String> IPINFO_TYPE_STOP_WORDS = Set.of("ipinfo", "extended", "free", "generic", "ip", "sample", "standard", "mmdb");

    private IpinfoIpDataLookups() {
    }

    static String ipinfoTypeCleanup(String type) {
        List<String> parts = Arrays.asList(type.split("[ _.]"));
        return parts.stream().filter(s -> !IPINFO_TYPE_STOP_WORDS.contains(s)).collect(Collectors.joining("_"));
    }

    @Nullable
    static Database getIpinfoDatabase(String databaseType) {
        String cleanedType = IpinfoIpDataLookups.ipinfoTypeCleanup(databaseType);
        if (databaseType.contains("extended")) {
            logger.trace("returning null for unsupported database_type [{}]", (Object)databaseType);
            return null;
        }
        if (cleanedType.contains("country_asn")) {
            logger.trace("returning null for unsupported database_type [{}]", (Object)databaseType);
            return null;
        }
        if (cleanedType.contains("asn")) {
            return Database.AsnV2;
        }
        if (cleanedType.contains("country")) {
            return Database.CountryV2;
        }
        if (cleanedType.contains("location")) {
            return Database.CityV2;
        }
        if (cleanedType.contains("privacy")) {
            return Database.PrivacyDetection;
        }
        logger.trace("returning null for unsupported database_type [{}]", (Object)databaseType);
        return null;
    }

    @Nullable
    static Function<Set<Database.Property>, IpDataLookup> getIpinfoLookup(Database database) {
        return switch (database) {
            case Database.AsnV2 -> Asn::new;
            case Database.CountryV2 -> Country::new;
            case Database.CityV2 -> Geolocation::new;
            case Database.PrivacyDetection -> PrivacyDetection::new;
            default -> null;
        };
    }

    static Long parseAsn(String asn) {
        if (asn == null || !Strings.hasText(asn)) {
            return null;
        }
        String stripped = asn.toUpperCase(Locale.ROOT).replaceAll("AS", "").trim();
        try {
            return Long.parseLong(stripped);
        }
        catch (NumberFormatException e) {
            logger.trace("Unable to parse non-compliant ASN string [{}]", (Object)asn);
            return null;
        }
    }

    static Boolean parseBoolean(String bool) {
        if (bool == null) {
            return null;
        }
        String trimmed = bool.toLowerCase(Locale.ROOT).trim();
        if ("true".equals(trimmed)) {
            return true;
        }
        if ("false".equals(trimmed)) {
            return false;
        }
        if (trimmed.isEmpty()) {
            return false;
        }
        logger.trace("Unable to parse non-compliant boolean string [{}]", (Object)bool);
        return null;
    }

    static Double parseLocationDouble(String latlon) {
        if (latlon == null || !Strings.hasText(latlon)) {
            return null;
        }
        String stripped = latlon.trim();
        try {
            return Double.parseDouble(stripped);
        }
        catch (NumberFormatException e) {
            logger.trace("Unable to parse non-compliant location string [{}]", (Object)latlon);
            return null;
        }
    }

    private static abstract class AbstractBase<RESPONSE>
    implements IpDataLookup {
        protected final Set<Database.Property> properties;
        protected final Class<RESPONSE> clazz;

        AbstractBase(Set<Database.Property> properties, Class<RESPONSE> clazz) {
            this.properties = Set.copyOf(properties);
            this.clazz = clazz;
        }

        @Override
        public Set<Database.Property> getProperties() {
            return this.properties;
        }

        @Override
        public final Map<String, Object> getData(IpDatabase ipDatabase, String ipAddress) {
            IpDataLookup.Result response = ipDatabase.getResponse(ipAddress, this::lookup);
            return response == null || response.result() == null ? Map.of() : this.transform(response);
        }

        @Nullable
        private IpDataLookup.Result<RESPONSE> lookup(Reader reader, String ipAddress) throws IOException {
            InetAddress ip = InetAddresses.forString(ipAddress);
            DatabaseRecord<RESPONSE> entry = reader.getRecord(ip, this.clazz);
            RESPONSE data = entry.getData();
            return data == null ? null : new IpDataLookup.Result<RESPONSE>(data, NetworkAddress.format(ip), entry.getNetwork().toString());
        }

        protected abstract Map<String, Object> transform(IpDataLookup.Result<RESPONSE> var1);
    }

    static class PrivacyDetection
    extends AbstractBase<PrivacyDetectionResult> {
        PrivacyDetection(Set<Database.Property> properties) {
            super(properties, PrivacyDetectionResult.class);
        }

        @Override
        protected Map<String, Object> transform(IpDataLookup.Result<PrivacyDetectionResult> result) {
            PrivacyDetectionResult response = result.result();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", result.ip());
                        break;
                    }
                    case HOSTING: {
                        if (response.hosting == null) break;
                        data.put("hosting", response.hosting);
                        break;
                    }
                    case TOR: {
                        if (response.tor == null) break;
                        data.put("tor", response.tor);
                        break;
                    }
                    case PROXY: {
                        if (response.proxy == null) break;
                        data.put("proxy", response.proxy);
                        break;
                    }
                    case RELAY: {
                        if (response.relay == null) break;
                        data.put("relay", response.relay);
                        break;
                    }
                    case VPN: {
                        if (response.vpn == null) break;
                        data.put("vpn", response.vpn);
                        break;
                    }
                    case SERVICE: {
                        if (!Strings.hasText(response.service)) break;
                        data.put("service", response.service);
                    }
                }
            }
            return data;
        }
    }

    static class Geolocation
    extends AbstractBase<GeolocationResult> {
        Geolocation(Set<Database.Property> properties) {
            super(properties, GeolocationResult.class);
        }

        @Override
        protected Map<String, Object> transform(IpDataLookup.Result<GeolocationResult> result) {
            GeolocationResult response = result.result();
            HashMap<String, Object> data = new HashMap<String, Object>();
            block9: for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", result.ip());
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        String countryIsoCode = response.country;
                        if (countryIsoCode == null) continue block9;
                        data.put("country_iso_code", countryIsoCode);
                        break;
                    }
                    case REGION_NAME: {
                        String subdivisionName = response.region;
                        if (subdivisionName == null) continue block9;
                        data.put("region_name", subdivisionName);
                        break;
                    }
                    case CITY_NAME: {
                        String cityName = response.city;
                        if (cityName == null) continue block9;
                        data.put("city_name", cityName);
                        break;
                    }
                    case TIMEZONE: {
                        String locationTimeZone = response.timezone;
                        if (locationTimeZone == null) continue block9;
                        data.put("timezone", locationTimeZone);
                        break;
                    }
                    case POSTAL_CODE: {
                        String postalCode = response.postalCode;
                        if (postalCode == null) continue block9;
                        data.put("postal_code", postalCode);
                        break;
                    }
                    case LOCATION: {
                        Double latitude = response.lat;
                        Double longitude = response.lng;
                        if (latitude == null || longitude == null) break;
                        HashMap<String, Double> locationObject = new HashMap<String, Double>();
                        locationObject.put("lat", latitude);
                        locationObject.put("lon", longitude);
                        data.put("location", locationObject);
                    }
                }
            }
            return data;
        }
    }

    static class Country
    extends AbstractBase<CountryResult> {
        Country(Set<Database.Property> properties) {
            super(properties, CountryResult.class);
        }

        @Override
        protected Map<String, Object> transform(IpDataLookup.Result<CountryResult> result) {
            CountryResult response = result.result();
            HashMap<String, Object> data = new HashMap<String, Object>();
            block7: for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", result.ip());
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        String countryIsoCode = response.country;
                        if (countryIsoCode == null) continue block7;
                        data.put("country_iso_code", countryIsoCode);
                        break;
                    }
                    case COUNTRY_NAME: {
                        String countryName = response.countryName;
                        if (countryName == null) continue block7;
                        data.put("country_name", countryName);
                        break;
                    }
                    case CONTINENT_CODE: {
                        String continentCode = response.continent;
                        if (continentCode == null) continue block7;
                        data.put("continent_code", continentCode);
                        break;
                    }
                    case CONTINENT_NAME: {
                        String continentName = response.continentName;
                        if (continentName == null) break;
                        data.put("continent_name", continentName);
                    }
                }
            }
            return data;
        }
    }

    static class Asn
    extends AbstractBase<AsnResult> {
        Asn(Set<Database.Property> properties) {
            super(properties, AsnResult.class);
        }

        @Override
        protected Map<String, Object> transform(IpDataLookup.Result<AsnResult> result) {
            AsnResult response = result.result();
            Long asn = response.asn;
            String organizationName = response.name;
            String network = result.network();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", result.ip());
                        break;
                    }
                    case ASN: {
                        if (asn == null) break;
                        data.put("asn", asn);
                        break;
                    }
                    case ORGANIZATION_NAME: {
                        if (organizationName == null) break;
                        data.put("organization_name", organizationName);
                        break;
                    }
                    case NETWORK: {
                        if (network == null) break;
                        data.put("network", network);
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        if (response.country == null) break;
                        data.put("country_iso_code", response.country);
                        break;
                    }
                    case DOMAIN: {
                        if (response.domain == null) break;
                        data.put("domain", response.domain);
                        break;
                    }
                    case TYPE: {
                        if (response.type == null) break;
                        data.put("type", response.type);
                    }
                }
            }
            return data;
        }
    }

    public record PrivacyDetectionResult(Boolean hosting, Boolean proxy, Boolean relay, String service, Boolean tor, Boolean vpn) {
        @MaxMindDbConstructor
        public PrivacyDetectionResult(@MaxMindDbParameter(name="hosting") String hosting, @MaxMindDbParameter(name="proxy") String proxy, @MaxMindDbParameter(name="relay") String relay, @MaxMindDbParameter(name="service") String service, @MaxMindDbParameter(name="tor") String tor, @MaxMindDbParameter(name="vpn") String vpn) {
            this(IpinfoIpDataLookups.parseBoolean(hosting), IpinfoIpDataLookups.parseBoolean(proxy), IpinfoIpDataLookups.parseBoolean(relay), service, IpinfoIpDataLookups.parseBoolean(tor), IpinfoIpDataLookups.parseBoolean(vpn));
        }
    }

    public record GeolocationResult(String city, String country, Double lat, Double lng, String postalCode, String region, String timezone) {
        @MaxMindDbConstructor
        public GeolocationResult(@MaxMindDbParameter(name="city") String city, @MaxMindDbParameter(name="country") String country, @MaxMindDbParameter(name="lat") String lat, @MaxMindDbParameter(name="lng") String lng, @MaxMindDbParameter(name="postal_code") String postalCode, @MaxMindDbParameter(name="region") String region, @MaxMindDbParameter(name="timezone") String timezone) {
            this(city, country, IpinfoIpDataLookups.parseLocationDouble(lat), IpinfoIpDataLookups.parseLocationDouble(lng), postalCode, region, timezone);
        }
    }

    public record CountryResult(@MaxMindDbParameter(name="continent") String continent, @MaxMindDbParameter(name="continent_name") String continentName, @MaxMindDbParameter(name="country") String country, @MaxMindDbParameter(name="country_name") String countryName) {
    }

    public record AsnResult(Long asn, @Nullable String country, String domain, String name, @Nullable String type) {
        @MaxMindDbConstructor
        public AsnResult(@MaxMindDbParameter(name="asn") String asn, @Nullable @MaxMindDbParameter(name="country") String country, @MaxMindDbParameter(name="domain") String domain, @MaxMindDbParameter(name="name") String name, @Nullable @MaxMindDbParameter(name="type") String type) {
            this(IpinfoIpDataLookups.parseAsn(asn), country, domain, name, type);
        }
    }
}

