/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class DissectProcessor
extends AbstractProcessor {
    public static final String TYPE = "dissect";
    final String field;
    final boolean ignoreMissing;
    final String pattern;
    final String appendSeparator;
    final DissectParser dissectParser;

    DissectProcessor(String tag, String description, String field, String pattern, String appendSeparator, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.ignoreMissing = ignoreMissing;
        this.pattern = pattern;
        this.appendSeparator = appendSeparator;
        this.dissectParser = new DissectParser(pattern, appendSeparator);
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) {
        String input = ingestDocument.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (input == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (input == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        this.dissectParser.forceParse(input).forEach(ingestDocument::setFieldValue);
        return ingestDocument;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        @Override
        public DissectProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty(DissectProcessor.TYPE, processorTag, config, "field");
            String pattern = ConfigurationUtils.readStringProperty(DissectProcessor.TYPE, processorTag, config, "pattern");
            String appendSeparator = ConfigurationUtils.readStringProperty(DissectProcessor.TYPE, processorTag, config, "append_separator", "");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(DissectProcessor.TYPE, processorTag, config, "ignore_missing", false);
            return new DissectProcessor(processorTag, description, field, pattern, appendSeparator, ignoreMissing);
        }
    }
}

