/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.CaseInsensitivePrefixQuery;
import org.elasticsearch.common.lucene.search.CaseInsensitiveWildcardQuery;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.SearchService;

public abstract class StringFieldType
extends TermBasedFieldType {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(\\\\.)|([?*]+)");

    public StringFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, isIndexed, isStored, hasDocValues, textSearchInfo, meta);
    }

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[fuzzy] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        return rewriteMethod == null ? new FuzzyQuery(new Term(this.name(), this.indexedValueForSearch(value)), fuzziness.asDistance(BytesRefs.toString(value)), prefixLength, maxExpansions, transpositions) : new FuzzyQuery(new Term(this.name(), this.indexedValueForSearch(value)), fuzziness.asDistance(BytesRefs.toString(value)), prefixLength, maxExpansions, transpositions, rewriteMethod);
    }

    @Override
    public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[prefix] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false. For optimised prefix queries on text fields please enable [index_prefixes].", new Object[0]);
        }
        this.failIfNotIndexed();
        Term prefix = new Term(this.name(), this.indexedValueForSearch(value));
        if (caseInsensitive) {
            return method == null ? new CaseInsensitivePrefixQuery(prefix, 10000, false) : new CaseInsensitivePrefixQuery(prefix, 10000, false, method);
        }
        return method == null ? new PrefixQuery(prefix) : new PrefixQuery(prefix, method);
    }

    public static final String normalizeWildcardPattern(String fieldname, String value, Analyzer normalizer) {
        BytesRef normalized;
        String chunk;
        if (normalizer == null) {
            return value;
        }
        Matcher wildcardMatcher = WILDCARD_PATTERN.matcher(value);
        BytesRefBuilder sb = new BytesRefBuilder();
        int last = 0;
        while (wildcardMatcher.find()) {
            if (wildcardMatcher.start() > 0) {
                chunk = value.substring(last, wildcardMatcher.start());
                normalized = normalizer.normalize(fieldname, chunk);
                sb.append(normalized);
            }
            sb.append(new BytesRef(wildcardMatcher.group()));
            last = wildcardMatcher.end();
        }
        if (last < value.length()) {
            chunk = value.substring(last);
            normalized = normalizer.normalize(fieldname, chunk);
            sb.append(normalized);
        }
        return sb.toBytesRef().utf8ToString();
    }

    @Override
    public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        return this.wildcardQuery(value, method, caseInsensitive, false, context);
    }

    @Override
    public Query normalizedWildcardQuery(String value, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
        return this.wildcardQuery(value, method, false, true, context);
    }

    protected Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, boolean shouldNormalize, SearchExecutionContext context) {
        Term term;
        this.failIfNotIndexed();
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[wildcard] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        if (this.getTextSearchInfo().searchAnalyzer() != null && shouldNormalize) {
            value = StringFieldType.normalizeWildcardPattern(this.name(), value, this.getTextSearchInfo().searchAnalyzer());
            term = new Term(this.name(), value);
        } else {
            term = new Term(this.name(), this.indexedValueForSearch(value));
        }
        if (caseInsensitive) {
            return method == null ? new CaseInsensitiveWildcardQuery(term) : new CaseInsensitiveWildcardQuery(term, 10000, false, method);
        }
        return method == null ? new WildcardQuery(term) : new WildcardQuery(term, 10000, method);
    }

    @Override
    public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[regexp] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        return method == null ? new RegexpQuery(new Term(this.name(), this.indexedValueForSearch(value)), syntaxFlags, matchFlags, maxDeterminizedStates) : new RegexpQuery(new Term(this.name(), this.indexedValueForSearch(value)), syntaxFlags, matchFlags, RegexpQuery.DEFAULT_PROVIDER, maxDeterminizedStates, method);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[range] queries on [text] or [keyword] fields cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
    }
}

