/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PlaceHolderFieldMapper
extends FieldMapper {
    public static final Function<String, FieldMapper.TypeParser> PARSER = type -> new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (String)type));
    protected final Map<String, Object> unknownParams = new LinkedHashMap<String, Object>();

    public PlaceHolderFieldMapper(String simpleName, PlaceHolderFieldType fieldType, FieldMapper.BuilderParams builderParams, Map<String, Object> unknownParams) {
        super(simpleName, fieldType, builderParams);
        this.unknownParams.putAll(unknownParams);
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        throw new IllegalArgumentException("can't parse value for placeholder field type");
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.typeName()).init(this);
    }

    @Override
    protected String contentType() {
        return this.typeName();
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final String type;
        protected final Map<String, Object> unknownParams = new LinkedHashMap<String, Object>();

        public Builder(String name, String type) {
            super(name);
            this.type = type;
        }

        @Override
        public FieldMapper.Builder init(FieldMapper initializer) {
            assert (initializer instanceof PlaceHolderFieldMapper);
            this.unknownParams.putAll(((PlaceHolderFieldMapper)initializer).unknownParams);
            return super.init(initializer);
        }

        @Override
        protected void merge(FieldMapper in, FieldMapper.Conflicts conflicts, MapperMergeContext mapperMergeContext) {
            assert (in instanceof PlaceHolderFieldMapper);
            this.unknownParams.putAll(((PlaceHolderFieldMapper)in).unknownParams);
            super.merge(in, conflicts, mapperMergeContext);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder = super.toXContent(builder, params);
            for (Map.Entry<String, Object> unknownParam : this.unknownParams.entrySet()) {
                builder.field(unknownParam.getKey(), unknownParam.getValue());
            }
            return builder;
        }

        @Override
        protected void handleUnknownParamOnLegacyIndex(String propName, Object propNode) {
            this.unknownParams.put(propName, propNode);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return FieldMapper.EMPTY_PARAMETERS;
        }

        @Override
        public PlaceHolderFieldMapper build(MapperBuilderContext context) {
            PlaceHolderFieldType mappedFieldType = new PlaceHolderFieldType(context.buildFullName(this.leafName()), this.type, Map.of());
            return new PlaceHolderFieldMapper(this.leafName(), mappedFieldType, this.builderParams(this, context), this.unknownParams);
        }
    }

    public static final class PlaceHolderFieldType
    extends MappedFieldType {
        private String type;

        public PlaceHolderFieldType(String name, String type, Map<String, String> meta) {
            super(name, false, false, false, TextSearchInfo.NONE, meta);
            this.type = type;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new SourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        @Override
        public String typeName() {
            return this.type;
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("term query"), new Object[0]);
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, @Nullable SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("case insensitive term query"), new Object[0]);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("range query"), new Object[0]);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("fuzzy query"), new Object[0]);
        }

        @Override
        public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("prefix query"), new Object[0]);
        }

        @Override
        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("wildcard query"), new Object[0]);
        }

        @Override
        public Query normalizedWildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("normalized wildcard query"), new Object[0]);
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("regexp query"), new Object[0]);
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("phrase query"), new Object[0]);
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("multi-phrase query"), new Object[0]);
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext context) throws IOException {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("phrase prefix query"), new Object[0]);
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("span prefix query"), new Object[0]);
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("distance feature query"), new Object[0]);
        }

        @Override
        public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("term intervals query"), new Object[0]);
        }

        @Override
        public IntervalsSource prefixIntervals(BytesRef prefix, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("term intervals query"), new Object[0]);
        }

        @Override
        public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("fuzzy intervals query"), new Object[0]);
        }

        @Override
        public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("wildcard intervals query"), new Object[0]);
        }

        @Override
        public IntervalsSource regexpIntervals(BytesRef pattern, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("regexp intervals query"), new Object[0]);
        }

        @Override
        public IntervalsSource rangeIntervals(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, this.fail("range intervals query"), new Object[0]);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException(this.fail("aggregation or sorts"));
        }

        private String fail(String query) {
            return "can't run " + query + " on field type " + this.type + " of legacy index";
        }
    }
}

