/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class IgnoreMalformedStoredValues {
    private static final Empty EMPTY = new Empty();

    public static StoredField storedField(String name, XContentParser parser) throws IOException {
        return XContentDataHelper.storedField(IgnoreMalformedStoredValues.name(name), parser);
    }

    public static StoredField storedField(String name, XContentBuilder builder) throws IOException {
        return XContentDataHelper.storedField(IgnoreMalformedStoredValues.name(name), builder);
    }

    public static IgnoreMalformedStoredValues empty() {
        return EMPTY;
    }

    public static IgnoreMalformedStoredValues stored(String fieldName) {
        return new Stored(fieldName);
    }

    public abstract Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders();

    public abstract int count();

    public abstract void write(XContentBuilder var1) throws IOException;

    public abstract void reset();

    public static String name(String fieldName) {
        return fieldName + "._ignore_malformed";
    }

    private static class Empty
    extends IgnoreMalformedStoredValues {
        private Empty() {
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.empty();
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
        }

        @Override
        public void reset() {
        }
    }

    private static class Stored
    extends IgnoreMalformedStoredValues {
        private final String fieldName;
        private List<Object> values = Collections.emptyList();

        Stored(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(Map.entry(Stored.name(this.fieldName), newValues -> {
                this.values = newValues;
            }));
        }

        @Override
        public int count() {
            return this.values.size();
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            for (Object v : this.values) {
                if (v instanceof BytesRef) {
                    BytesRef r = (BytesRef)v;
                    XContentDataHelper.decodeAndWrite(b, r);
                    continue;
                }
                b.value(v);
            }
            this.reset();
        }

        @Override
        public void reset() {
            this.values = Collections.emptyList();
        }
    }
}

