/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.Version;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.NormalizingTokenFilterFactory;
import org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenFilter
extends PreConfiguredAnalysisComponent<TokenFilterFactory> {
    private final boolean useFilterForMultitermQueries;
    private final boolean allowForSynonymParsing;
    private final BiFunction<TokenStream, IndexVersion, TokenStream> create;

    public static PreConfiguredTokenFilter singleton(String name, boolean useFilterForMultitermQueries, Function<TokenStream, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream));
    }

    public static PreConfiguredTokenFilter singleton(String name, boolean useFilterForMultitermQueries, boolean allowForSynonymParsing, Function<TokenStream, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, allowForSynonymParsing, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream));
    }

    public static PreConfiguredTokenFilter luceneVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.LUCENE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream, version.luceneVersion()));
    }

    public static PreConfiguredTokenFilter indexVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, IndexVersion, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.INDEX, create);
    }

    public static PreConfiguredTokenFilter indexVersion(String name, boolean useFilterForMultitermQueries, boolean useFilterForParsingSynonyms, BiFunction<TokenStream, IndexVersion, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, useFilterForParsingSynonyms, PreBuiltCacheFactory.CachingStrategy.INDEX, create);
    }

    private PreConfiguredTokenFilter(String name, boolean useFilterForMultitermQueries, boolean allowForSynonymParsing, PreBuiltCacheFactory.CachingStrategy cache, BiFunction<TokenStream, IndexVersion, TokenStream> create) {
        super(name, cache);
        this.useFilterForMultitermQueries = useFilterForMultitermQueries;
        this.allowForSynonymParsing = allowForSynonymParsing;
        this.create = create;
    }

    @Override
    protected TokenFilterFactory create(final IndexVersion version) {
        if (this.useFilterForMultitermQueries) {
            return new NormalizingTokenFilterFactory(){

                @Override
                public TokenStream normalize(TokenStream tokenStream) {
                    return PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
                }

                @Override
                public String name() {
                    return PreConfiguredTokenFilter.this.getName();
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
                }

                @Override
                public TokenFilterFactory getSynonymFilter() {
                    if (PreConfiguredTokenFilter.this.allowForSynonymParsing) {
                        return this;
                    }
                    throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
                }
            };
        }
        return new TokenFilterFactory(){

            @Override
            public String name() {
                return PreConfiguredTokenFilter.this.getName();
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
            }

            @Override
            public TokenFilterFactory getSynonymFilter() {
                if (PreConfiguredTokenFilter.this.allowForSynonymParsing) {
                    return this;
                }
                throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
            }
        };
    }
}

