/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringBuilders;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogMessage;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.SlowLogFields;
import org.elasticsearch.index.SlowLogLevel;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;

public final class IndexingSlowLog
implements IndexingOperationListener {
    public static final String INDEX_INDEXING_SLOWLOG_PREFIX = "index.indexing.slowlog";
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING = Setting.timeSetting("index.indexing.slowlog.threshold.index.warn", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING = Setting.timeSetting("index.indexing.slowlog.threshold.index.info", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING = Setting.timeSetting("index.indexing.slowlog.threshold.index.debug", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING = Setting.timeSetting("index.indexing.slowlog.threshold.index.trace", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING = Setting.boolSetting("index.indexing.slowlog.reformat", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_INDEXING_SLOWLOG_INCLUDE_USER_SETTING = Setting.boolSetting("index.indexing.slowlog.include.user", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    @Deprecated
    public static final Setting<SlowLogLevel> INDEX_INDEXING_SLOWLOG_LEVEL_SETTING = new Setting<SlowLogLevel>("index.indexing.slowlog.level", SlowLogLevel.TRACE.name(), SlowLogLevel::parse, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.IndexSettingDeprecatedInV7AndRemovedInV8);
    private static final Logger indexLogger = LogManager.getLogger((String)"index.indexing.slowlog.index");
    private final Index index;
    private boolean reformat;
    private long indexWarnThreshold;
    private long indexInfoThreshold;
    private long indexDebugThreshold;
    private long indexTraceThreshold;
    private int maxSourceCharsToLog;
    private final SlowLogFields slowLogFields;
    public static final Setting<Integer> INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING = new Setting<Integer>("index.indexing.slowlog.source", "1000", value -> {
        try {
            return Integer.parseInt(value, 10);
        }
        catch (NumberFormatException e) {
            return Booleans.parseBoolean(value, true) ? Integer.MAX_VALUE : 0;
        }
    }, Setting.Property.Dynamic, Setting.Property.IndexScope);

    IndexingSlowLog(IndexSettings indexSettings, SlowLogFields slowLogFields) {
        this.slowLogFields = slowLogFields;
        this.index = indexSettings.getIndex();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING, this::setReformat);
        this.reformat = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING);
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING, this::setWarnThreshold);
        this.indexWarnThreshold = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING, this::setInfoThreshold);
        this.indexInfoThreshold = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING, this::setDebugThreshold);
        this.indexDebugThreshold = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING, this::setTraceThreshold);
        this.indexTraceThreshold = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING, this::setMaxSourceCharsToLog);
        this.maxSourceCharsToLog = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING);
    }

    private void setMaxSourceCharsToLog(int maxSourceCharsToLog) {
        this.maxSourceCharsToLog = maxSourceCharsToLog;
    }

    private void setWarnThreshold(TimeValue warnThreshold) {
        this.indexWarnThreshold = warnThreshold.nanos();
    }

    private void setInfoThreshold(TimeValue infoThreshold) {
        this.indexInfoThreshold = infoThreshold.nanos();
    }

    private void setDebugThreshold(TimeValue debugThreshold) {
        this.indexDebugThreshold = debugThreshold.nanos();
    }

    private void setTraceThreshold(TimeValue traceThreshold) {
        this.indexTraceThreshold = traceThreshold.nanos();
    }

    private void setReformat(boolean reformat) {
        this.reformat = reformat;
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index indexOperation, Engine.IndexResult result) {
        if (result.getResultType() == Engine.Result.Type.SUCCESS) {
            ParsedDocument doc = indexOperation.parsedDoc();
            long tookInNanos = result.getTook();
            if (this.indexWarnThreshold >= 0L && tookInNanos > this.indexWarnThreshold) {
                indexLogger.warn((Message)IndexingSlowLogMessage.of(this.slowLogFields.indexFields(), this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexInfoThreshold >= 0L && tookInNanos > this.indexInfoThreshold) {
                indexLogger.info((Message)IndexingSlowLogMessage.of(this.slowLogFields.indexFields(), this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexDebugThreshold >= 0L && tookInNanos > this.indexDebugThreshold) {
                indexLogger.debug((Message)IndexingSlowLogMessage.of(this.slowLogFields.indexFields(), this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexTraceThreshold >= 0L && tookInNanos > this.indexTraceThreshold) {
                indexLogger.trace((Message)IndexingSlowLogMessage.of(this.slowLogFields.indexFields(), this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            }
        }
    }

    boolean isReformat() {
        return this.reformat;
    }

    long getIndexWarnThreshold() {
        return this.indexWarnThreshold;
    }

    long getIndexInfoThreshold() {
        return this.indexInfoThreshold;
    }

    long getIndexTraceThreshold() {
        return this.indexTraceThreshold;
    }

    long getIndexDebugThreshold() {
        return this.indexDebugThreshold;
    }

    static final class IndexingSlowLogMessage {
        IndexingSlowLogMessage() {
        }

        public static ESLogMessage of(Map<String, String> additionalFields, Index index, ParsedDocument doc, long tookInNanos, boolean reformat, int maxSourceCharsToLog) {
            Map<String, Object> jsonFields = IndexingSlowLogMessage.prepareMap(index, doc, tookInNanos, reformat, maxSourceCharsToLog);
            jsonFields.putAll(additionalFields);
            return new ESLogMessage().withFields(jsonFields);
        }

        private static Map<String, Object> prepareMap(Index index, ParsedDocument doc, long tookInNanos, boolean reformat, int maxSourceCharsToLog) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("elasticsearch.slowlog.message", index);
            map.put("elasticsearch.slowlog.took", TimeValue.timeValueNanos(tookInNanos).toString());
            map.put("elasticsearch.slowlog.took_millis", String.valueOf(TimeUnit.NANOSECONDS.toMillis(tookInNanos)));
            map.put("elasticsearch.slowlog.id", doc.id());
            if (doc.routing() != null) {
                map.put("elasticsearch.slowlog.routing", doc.routing());
            }
            if (maxSourceCharsToLog == 0 || doc.source() == null || doc.source().length() == 0) {
                return map;
            }
            try {
                String source = XContentHelper.convertToJson(doc.source(), reformat, doc.getXContentType());
                String trim = Strings.cleanTruncate(source, maxSourceCharsToLog).trim();
                StringBuilder sb = new StringBuilder(trim);
                StringBuilders.escapeJson((StringBuilder)sb, (int)0);
                map.put("elasticsearch.slowlog.source", sb.toString());
            }
            catch (IOException e) {
                StringBuilder sb = new StringBuilder("_failed_to_convert_[" + e.getMessage() + "]");
                StringBuilders.escapeJson((StringBuilder)sb, (int)0);
                map.put("elasticsearch.slowlog.source", sb.toString());
                String message = String.format(Locale.ROOT, "failed to convert source for slow log entry [%s]", ((Object)map).toString());
                throw new UncheckedIOException(message, e);
            }
            return map;
        }
    }
}

