/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;

public record Diagnosis(Definition definition, @Nullable List<Resource> affectedResources) implements ChunkedToXContent
{
    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).object(ob -> {
            ob.append((b, p) -> {
                b.field("id", this.definition.getUniqueId());
                b.field("cause", this.definition.cause);
                b.field("action", this.definition.action);
                b.field("help_url", this.definition.helpURL);
                return b;
            });
            if (this.affectedResources != null && !this.affectedResources.isEmpty()) {
                ob.object("affected_resources", this.affectedResources.iterator(), ChunkedToXContentBuilder::append);
            }
        });
    }

    public record Definition(String indicatorName, String id, String cause, String action, String helpURL) {
        public String getUniqueId() {
            return "elasticsearch:health:" + this.indicatorName + ":diagnosis:" + this.id;
        }
    }

    public static class Resource
    implements ChunkedToXContent {
        public static final String ID_FIELD = "id";
        public static final String NAME_FIELD = "name";
        private final Type type;
        @Nullable
        private Collection<String> values;
        @Nullable
        private Collection<DiscoveryNode> nodes;

        public Resource(Type type, Collection<String> values) {
            if (type == Type.NODE) {
                throw new IllegalArgumentException("Nodes should be modelled using the dedicated constructor");
            }
            this.type = type;
            this.values = values;
        }

        public Resource(Collection<DiscoveryNode> nodes) {
            this.type = Type.NODE;
            this.nodes = nodes;
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            ChunkedToXContentBuilder builder = ChunkedToXContent.builder(params);
            if (this.nodes != null) {
                return builder.array(this.type.displayValue, this.nodes.iterator(), node -> (b, p) -> {
                    b.startObject();
                    b.field(ID_FIELD, node.getId());
                    if (node.getName() != null) {
                        b.field(NAME_FIELD, node.getName());
                    }
                    return b.endObject();
                });
            }
            return builder.array(this.type.displayValue, (String[])this.values.toArray(String[]::new));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            return this.type == resource.type && Objects.equals(this.values, resource.values) && Objects.equals(this.nodes, resource.nodes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.values, this.nodes});
        }

        public Type getType() {
            return this.type;
        }

        @Nullable
        public Collection<String> getValues() {
            return this.values;
        }

        @Nullable
        public Collection<DiscoveryNode> getNodes() {
            return this.nodes;
        }

        public static enum Type {
            INDEX("indices"),
            NODE("nodes"),
            SLM_POLICY("slm_policies"),
            ILM_POLICY("ilm_policies"),
            FEATURE_STATE("feature_states"),
            SNAPSHOT_REPOSITORY("snapshot_repositories");

            private final String displayValue;

            private Type(String displayValue) {
                this.displayValue = displayValue;
            }
        }
    }
}

