/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.PrioritizedCallable;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;
import org.elasticsearch.core.TimeValue;

public class PrioritizedEsThreadPoolExecutor
extends EsThreadPoolExecutor {
    private final AtomicLong insertionOrder = new AtomicLong();
    private final Queue<Runnable> current = ConcurrentCollections.newQueue();
    private final ScheduledExecutorService timer;

    public PrioritizedEsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, ThreadContext contextHolder, ScheduledExecutorService timer) {
        super(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(), threadFactory, contextHolder);
        this.timer = timer;
    }

    public Pending[] getPending() {
        ArrayList<Pending> pending = new ArrayList<Pending>();
        this.addPending(new ArrayList<Runnable>(this.current), pending, true);
        this.addPending(new ArrayList<Runnable>(this.getQueue()), pending, false);
        return pending.toArray(new Pending[pending.size()]);
    }

    private void addPending(List<Runnable> runnables, List<Pending> pending, boolean executing) {
        for (Runnable runnable : runnables) {
            if (runnable instanceof TieBreakingPrioritizedRunnable) {
                TieBreakingPrioritizedRunnable t = (TieBreakingPrioritizedRunnable)runnable;
                Runnable innerRunnable = t.runnable;
                if (innerRunnable == null) continue;
                pending.add(new Pending(super.unwrap(innerRunnable), t.priority(), t.insertionOrder, executing));
                continue;
            }
            if (!(runnable instanceof PrioritizedFutureTask)) continue;
            PrioritizedFutureTask t = (PrioritizedFutureTask)runnable;
            Object task = t.task;
            if (t.task instanceof Runnable) {
                task = super.unwrap((Runnable)t.task);
            }
            pending.add(new Pending(task, t.priority, t.insertionOrder, executing));
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.current.add(r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.current.remove(r);
    }

    public void execute(Runnable command, TimeValue timeout, Runnable timeoutCallback) {
        command = this.wrapRunnable(command);
        this.execute(command);
        if (timeout.nanos() >= 0L) {
            if (command instanceof TieBreakingPrioritizedRunnable) {
                ((TieBreakingPrioritizedRunnable)command).scheduleTimeout(this.timer, timeoutCallback, timeout);
            } else {
                throw new UnsupportedOperationException("Execute with timeout is not supported for future tasks");
            }
        }
    }

    @Override
    protected Runnable wrapRunnable(Runnable command) {
        if (command instanceof PrioritizedRunnable) {
            if (command instanceof TieBreakingPrioritizedRunnable) {
                return command;
            }
            Priority priority = ((PrioritizedRunnable)command).priority();
            return new TieBreakingPrioritizedRunnable(super.wrapRunnable(command), priority, this.insertionOrder.incrementAndGet());
        }
        if (command instanceof PrioritizedFutureTask) {
            return command;
        }
        return new TieBreakingPrioritizedRunnable(super.wrapRunnable(command), Priority.NORMAL, this.insertionOrder.incrementAndGet());
    }

    @Override
    protected Runnable unwrap(Runnable runnable) {
        if (runnable instanceof WrappedRunnable) {
            return super.unwrap(((WrappedRunnable)runnable).unwrap());
        }
        return super.unwrap(runnable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (!(runnable instanceof PrioritizedRunnable)) {
            runnable = PrioritizedRunnable.wrap(runnable, Priority.NORMAL);
        }
        Priority priority = ((PrioritizedRunnable)runnable).priority();
        return new PrioritizedFutureTask<T>(runnable, priority, value, this.insertionOrder.incrementAndGet());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (!(callable instanceof PrioritizedCallable)) {
            callable = PrioritizedCallable.wrap(callable, Priority.NORMAL);
        }
        return new PrioritizedFutureTask((PrioritizedCallable)callable, this.insertionOrder.incrementAndGet());
    }

    public static class Pending {
        public final Object task;
        public final Priority priority;
        public final long insertionOrder;
        public final boolean executing;

        public Pending(Object task, Priority priority, long insertionOrder, boolean executing) {
            this.task = task;
            this.priority = priority;
            this.insertionOrder = insertionOrder;
            this.executing = executing;
        }
    }

    private final class TieBreakingPrioritizedRunnable
    extends PrioritizedRunnable
    implements WrappedRunnable {
        private Runnable runnable;
        private final long insertionOrder;
        private ScheduledFuture<?> timeoutFuture;
        private boolean started;

        TieBreakingPrioritizedRunnable(Runnable runnable, Priority priority, long insertionOrder) {
            super(priority);
            this.started = false;
            this.runnable = runnable;
            this.insertionOrder = insertionOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TieBreakingPrioritizedRunnable tieBreakingPrioritizedRunnable = this;
            synchronized (tieBreakingPrioritizedRunnable) {
                this.started = true;
                FutureUtils.cancel(this.timeoutFuture);
            }
            this.runAndClean(this.runnable);
        }

        @Override
        public int compareTo(PrioritizedRunnable pr) {
            int res = super.compareTo(pr);
            if (res != 0 || !(pr instanceof TieBreakingPrioritizedRunnable)) {
                return res;
            }
            return this.insertionOrder < ((TieBreakingPrioritizedRunnable)pr).insertionOrder ? -1 : 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(ScheduledExecutorService timer, Runnable timeoutCallback, TimeValue timeValue) {
            TieBreakingPrioritizedRunnable tieBreakingPrioritizedRunnable = this;
            synchronized (tieBreakingPrioritizedRunnable) {
                if (this.timeoutFuture != null) {
                    throw new IllegalStateException("scheduleTimeout may only be called once");
                }
                if (!this.started) {
                    this.timeoutFuture = timer.schedule(() -> {
                        if (PrioritizedEsThreadPoolExecutor.this.remove(this)) {
                            this.runAndClean(timeoutCallback);
                        }
                    }, timeValue.nanos(), TimeUnit.NANOSECONDS);
                }
            }
        }

        private void runAndClean(Runnable run) {
            try {
                run.run();
            }
            finally {
                this.runnable = null;
                this.timeoutFuture = null;
            }
        }

        @Override
        public Runnable unwrap() {
            return this.runnable;
        }
    }

    private static final class PrioritizedFutureTask<T>
    extends FutureTask<T>
    implements Comparable<PrioritizedFutureTask<T>> {
        final Object task;
        final Priority priority;
        final long insertionOrder;

        PrioritizedFutureTask(Runnable runnable, Priority priority, T value, long insertionOrder) {
            super(runnable, value);
            this.task = runnable;
            this.priority = priority;
            this.insertionOrder = insertionOrder;
        }

        PrioritizedFutureTask(PrioritizedCallable<T> callable, long insertionOrder) {
            super(callable);
            this.task = callable;
            this.priority = callable.priority();
            this.insertionOrder = insertionOrder;
        }

        @Override
        public int compareTo(PrioritizedFutureTask<T> pft) {
            int res = this.priority.compareTo(pft.priority);
            if (res != 0) {
                return res;
            }
            return this.insertionOrder < pft.insertionOrder ? -1 : 1;
        }
    }
}

