/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SimpleFeatureFactory;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;

public class SimpleVectorTileFormatter
implements GeoFormatterFactory.FormatterFactory<GeoPoint> {
    public static final String MVT = "mvt";
    public static final int DEFAULT_EXTENT = 4096;
    public static final int DEFAULT_BUFFER_PIXELS = 5;
    public static final String EXTENT_PREFIX = "@";
    public static final String BUFFER_PREFIX = ":";
    private static final Pattern pattern = Pattern.compile("(\\d+)/(\\d+)/(\\d+)(@\\d+)?(:\\d+)?");

    @Override
    public String getName() {
        return MVT;
    }

    @Override
    public Function<String, Function<List<GeoPoint>, List<Object>>> getFormatterBuilder() {
        return params -> {
            int[] parsed = SimpleVectorTileFormatter.parse(params);
            SimpleFeatureFactory featureFactory = new SimpleFeatureFactory(parsed[0], parsed[1], parsed[2], parsed[3]);
            return points -> List.of(featureFactory.points((List<GeoPoint>)points));
        };
    }

    public static int[] parse(String param) {
        int extent;
        Matcher matcher = pattern.matcher(param);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid mvt formatter parameter [" + param + "]. Must have the form \"zoom/x/y\" or \"zoom/x/y@extent\" or \"zoom/x/y@extent:buffer\" or \"zoom/x/y:buffer\".");
        }
        int z = GeoTileUtils.checkPrecisionRange(Integer.parseInt(matcher.group(1)));
        int tiles = 1 << z;
        int x = Integer.parseInt(matcher.group(2));
        int y = Integer.parseInt(matcher.group(3));
        if (x < 0 || y < 0 || x >= tiles || y >= tiles) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Zoom/X/Y combination is not valid: %d/%d/%d", z, x, y));
        }
        int n = extent = matcher.group(4) == null ? 4096 : Integer.parseInt(matcher.group(4).substring(1));
        if (extent <= 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Extent is not valid: %d is not > 0", extent));
        }
        int bufferPixels = matcher.group(5) == null ? 5 : Integer.parseInt(matcher.group(5).substring(1));
        return new int[]{z, x, y, extent, bufferPixels};
    }
}

