/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.GeometryNormalizer;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.ShapeType;

public class LuceneGeometriesUtils {
    static final Quantizer NOOP_QUANTIZER = new Quantizer(){

        @Override
        public double quantizeLat(double lat) {
            return lat;
        }

        @Override
        public double quantizeLon(double lon) {
            return lon;
        }

        @Override
        public double[] quantizeLats(double[] lats) {
            return lats;
        }

        @Override
        public double[] quantizeLons(double[] lons) {
            return lons;
        }
    };
    static Quantizer LATLON_QUANTIZER = new Quantizer(){

        @Override
        public double quantizeLat(double lat) {
            return GeoUtils.quantizeLat(lat);
        }

        @Override
        public double quantizeLon(double lon) {
            return GeoUtils.quantizeLon(lon);
        }

        @Override
        public double[] quantizeLats(double[] lats) {
            return Arrays.stream(lats).map(this::quantizeLat).toArray();
        }

        @Override
        public double[] quantizeLons(double[] lons) {
            return Arrays.stream(lons).map(this::quantizeLon).toArray();
        }
    };

    public static LatLonGeometry[] toLatLonGeometry(Geometry geometry, boolean quantize, final Consumer<ShapeType> checker) {
        if (geometry == null || geometry.isEmpty()) {
            return new LatLonGeometry[0];
        }
        if (GeometryNormalizer.needsNormalize(Orientation.CCW, geometry)) {
            geometry = GeometryNormalizer.apply(Orientation.CCW, geometry);
        }
        final ArrayList geometries = new ArrayList();
        final Quantizer quantizer = quantize ? LATLON_QUANTIZER : NOOP_QUANTIZER;
        geometry.visit(new GeometryVisitor<Object, RuntimeException>(){

            @Override
            public Void visit(Circle circle) {
                checker.accept(ShapeType.CIRCLE);
                if (!circle.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toLatLonCircle(circle, quantizer));
                }
                return null;
            }

            @Override
            public Void visit(GeometryCollection<?> collection) {
                checker.accept(ShapeType.GEOMETRYCOLLECTION);
                if (!collection.isEmpty()) {
                    for (Geometry shape : collection) {
                        shape.visit(this);
                    }
                }
                return null;
            }

            @Override
            public Void visit(Line line) {
                checker.accept(ShapeType.LINESTRING);
                if (!line.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toLatLonLine(line, quantizer));
                }
                return null;
            }

            @Override
            public Void visit(LinearRing ring) {
                throw new IllegalArgumentException("Found an unsupported shape LinearRing");
            }

            @Override
            public Void visit(MultiLine multiLine) {
                checker.accept(ShapeType.MULTILINESTRING);
                if (!multiLine.isEmpty()) {
                    for (Line line : multiLine) {
                        this.visit(line);
                    }
                }
                return null;
            }

            @Override
            public Void visit(MultiPoint multiPoint) {
                checker.accept(ShapeType.MULTIPOINT);
                if (!multiPoint.isEmpty()) {
                    for (org.elasticsearch.geometry.Point point : multiPoint) {
                        this.visit(point);
                    }
                }
                return null;
            }

            @Override
            public Void visit(MultiPolygon multiPolygon) {
                checker.accept(ShapeType.MULTIPOLYGON);
                if (!multiPolygon.isEmpty()) {
                    for (org.elasticsearch.geometry.Polygon polygon : multiPolygon) {
                        this.visit(polygon);
                    }
                }
                return null;
            }

            @Override
            public Void visit(org.elasticsearch.geometry.Point point) {
                checker.accept(ShapeType.POINT);
                if (!point.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toLatLonPoint(point, quantizer));
                }
                return null;
            }

            @Override
            public Void visit(org.elasticsearch.geometry.Polygon polygon) {
                checker.accept(ShapeType.POLYGON);
                if (!polygon.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toLatLonPolygon(polygon, quantizer));
                }
                return null;
            }

            @Override
            public Void visit(org.elasticsearch.geometry.Rectangle r) {
                checker.accept(ShapeType.ENVELOPE);
                if (!r.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toLatLonRectangle(r, quantizer));
                }
                return null;
            }
        });
        return geometries.toArray(new LatLonGeometry[0]);
    }

    public static Point toLatLonPoint(org.elasticsearch.geometry.Point point) {
        return LuceneGeometriesUtils.toLatLonPoint(point, NOOP_QUANTIZER);
    }

    private static Point toLatLonPoint(org.elasticsearch.geometry.Point point, Quantizer quantizer) {
        return new Point(quantizer.quantizeLat(point.getLat()), quantizer.quantizeLon(point.getLon()));
    }

    public static org.apache.lucene.geo.Line toLatLonLine(Line line) {
        return LuceneGeometriesUtils.toLatLonLine(line, NOOP_QUANTIZER);
    }

    private static org.apache.lucene.geo.Line toLatLonLine(Line line, Quantizer quantizer) {
        return new org.apache.lucene.geo.Line(quantizer.quantizeLats(line.getLats()), quantizer.quantizeLons(line.getLons()));
    }

    public static Polygon toLatLonPolygon(org.elasticsearch.geometry.Polygon polygon) {
        return LuceneGeometriesUtils.toLatLonPolygon(polygon, NOOP_QUANTIZER);
    }

    private static Polygon toLatLonPolygon(org.elasticsearch.geometry.Polygon polygon, Quantizer quantizer) {
        Polygon[] holes = new Polygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new Polygon(quantizer.quantizeLats(polygon.getHole(i).getY()), quantizer.quantizeLons(polygon.getHole(i).getX()), new Polygon[0]);
        }
        return new Polygon(quantizer.quantizeLats(polygon.getPolygon().getY()), quantizer.quantizeLons(polygon.getPolygon().getX()), holes);
    }

    public static Rectangle toLatLonRectangle(org.elasticsearch.geometry.Rectangle rectangle) {
        return LuceneGeometriesUtils.toLatLonRectangle(rectangle, NOOP_QUANTIZER);
    }

    private static Rectangle toLatLonRectangle(org.elasticsearch.geometry.Rectangle r, Quantizer quantizer) {
        return new Rectangle(quantizer.quantizeLat(r.getMinLat()), quantizer.quantizeLat(r.getMaxLat()), quantizer.quantizeLon(r.getMinLon()), quantizer.quantizeLon(r.getMaxLon()));
    }

    public static org.apache.lucene.geo.Circle toLatLonCircle(Circle circle) {
        return LuceneGeometriesUtils.toLatLonCircle(circle, NOOP_QUANTIZER);
    }

    private static org.apache.lucene.geo.Circle toLatLonCircle(Circle circle, Quantizer quantizer) {
        return new org.apache.lucene.geo.Circle(quantizer.quantizeLat(circle.getLat()), quantizer.quantizeLon(circle.getLon()), circle.getRadiusMeters());
    }

    public static XYGeometry[] toXYGeometry(Geometry geometry, final Consumer<ShapeType> checker) {
        if (geometry == null || geometry.isEmpty()) {
            return new XYGeometry[0];
        }
        final ArrayList geometries = new ArrayList();
        geometry.visit(new GeometryVisitor<Object, RuntimeException>(){

            @Override
            public Void visit(Circle circle) {
                checker.accept(ShapeType.CIRCLE);
                if (!circle.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toXYCircle(circle));
                }
                return null;
            }

            @Override
            public Void visit(GeometryCollection<?> collection) {
                checker.accept(ShapeType.GEOMETRYCOLLECTION);
                if (!collection.isEmpty()) {
                    for (Geometry shape : collection) {
                        shape.visit(this);
                    }
                }
                return null;
            }

            @Override
            public Void visit(Line line) {
                checker.accept(ShapeType.LINESTRING);
                if (!line.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toXYLine(line));
                }
                return null;
            }

            @Override
            public Void visit(LinearRing ring) {
                throw new IllegalArgumentException("Found an unsupported shape LinearRing");
            }

            @Override
            public Void visit(MultiLine multiLine) {
                checker.accept(ShapeType.MULTILINESTRING);
                if (!multiLine.isEmpty()) {
                    for (Line line : multiLine) {
                        this.visit(line);
                    }
                }
                return null;
            }

            @Override
            public Void visit(MultiPoint multiPoint) {
                checker.accept(ShapeType.MULTIPOINT);
                if (!multiPoint.isEmpty()) {
                    for (org.elasticsearch.geometry.Point point : multiPoint) {
                        this.visit(point);
                    }
                }
                return null;
            }

            @Override
            public Void visit(MultiPolygon multiPolygon) {
                checker.accept(ShapeType.MULTIPOLYGON);
                if (!multiPolygon.isEmpty()) {
                    for (org.elasticsearch.geometry.Polygon polygon : multiPolygon) {
                        this.visit(polygon);
                    }
                }
                return null;
            }

            @Override
            public Void visit(org.elasticsearch.geometry.Point point) {
                checker.accept(ShapeType.POINT);
                if (!point.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toXYPoint(point));
                }
                return null;
            }

            @Override
            public Void visit(org.elasticsearch.geometry.Polygon polygon) {
                checker.accept(ShapeType.POLYGON);
                if (!polygon.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toXYPolygon(polygon));
                }
                return null;
            }

            @Override
            public Void visit(org.elasticsearch.geometry.Rectangle r) {
                checker.accept(ShapeType.ENVELOPE);
                if (!r.isEmpty()) {
                    geometries.add(LuceneGeometriesUtils.toXYRectangle(r));
                }
                return null;
            }
        });
        return geometries.toArray(new XYGeometry[0]);
    }

    public static XYPoint toXYPoint(org.elasticsearch.geometry.Point point) {
        return new XYPoint((float)point.getX(), (float)point.getY());
    }

    public static XYLine toXYLine(Line line) {
        return new XYLine(LuceneGeometriesUtils.doubleArrayToFloatArray(line.getX()), LuceneGeometriesUtils.doubleArrayToFloatArray(line.getY()));
    }

    public static XYPolygon toXYPolygon(org.elasticsearch.geometry.Polygon polygon) {
        XYPolygon[] holes = new XYPolygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new XYPolygon(LuceneGeometriesUtils.doubleArrayToFloatArray(polygon.getHole(i).getX()), LuceneGeometriesUtils.doubleArrayToFloatArray(polygon.getHole(i).getY()), new XYPolygon[0]);
        }
        return new XYPolygon(LuceneGeometriesUtils.doubleArrayToFloatArray(polygon.getPolygon().getX()), LuceneGeometriesUtils.doubleArrayToFloatArray(polygon.getPolygon().getY()), holes);
    }

    public static XYRectangle toXYRectangle(org.elasticsearch.geometry.Rectangle r) {
        return new XYRectangle((float)r.getMinX(), (float)r.getMaxX(), (float)r.getMinY(), (float)r.getMaxY());
    }

    public static XYCircle toXYCircle(Circle circle) {
        return new XYCircle((float)circle.getX(), (float)circle.getY(), (float)circle.getRadiusMeters());
    }

    static float[] doubleArrayToFloatArray(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }

    private LuceneGeometriesUtils() {
    }

    static interface Quantizer {
        public double quantizeLat(double var1);

        public double quantizeLon(double var1);

        public double[] quantizeLats(double[] var1);

        public double[] quantizeLons(double[] var1);
    }
}

