/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GeometryParserFormat {
    WKT{

        @Override
        public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (geometry != null) {
                return builder.value(WellKnownText.toWKT(geometry));
            }
            return builder.nullValue();
        }

        @Override
        public Geometry fromXContent(GeometryValidator validator, boolean coerce, boolean rightOrientation, XContentParser parser) throws IOException, ParseException {
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            return WellKnownText.fromWKT(validator, coerce, parser.text());
        }
    }
    ,
    GEOJSON{

        @Override
        public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (geometry != null) {
                return GeoJson.toXContent(geometry, builder, params);
            }
            return builder.nullValue();
        }

        @Override
        public Geometry fromXContent(GeometryValidator validator, boolean coerce, boolean rightOrientation, XContentParser parser) throws IOException, ParseException {
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            return GeoJson.fromXContent(validator, coerce, rightOrientation, parser);
        }
    };


    public abstract XContentBuilder toXContent(Geometry var1, XContentBuilder var2, ToXContent.Params var3) throws IOException;

    public abstract Geometry fromXContent(GeometryValidator var1, boolean var2, boolean var3, XContentParser var4) throws IOException, ParseException;

    public static GeometryParserFormat geometryFormat(XContentParser parser) {
        return switch (parser.currentToken()) {
            case XContentParser.Token.START_OBJECT, XContentParser.Token.VALUE_NULL -> GEOJSON;
            case XContentParser.Token.VALUE_STRING -> WKT;
            default -> throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
        };
    }
}

