/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterBlock
implements Writeable,
ToXContentFragment {
    private final int id;
    @Nullable
    private final String uuid;
    private final String description;
    private final EnumSet<ClusterBlockLevel> levels;
    private final boolean retryable;
    private final boolean disableStatePersistence;
    private final boolean allowReleaseResources;
    private final RestStatus status;

    public ClusterBlock(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.uuid = in.readOptionalString();
        this.description = in.readString();
        this.levels = in.readEnumSet(ClusterBlockLevel.class);
        this.retryable = in.readBoolean();
        this.disableStatePersistence = in.readBoolean();
        this.status = RestStatus.readFrom(in);
        this.allowReleaseResources = in.readBoolean();
    }

    public ClusterBlock(int id, String description, boolean retryable, boolean disableStatePersistence, boolean allowReleaseResources, RestStatus status, EnumSet<ClusterBlockLevel> levels) {
        this(id, null, description, retryable, disableStatePersistence, allowReleaseResources, status, levels);
    }

    public ClusterBlock(int id, String uuid, String description, boolean retryable, boolean disableStatePersistence, boolean allowReleaseResources, RestStatus status, EnumSet<ClusterBlockLevel> levels) {
        this.id = id;
        this.uuid = uuid;
        this.description = description;
        this.retryable = retryable;
        this.disableStatePersistence = disableStatePersistence;
        this.status = status;
        this.levels = levels;
        this.allowReleaseResources = allowReleaseResources;
    }

    public int id() {
        return this.id;
    }

    @Nullable
    public String uuid() {
        return this.uuid;
    }

    public String description() {
        return this.description;
    }

    public RestStatus status() {
        return this.status;
    }

    public EnumSet<ClusterBlockLevel> levels() {
        return this.levels;
    }

    public boolean contains(ClusterBlockLevel level) {
        return this.levels.contains((Object)level);
    }

    public boolean retryable() {
        return this.retryable;
    }

    public boolean disableStatePersistence() {
        return this.disableStatePersistence;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Integer.toString(this.id));
        if (this.uuid != null) {
            builder.field("uuid", this.uuid);
        }
        builder.field("description", this.description);
        builder.field("retryable", this.retryable);
        if (this.disableStatePersistence) {
            builder.field("disable_state_persistence", this.disableStatePersistence);
        }
        builder.startArray("levels");
        for (ClusterBlockLevel level : this.levels) {
            builder.value(level.name().toLowerCase(Locale.ROOT));
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        out.writeOptionalString(this.uuid);
        out.writeString(this.description);
        if (out.getTransportVersion().onOrAfter(TransportVersions.NEW_REFRESH_CLUSTER_BLOCK)) {
            out.writeEnumSet(this.levels);
        } else {
            out.writeEnumSet(ClusterBlock.filterLevels(this.levels, level -> !ClusterBlockLevel.REFRESH.equals(level)));
        }
        out.writeBoolean(this.retryable);
        out.writeBoolean(this.disableStatePersistence);
        RestStatus.writeTo(out, this.status);
        out.writeBoolean(this.allowReleaseResources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(",");
        if (this.uuid != null) {
            sb.append(this.uuid).append(',');
        }
        sb.append(this.description).append(", blocks ");
        String delimiter = "";
        for (ClusterBlockLevel level : this.levels) {
            sb.append(delimiter).append(level.name());
            delimiter = ",";
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterBlock that = (ClusterBlock)o;
        return this.id == that.id && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return 31 * Integer.hashCode(this.id) + Objects.hashCode(this.uuid);
    }

    public boolean isAllowReleaseResources() {
        return this.allowReleaseResources;
    }

    static EnumSet<ClusterBlockLevel> filterLevels(EnumSet<ClusterBlockLevel> levels, Predicate<ClusterBlockLevel> predicate) {
        assert (levels != null);
        int size = levels.size();
        if (size == 0 || size == 1 && predicate.test((ClusterBlockLevel)((Object)levels.iterator().next()))) {
            return levels;
        }
        EnumSet<ClusterBlockLevel> filteredLevels = EnumSet.noneOf(ClusterBlockLevel.class);
        for (ClusterBlockLevel level : levels) {
            if (!predicate.test(level)) continue;
            filteredLevels.add(level);
        }
        return filteredLevels;
    }
}

