/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.xcontent.ToXContent;

public class RestoreInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom,
Iterable<Entry> {
    public static final String TYPE = "restore";
    public static final RestoreInProgress EMPTY = new RestoreInProgress(Map.of());
    private final Map<String, Entry> entries;

    public static RestoreInProgress get(ClusterState state) {
        return state.custom(TYPE, EMPTY);
    }

    private RestoreInProgress(Map<String, Entry> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.entries.equals(((RestoreInProgress)o).entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RestoreInProgress[");
        this.entries.entrySet().forEach(entry -> builder.append("{").append((String)entry.getKey()).append("}{").append(((Entry)entry.getValue()).snapshot).append("},"));
        builder.setCharAt(builder.length() - 1, ']');
        return builder.toString();
    }

    public Entry get(String restoreUUID) {
        return this.entries.get(restoreUUID);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.values().iterator();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RestoreInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public RestoreInProgress(StreamInput in) throws IOException {
        int count = in.readVInt();
        Map<String, Entry> entriesBuilder = Maps.newHashMapWithExpectedSize(count);
        for (int i = 0; i < count; ++i) {
            String uuid = in.readString();
            Snapshot snapshot = new Snapshot(in);
            State state = State.fromValue(in.readByte());
            boolean quiet = in.getTransportVersion().onOrAfter(RestoreSnapshotRequest.VERSION_SUPPORTING_QUIET_PARAMETER) ? in.readBoolean() : true;
            List<String> indices = in.readCollectionAsImmutableList(StreamInput::readString);
            entriesBuilder.put(uuid, new Entry(uuid, snapshot, state, quiet, indices, in.readImmutableMap(ShardId::new, ShardRestoreStatus::readFrom)));
        }
        this.entries = Collections.unmodifiableMap(entriesBuilder);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.entries.values(), (o, entry) -> {
            o.writeString(entry.uuid);
            entry.snapshot().writeTo(o);
            o.writeByte(entry.state().value());
            if (out.getTransportVersion().onOrAfter(RestoreSnapshotRequest.VERSION_SUPPORTING_QUIET_PARAMETER)) {
                o.writeBoolean(entry.quiet());
            }
            o.writeStringCollection(entry.indices);
            o.writeMap(entry.shards);
        });
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat(Iterators.single((builder, params) -> builder.startArray("snapshots")), Iterators.map(this.entries.values().iterator(), entry -> (builder, params) -> {
            builder.startObject();
            builder.field("snapshot", entry.snapshot().getSnapshotId().getName());
            builder.field("repository", entry.snapshot().getRepository());
            builder.field("state", entry.state());
            builder.startArray("indices");
            for (String string : entry.indices()) {
                builder.value(string);
            }
            builder.endArray();
            builder.startArray("shards");
            for (Map.Entry entry2 : entry.shards.entrySet()) {
                ShardId shardId = (ShardId)entry2.getKey();
                ShardRestoreStatus status = (ShardRestoreStatus)entry2.getValue();
                builder.startObject();
                builder.field("index", shardId.getIndex());
                builder.field("shard", shardId.getId());
                builder.field("state", status.state());
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }), Iterators.single((builder, params) -> builder.endArray()));
    }

    public record Entry(String uuid, Snapshot snapshot, State state, boolean quiet, List<String> indices, Map<ShardId, ShardRestoreStatus> shards) {
        public Entry(String uuid, Snapshot snapshot, State state, boolean quiet, List<String> indices, Map<ShardId, ShardRestoreStatus> shards) {
            this.snapshot = Objects.requireNonNull(snapshot);
            this.state = Objects.requireNonNull(state);
            this.quiet = Objects.requireNonNull(quiet);
            this.indices = Objects.requireNonNull(indices);
            this.shards = shards == null ? Map.of() : shards;
            this.uuid = Objects.requireNonNull(uuid);
        }
    }

    public static enum State {
        INIT(0),
        STARTED(1),
        SUCCESS(2),
        FAILURE(3);

        private final byte value;

        private State(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this == SUCCESS || this == FAILURE;
        }

        public static State fromValue(byte value) {
            return switch (value) {
                case 0 -> INIT;
                case 1 -> STARTED;
                case 2 -> SUCCESS;
                case 3 -> FAILURE;
                default -> throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
            };
        }
    }

    public record ShardRestoreStatus(String nodeId, State state, String reason) implements Writeable
    {
        public ShardRestoreStatus(String nodeId) {
            this(nodeId, State.INIT);
        }

        public ShardRestoreStatus(String nodeId, State state) {
            this(nodeId, state, null);
        }

        public static ShardRestoreStatus readFrom(StreamInput in) throws IOException {
            return new ShardRestoreStatus(in.readOptionalString(), State.fromValue(in.readByte()), in.readOptionalString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.reason);
        }
    }

    public static final class Builder {
        private final Map<String, Entry> entries = new HashMap<String, Entry>();

        public Builder() {
        }

        public Builder(RestoreInProgress restoreInProgress) {
            this.entries.putAll(restoreInProgress.entries);
        }

        public Builder add(Entry entry) {
            this.entries.put(entry.uuid, entry);
            return this;
        }

        public RestoreInProgress build() {
            return this.entries.isEmpty() ? EMPTY : new RestoreInProgress(Collections.unmodifiableMap(this.entries));
        }
    }
}

