/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.util.ServiceLoader;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.internal.VersionExtension;
import org.elasticsearch.plugins.ExtensionLoader;

public record TransportVersion(int id) implements VersionId<TransportVersion>
{
    public static TransportVersion readVersion(StreamInput in) throws IOException {
        return TransportVersion.fromId(in.readVInt());
    }

    public static TransportVersion fromId(int id) {
        TransportVersion known = (TransportVersion)TransportVersions.VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        return new TransportVersion(id);
    }

    public static void writeVersion(TransportVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static TransportVersion min(TransportVersion version1, TransportVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static TransportVersion max(TransportVersion version1, TransportVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static boolean isCompatible(TransportVersion version) {
        return version.onOrAfter(TransportVersions.MINIMUM_COMPATIBLE);
    }

    public static TransportVersion current() {
        return CurrentHolder.CURRENT;
    }

    public boolean isKnown() {
        return this.before(TransportVersions.V_8_9_X) || TransportVersions.VERSION_IDS.containsKey(this.id);
    }

    public TransportVersion bestKnownVersion() {
        if (this.isKnown()) {
            return this;
        }
        TransportVersion bestSoFar = TransportVersions.ZERO;
        for (TransportVersion knownVersion : TransportVersions.VERSION_IDS.values()) {
            if (!knownVersion.after(bestSoFar) || !knownVersion.before(this)) continue;
            bestSoFar = knownVersion;
        }
        return bestSoFar;
    }

    public static TransportVersion fromString(String str) {
        return TransportVersion.fromId(Integer.parseInt(str));
    }

    public boolean isPatchFrom(TransportVersion version) {
        return this.onOrAfter(version) && this.id < version.id + 100 - version.id % 100;
    }

    public String toReleaseVersion() {
        return TransportVersions.VERSION_LOOKUP.apply(this.id);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    private static class CurrentHolder {
        private static final TransportVersion CURRENT = CurrentHolder.findCurrent();

        private CurrentHolder() {
        }

        private static TransportVersion findCurrent() {
            TransportVersion version = ExtensionLoader.loadSingleton(ServiceLoader.load(VersionExtension.class)).map(e -> e.getCurrentTransportVersion(TransportVersions.LATEST_DEFINED)).orElse(TransportVersions.LATEST_DEFINED);
            assert (version.onOrAfter(TransportVersions.LATEST_DEFINED));
            return version;
        }
    }
}

