/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetBucketsResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetBucketsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Double anomalyScore;
    @Nullable
    private final Boolean desc;
    @Nullable
    private final DateTime end;
    @Nullable
    private final Boolean excludeInterim;
    @Nullable
    private final Boolean expand;
    @Nullable
    private final Integer from;
    private final String jobId;
    @Nullable
    private final Page page;
    @Nullable
    private final Integer size;
    @Nullable
    private final String sort;
    @Nullable
    private final DateTime start;
    @Nullable
    private final DateTime timestamp;
    public static final JsonpDeserializer<GetBucketsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetBucketsRequest::setupGetBucketsRequestDeserializer);
    public static final Endpoint<GetBucketsRequest, GetBucketsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetBucketsRequest, GetBucketsResponse>("es/ml.get_buckets", request -> "POST", request -> {
        boolean _jobId = true;
        int _timestamp = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.timestamp() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/buckets");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.timestamp.toString(), buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/buckets");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _jobId = true;
        int _timestamp = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.timestamp() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            params.put("jobId", request.jobId);
            params.put("timestamp", request.timestamp.toString());
        }
        if (propsSet == 1) {
            params.put("jobId", request.jobId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetBucketsResponse._DESERIALIZER);

    private GetBucketsRequest(Builder builder) {
        this.anomalyScore = builder.anomalyScore;
        this.desc = builder.desc;
        this.end = builder.end;
        this.excludeInterim = builder.excludeInterim;
        this.expand = builder.expand;
        this.from = builder.from;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.page = builder.page;
        this.size = builder.size;
        this.sort = builder.sort;
        this.start = builder.start;
        this.timestamp = builder.timestamp;
    }

    public static GetBucketsRequest of(Function<Builder, ObjectBuilder<GetBucketsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double anomalyScore() {
        return this.anomalyScore;
    }

    @Nullable
    public final Boolean desc() {
        return this.desc;
    }

    @Nullable
    public final DateTime end() {
        return this.end;
    }

    @Nullable
    public final Boolean excludeInterim() {
        return this.excludeInterim;
    }

    @Nullable
    public final Boolean expand() {
        return this.expand;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Page page() {
        return this.page;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String sort() {
        return this.sort;
    }

    @Nullable
    public final DateTime start() {
        return this.start;
    }

    @Nullable
    public final DateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.anomalyScore != null) {
            generator.writeKey("anomaly_score");
            generator.write(this.anomalyScore);
        }
        if (this.desc != null) {
            generator.writeKey("desc");
            generator.write(this.desc);
        }
        if (this.end != null) {
            generator.writeKey("end");
            this.end.serialize(generator, mapper);
        }
        if (this.excludeInterim != null) {
            generator.writeKey("exclude_interim");
            generator.write(this.excludeInterim);
        }
        if (this.expand != null) {
            generator.writeKey("expand");
            generator.write(this.expand);
        }
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.write(this.sort);
        }
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
    }

    protected static void setupGetBucketsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::anomalyScore, JsonpDeserializer.doubleDeserializer(), "anomaly_score");
        op.add(Builder::desc, JsonpDeserializer.booleanDeserializer(), "desc");
        op.add(Builder::end, DateTime._DESERIALIZER, "end");
        op.add(Builder::excludeInterim, JsonpDeserializer.booleanDeserializer(), "exclude_interim");
        op.add(Builder::expand, JsonpDeserializer.booleanDeserializer(), "expand");
        op.add(Builder::page, Page._DESERIALIZER, "page");
        op.add(Builder::sort, JsonpDeserializer.stringDeserializer(), "sort");
        op.add(Builder::start, DateTime._DESERIALIZER, "start");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetBucketsRequest> {
        @Nullable
        private Double anomalyScore;
        @Nullable
        private Boolean desc;
        @Nullable
        private DateTime end;
        @Nullable
        private Boolean excludeInterim;
        @Nullable
        private Boolean expand;
        @Nullable
        private Integer from;
        private String jobId;
        @Nullable
        private Page page;
        @Nullable
        private Integer size;
        @Nullable
        private String sort;
        @Nullable
        private DateTime start;
        @Nullable
        private DateTime timestamp;

        public final Builder anomalyScore(@Nullable Double value) {
            this.anomalyScore = value;
            return this;
        }

        public final Builder desc(@Nullable Boolean value) {
            this.desc = value;
            return this;
        }

        public final Builder end(@Nullable DateTime value) {
            this.end = value;
            return this;
        }

        public final Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public final Builder expand(@Nullable Boolean value) {
            this.expand = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public final Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(@Nullable String value) {
            this.sort = value;
            return this;
        }

        public final Builder start(@Nullable DateTime value) {
            this.start = value;
            return this;
        }

        public final Builder timestamp(@Nullable DateTime value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetBucketsRequest build() {
            this._checkSingleUse();
            return new GetBucketsRequest(this);
        }
    }
}

