/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.CompletionTool;
import co.elastic.clients.elasticsearch.inference.CompletionToolType;
import co.elastic.clients.elasticsearch.inference.Message;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RequestChatCompletion
implements JsonpSerializable {
    private final List<Message> messages;
    @Nullable
    private final String model;
    @Nullable
    private final Long maxCompletionTokens;
    private final List<String> stop;
    @Nullable
    private final Float temperature;
    @Nullable
    private final CompletionToolType toolChoice;
    private final List<CompletionTool> tools;
    @Nullable
    private final Float topP;
    public static final JsonpDeserializer<RequestChatCompletion> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RequestChatCompletion::setupRequestChatCompletionDeserializer);

    private RequestChatCompletion(Builder builder) {
        this.messages = ApiTypeHelper.unmodifiableRequired(builder.messages, (Object)this, "messages");
        this.model = builder.model;
        this.maxCompletionTokens = builder.maxCompletionTokens;
        this.stop = ApiTypeHelper.unmodifiable(builder.stop);
        this.temperature = builder.temperature;
        this.toolChoice = builder.toolChoice;
        this.tools = ApiTypeHelper.unmodifiable(builder.tools);
        this.topP = builder.topP;
    }

    public static RequestChatCompletion of(Function<Builder, ObjectBuilder<RequestChatCompletion>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Message> messages() {
        return this.messages;
    }

    @Nullable
    public final String model() {
        return this.model;
    }

    @Nullable
    public final Long maxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public final List<String> stop() {
        return this.stop;
    }

    @Nullable
    public final Float temperature() {
        return this.temperature;
    }

    @Nullable
    public final CompletionToolType toolChoice() {
        return this.toolChoice;
    }

    public final List<CompletionTool> tools() {
        return this.tools;
    }

    @Nullable
    public final Float topP() {
        return this.topP;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.messages)) {
            generator.writeKey("messages");
            generator.writeStartArray();
            for (Message message : this.messages) {
                message.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.model != null) {
            generator.writeKey("model");
            generator.write(this.model);
        }
        if (this.maxCompletionTokens != null) {
            generator.writeKey("max_completion_tokens");
            generator.write(this.maxCompletionTokens);
        }
        if (ApiTypeHelper.isDefined(this.stop)) {
            generator.writeKey("stop");
            generator.writeStartArray();
            for (String string : this.stop) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.temperature != null) {
            generator.writeKey("temperature");
            generator.write(this.temperature.floatValue());
        }
        if (this.toolChoice != null) {
            generator.writeKey("tool_choice");
            this.toolChoice.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.tools)) {
            generator.writeKey("tools");
            generator.writeStartArray();
            for (CompletionTool completionTool : this.tools) {
                completionTool.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.topP != null) {
            generator.writeKey("top_p");
            generator.write(this.topP.floatValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRequestChatCompletionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::messages, JsonpDeserializer.arrayDeserializer(Message._DESERIALIZER), "messages");
        op.add(Builder::model, JsonpDeserializer.stringDeserializer(), "model");
        op.add(Builder::maxCompletionTokens, JsonpDeserializer.longDeserializer(), "max_completion_tokens");
        op.add(Builder::stop, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stop");
        op.add(Builder::temperature, JsonpDeserializer.floatDeserializer(), "temperature");
        op.add(Builder::toolChoice, CompletionToolType._DESERIALIZER, "tool_choice");
        op.add(Builder::tools, JsonpDeserializer.arrayDeserializer(CompletionTool._DESERIALIZER), "tools");
        op.add(Builder::topP, JsonpDeserializer.floatDeserializer(), "top_p");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RequestChatCompletion> {
        private List<Message> messages;
        @Nullable
        private String model;
        @Nullable
        private Long maxCompletionTokens;
        @Nullable
        private List<String> stop;
        @Nullable
        private Float temperature;
        @Nullable
        private CompletionToolType toolChoice;
        @Nullable
        private List<CompletionTool> tools;
        @Nullable
        private Float topP;

        public final Builder messages(List<Message> list) {
            this.messages = Builder._listAddAll(this.messages, list);
            return this;
        }

        public final Builder messages(Message value, Message ... values) {
            this.messages = Builder._listAdd(this.messages, value, values);
            return this;
        }

        public final Builder messages(Function<Message.Builder, ObjectBuilder<Message>> fn) {
            return this.messages(fn.apply(new Message.Builder()).build(), new Message[0]);
        }

        public final Builder model(@Nullable String value) {
            this.model = value;
            return this;
        }

        public final Builder maxCompletionTokens(@Nullable Long value) {
            this.maxCompletionTokens = value;
            return this;
        }

        public final Builder stop(List<String> list) {
            this.stop = Builder._listAddAll(this.stop, list);
            return this;
        }

        public final Builder stop(String value, String ... values) {
            this.stop = Builder._listAdd(this.stop, value, values);
            return this;
        }

        public final Builder temperature(@Nullable Float value) {
            this.temperature = value;
            return this;
        }

        public final Builder toolChoice(@Nullable CompletionToolType value) {
            this.toolChoice = value;
            return this;
        }

        public final Builder toolChoice(Function<CompletionToolType.Builder, ObjectBuilder<CompletionToolType>> fn) {
            return this.toolChoice(fn.apply(new CompletionToolType.Builder()).build());
        }

        public final Builder tools(List<CompletionTool> list) {
            this.tools = Builder._listAddAll(this.tools, list);
            return this;
        }

        public final Builder tools(CompletionTool value, CompletionTool ... values) {
            this.tools = Builder._listAdd(this.tools, value, values);
            return this;
        }

        public final Builder tools(Function<CompletionTool.Builder, ObjectBuilder<CompletionTool>> fn) {
            return this.tools(fn.apply(new CompletionTool.Builder()).build(), new CompletionTool[0]);
        }

        public final Builder topP(@Nullable Float value) {
            this.topP = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RequestChatCompletion build() {
            this._checkSingleUse();
            return new RequestChatCompletion(this);
        }
    }
}

