/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.create_from;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CreateFrom
implements JsonpSerializable {
    @Nullable
    private final TypeMapping mappingsOverride;
    @Nullable
    private final IndexSettings settingsOverride;
    @Nullable
    private final Boolean removeIndexBlocks;
    public static final JsonpDeserializer<CreateFrom> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateFrom::setupCreateFromDeserializer);

    private CreateFrom(Builder builder) {
        this.mappingsOverride = builder.mappingsOverride;
        this.settingsOverride = builder.settingsOverride;
        this.removeIndexBlocks = builder.removeIndexBlocks;
    }

    public static CreateFrom of(Function<Builder, ObjectBuilder<CreateFrom>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TypeMapping mappingsOverride() {
        return this.mappingsOverride;
    }

    @Nullable
    public final IndexSettings settingsOverride() {
        return this.settingsOverride;
    }

    @Nullable
    public final Boolean removeIndexBlocks() {
        return this.removeIndexBlocks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.mappingsOverride != null) {
            generator.writeKey("mappings_override");
            this.mappingsOverride.serialize(generator, mapper);
        }
        if (this.settingsOverride != null) {
            generator.writeKey("settings_override");
            this.settingsOverride.serialize(generator, mapper);
        }
        if (this.removeIndexBlocks != null) {
            generator.writeKey("remove_index_blocks");
            generator.write(this.removeIndexBlocks);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCreateFromDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mappingsOverride, TypeMapping._DESERIALIZER, "mappings_override");
        op.add(Builder::settingsOverride, IndexSettings._DESERIALIZER, "settings_override");
        op.add(Builder::removeIndexBlocks, JsonpDeserializer.booleanDeserializer(), "remove_index_blocks");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CreateFrom> {
        @Nullable
        private TypeMapping mappingsOverride;
        @Nullable
        private IndexSettings settingsOverride;
        @Nullable
        private Boolean removeIndexBlocks;

        public final Builder mappingsOverride(@Nullable TypeMapping value) {
            this.mappingsOverride = value;
            return this;
        }

        public final Builder mappingsOverride(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappingsOverride(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder settingsOverride(@Nullable IndexSettings value) {
            this.settingsOverride = value;
            return this;
        }

        public final Builder settingsOverride(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settingsOverride(fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder removeIndexBlocks(@Nullable Boolean value) {
            this.removeIndexBlocks = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CreateFrom build() {
            this._checkSingleUse();
            return new CreateFrom(this);
        }
    }
}

