/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetEqlStatusResponse
implements JsonpSerializable {
    private final String id;
    private final boolean isPartial;
    private final boolean isRunning;
    @Nullable
    private final Long startTimeInMillis;
    @Nullable
    private final Long expirationTimeInMillis;
    @Nullable
    private final Integer completionStatus;
    public static final JsonpDeserializer<GetEqlStatusResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetEqlStatusResponse::setupGetEqlStatusResponseDeserializer);

    private GetEqlStatusResponse(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.isPartial = ApiTypeHelper.requireNonNull(builder.isPartial, (Object)this, "isPartial", false);
        this.isRunning = ApiTypeHelper.requireNonNull(builder.isRunning, (Object)this, "isRunning", false);
        this.startTimeInMillis = builder.startTimeInMillis;
        this.expirationTimeInMillis = builder.expirationTimeInMillis;
        this.completionStatus = builder.completionStatus;
    }

    public static GetEqlStatusResponse of(Function<Builder, ObjectBuilder<GetEqlStatusResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final boolean isPartial() {
        return this.isPartial;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    @Nullable
    public final Long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final Long expirationTimeInMillis() {
        return this.expirationTimeInMillis;
    }

    @Nullable
    public final Integer completionStatus() {
        return this.completionStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("is_partial");
        generator.write(this.isPartial);
        generator.writeKey("is_running");
        generator.write(this.isRunning);
        if (this.startTimeInMillis != null) {
            generator.writeKey("start_time_in_millis");
            generator.write(this.startTimeInMillis);
        }
        if (this.expirationTimeInMillis != null) {
            generator.writeKey("expiration_time_in_millis");
            generator.write(this.expirationTimeInMillis);
        }
        if (this.completionStatus != null) {
            generator.writeKey("completion_status");
            generator.write(this.completionStatus);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetEqlStatusResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial");
        op.add(Builder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::expirationTimeInMillis, JsonpDeserializer.longDeserializer(), "expiration_time_in_millis");
        op.add(Builder::completionStatus, JsonpDeserializer.integerDeserializer(), "completion_status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetEqlStatusResponse> {
        private String id;
        private Boolean isPartial;
        private Boolean isRunning;
        @Nullable
        private Long startTimeInMillis;
        @Nullable
        private Long expirationTimeInMillis;
        @Nullable
        private Integer completionStatus;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder isPartial(boolean value) {
            this.isPartial = value;
            return this;
        }

        public final Builder isRunning(boolean value) {
            this.isRunning = value;
            return this;
        }

        public final Builder startTimeInMillis(@Nullable Long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder expirationTimeInMillis(@Nullable Long value) {
            this.expirationTimeInMillis = value;
            return this;
        }

        public final Builder completionStatus(@Nullable Integer value) {
            this.completionStatus = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetEqlStatusResponse build() {
            this._checkSingleUse();
            return new GetEqlStatusResponse(this);
        }
    }
}

