/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search.status;

import co.elastic.clients.elasticsearch._types.ClusterStatistics;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.async_search.AsyncSearchResponseBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class StatusResponseBase
extends AsyncSearchResponseBase {
    private final ShardStatistics shards;
    @Nullable
    private final ClusterStatistics clusters;
    @Nullable
    private final Integer completionStatus;

    protected StatusResponseBase(AbstractBuilder<?> builder) {
        super(builder);
        this.shards = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).shards, this, "shards");
        this.clusters = ((AbstractBuilder)builder).clusters;
        this.completionStatus = ((AbstractBuilder)builder).completionStatus;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public final ClusterStatistics clusters() {
        return this.clusters;
    }

    @Nullable
    public final Integer completionStatus() {
        return this.completionStatus;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        if (this.clusters != null) {
            generator.writeKey("_clusters");
            this.clusters.serialize(generator, mapper);
        }
        if (this.completionStatus != null) {
            generator.writeKey("completion_status");
            generator.write(this.completionStatus);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupStatusResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        AsyncSearchResponseBase.setupAsyncSearchResponseBaseDeserializer(op);
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(AbstractBuilder::clusters, ClusterStatistics._DESERIALIZER, "_clusters");
        op.add(AbstractBuilder::completionStatus, JsonpDeserializer.integerDeserializer(), "completion_status");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AsyncSearchResponseBase.AbstractBuilder<BuilderT> {
        private ShardStatistics shards;
        @Nullable
        private ClusterStatistics clusters;
        @Nullable
        private Integer completionStatus;

        public final BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final BuilderT clusters(@Nullable ClusterStatistics value) {
            this.clusters = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT clusters(Function<ClusterStatistics.Builder, ObjectBuilder<ClusterStatistics>> fn) {
            return this.clusters(fn.apply(new ClusterStatistics.Builder()).build());
        }

        public final BuilderT completionStatus(@Nullable Integer value) {
            this.completionStatus = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

