/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StoreStats
implements JsonpSerializable {
    @Nullable
    private final String size;
    private final long sizeInBytes;
    @Nullable
    private final String reserved;
    private final long reservedInBytes;
    @Nullable
    private final String totalDataSetSize;
    @Nullable
    private final Long totalDataSetSizeInBytes;
    public static final JsonpDeserializer<StoreStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StoreStats::setupStoreStatsDeserializer);

    private StoreStats(Builder builder) {
        this.size = builder.size;
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, (Object)this, "sizeInBytes", 0L);
        this.reserved = builder.reserved;
        this.reservedInBytes = ApiTypeHelper.requireNonNull(builder.reservedInBytes, (Object)this, "reservedInBytes", 0L);
        this.totalDataSetSize = builder.totalDataSetSize;
        this.totalDataSetSizeInBytes = builder.totalDataSetSizeInBytes;
    }

    public static StoreStats of(Function<Builder, ObjectBuilder<StoreStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Nullable
    public final String reserved() {
        return this.reserved;
    }

    public final long reservedInBytes() {
        return this.reservedInBytes;
    }

    @Nullable
    public final String totalDataSetSize() {
        return this.totalDataSetSize;
    }

    @Nullable
    public final Long totalDataSetSizeInBytes() {
        return this.totalDataSetSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        if (this.reserved != null) {
            generator.writeKey("reserved");
            generator.write(this.reserved);
        }
        generator.writeKey("reserved_in_bytes");
        generator.write(this.reservedInBytes);
        if (this.totalDataSetSize != null) {
            generator.writeKey("total_data_set_size");
            generator.write(this.totalDataSetSize);
        }
        if (this.totalDataSetSizeInBytes != null) {
            generator.writeKey("total_data_set_size_in_bytes");
            generator.write(this.totalDataSetSizeInBytes);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupStoreStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
        op.add(Builder::reserved, JsonpDeserializer.stringDeserializer(), "reserved");
        op.add(Builder::reservedInBytes, JsonpDeserializer.longDeserializer(), "reserved_in_bytes");
        op.add(Builder::totalDataSetSize, JsonpDeserializer.stringDeserializer(), "total_data_set_size");
        op.add(Builder::totalDataSetSizeInBytes, JsonpDeserializer.longDeserializer(), "total_data_set_size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<StoreStats> {
        @Nullable
        private String size;
        private Long sizeInBytes;
        @Nullable
        private String reserved;
        private Long reservedInBytes;
        @Nullable
        private String totalDataSetSize;
        @Nullable
        private Long totalDataSetSizeInBytes;

        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        public final Builder reserved(@Nullable String value) {
            this.reserved = value;
            return this;
        }

        public final Builder reservedInBytes(long value) {
            this.reservedInBytes = value;
            return this;
        }

        public final Builder totalDataSetSize(@Nullable String value) {
            this.totalDataSetSize = value;
            return this;
        }

        public final Builder totalDataSetSizeInBytes(@Nullable Long value) {
            this.totalDataSetSizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StoreStats build() {
            this._checkSingleUse();
            return new StoreStats(this);
        }
    }
}

