"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewInAPMButton = ViewInAPMButton;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _service_detail_locator = require("../../../../locator/service_detail_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ViewInAPMButton({
  serviceName,
  environment,
  transactionName,
  transactionType,
  from,
  to,
  kuery
}) {
  var _share$url, _share$url$locators;
  // this component is rendered in the Observability Plugin, so we can use the ObservabilityPublicPluginsStart type
  const {
    services: {
      share
    }
  } = (0, _public.useKibana)();
  const serviceNavigator = share === null || share === void 0 ? void 0 : (_share$url = share.url) === null || _share$url === void 0 ? void 0 : (_share$url$locators = _share$url.locators) === null || _share$url$locators === void 0 ? void 0 : _share$url$locators.get(_service_detail_locator.APM_APP_LOCATOR_ID);
  if (!serviceNavigator) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmAlertDetailsPageViewInApp",
    onClick: () => serviceNavigator.navigate({
      serviceName,
      serviceOverviewTab: transactionName ? 'transactions' : undefined,
      query: {
        environment,
        rangeFrom: from,
        rangeTo: to,
        kuery,
        transactionName,
        transactionType
      }
    }),
    iconType: "sortRight",
    color: "text"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.alertDetails.viewInApm",
    defaultMessage: "View in APM"
  }));
}