"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IndexedGeometryLinearMap = void 0;
class IndexedGeometryLinearMap {
    map = new Map();
    get size() {
        return this.map.size;
    }
    set(geometry) {
        const { x } = geometry.value;
        const existing = this.map.get(x);
        if (existing === undefined) {
            this.map.set(x, [geometry]);
        }
        else {
            this.map.set(x, [geometry, ...existing]);
        }
    }
    getMergeData() {
        return [...this.map.values()];
    }
    keys() {
        return [...this.map.keys()];
    }
    find(x) {
        if (x === null) {
            return [];
        }
        return this.map.get(x) ?? [];
    }
}
exports.IndexedGeometryLinearMap = IndexedGeometryLinearMap;
//# sourceMappingURL=indexed_geometry_linear_map.js.map