"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderLines = renderLines;
exports.drawPolarLine = drawPolarLine;
const panel_clipping_1 = require("./panel_clipping");
const points_1 = require("./points");
const path_1 = require("./primitives/path");
const line_1 = require("./styles/line");
const panel_transform_1 = require("./utils/panel_transform");
const canvas_1 = require("../../../../renderers/canvas");
const geometry_1 = require("../../../../utils/geometry");
function renderLines(ctx, lines, rotation, renderingArea, highlightedLegendItem) {
    (0, canvas_1.withContext)(ctx, () => {
        lines
            .map(({ panel, value }) => {
            return {
                panel,
                line: value,
                highlightState: (0, geometry_1.getGeometryHighlightState)(value.seriesIdentifier.key, highlightedLegendItem),
            };
        })
            .sort(({ highlightState }) => (highlightState === 'dimmed' ? -1 : 1))
            .forEach(({ panel, line, highlightState }) => {
            const clippings = (0, panel_clipping_1.getPanelClipping)(panel, rotation);
            if (line.style.line.visible) {
                (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, () => renderLine(ctx, line, clippings, highlightState), { area: clippings, shouldClip: true });
            }
            (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, () => (0, points_1.renderPoints)(ctx, line.points, highlightState, line.style.point, line.style.line.strokeWidth, line.minPointDistance, line.style.pointVisibilityMinDistance, line.hasFit && line.points.length > 1), { area: clippings, shouldClip: line.points[0]?.value.mark !== null });
        });
    });
}
function renderLine(ctx, line, clippings, highlightState) {
    const { color, transform, style, clippedRanges, shouldClip } = line;
    const lineStroke = (0, line_1.buildLineStyles)(color, style.line, highlightState);
    const fitLineStroke = (0, line_1.buildLineStyles)(color, { ...style.fit.line, strokeWidth: style.line.strokeWidth, dimmed: style.line.dimmed, focused: style.line.focused }, highlightState);
    (0, path_1.renderLinePaths)(ctx, transform, [line.line], lineStroke, fitLineStroke, clippedRanges, clippings, shouldClip && style.fit.line.visible);
}
function drawPolarLine(ctx, angle, radius, length, center = { x: 0, y: 0 }) {
    const y1 = Math.sin(angle) * (radius - length / 2);
    const x1 = Math.cos(angle) * (radius - length / 2);
    const y2 = Math.sin(angle) * (radius + length / 2);
    const x2 = Math.cos(angle) * (radius + length / 2);
    ctx.moveTo(center.x + x1, center.y + y1);
    ctx.lineTo(center.x + x2, center.y + y2);
}
//# sourceMappingURL=lines.js.map