/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteriaType;

public class QueryRuleCriteria
implements Writeable,
ToXContentObject {
    public static final TransportVersion CRITERIA_METADATA_VALUES_TRANSPORT_VERSION = TransportVersions.V_8_10_X;
    private final QueryRuleCriteriaType criteriaType;
    private final String criteriaMetadata;
    private final List<Object> criteriaValues;
    private static final Logger logger = LogManager.getLogger(QueryRuleCriteria.class);
    private static final ConstructingObjectParser<QueryRuleCriteria, String> PARSER = new ConstructingObjectParser("query_rule_criteria", false, (params, resourceName) -> {
        QueryRuleCriteriaType type = QueryRuleCriteriaType.type((String)params[0]);
        String metadata = ((Object[])params).length >= 3 ? (String)params[1] : null;
        List values = ((Object[])params).length >= 3 ? (List)params[2] : null;
        return new QueryRuleCriteria(type, metadata, values);
    });
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("metadata", new String[0]);
    public static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);

    public QueryRuleCriteria(QueryRuleCriteriaType criteriaType, @Nullable String criteriaMetadata, @Nullable List<Object> criteriaValues) {
        Objects.requireNonNull(criteriaType);
        this.criteriaType = criteriaType;
        if (criteriaType != QueryRuleCriteriaType.ALWAYS) {
            if (Strings.isNullOrEmpty((String)criteriaMetadata)) {
                throw new IllegalArgumentException("criteriaMetadata cannot be blank");
            }
            if (criteriaValues == null || criteriaValues.isEmpty()) {
                throw new IllegalArgumentException("criteriaValues cannot be null or empty");
            }
            this.criteriaMetadata = criteriaMetadata;
            this.criteriaValues = criteriaValues;
        } else {
            this.criteriaMetadata = "";
            this.criteriaValues = List.of();
        }
    }

    public QueryRuleCriteria(StreamInput in) throws IOException {
        this.criteriaType = (QueryRuleCriteriaType)in.readEnum(QueryRuleCriteriaType.class);
        if (this.criteriaType == QueryRuleCriteriaType.ALWAYS) {
            this.criteriaMetadata = "";
            if (in.getTransportVersion().onOrAfter((VersionId)CRITERIA_METADATA_VALUES_TRANSPORT_VERSION)) {
                in.readOptionalString();
                in.readOptionalCollectionAsList(StreamInput::readGenericValue);
            } else {
                in.readString();
                in.readGenericValue();
            }
            this.criteriaValues = List.of();
        } else if (in.getTransportVersion().onOrAfter((VersionId)CRITERIA_METADATA_VALUES_TRANSPORT_VERSION)) {
            this.criteriaMetadata = in.readOptionalString();
            this.criteriaValues = in.readOptionalCollectionAsList(StreamInput::readGenericValue);
        } else {
            this.criteriaMetadata = in.readString();
            Object value = in.readGenericValue();
            this.criteriaValues = value != null ? List.of(value) : List.of();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.criteriaType);
        if (out.getTransportVersion().onOrAfter((VersionId)CRITERIA_METADATA_VALUES_TRANSPORT_VERSION)) {
            if (this.criteriaType == QueryRuleCriteriaType.ALWAYS) {
                out.writeOptionalString("");
                out.writeOptionalCollection(List.of(), StreamOutput::writeGenericValue);
            } else {
                out.writeOptionalString(this.criteriaMetadata);
                out.writeOptionalCollection(this.criteriaValues, StreamOutput::writeGenericValue);
            }
        } else if (this.criteriaType == QueryRuleCriteriaType.ALWAYS) {
            out.writeString("");
            out.writeGenericValue((Object)"");
        } else {
            out.writeString(this.criteriaMetadata != null ? this.criteriaMetadata : "");
            String valueToWrite = this.criteriaValues != null && !this.criteriaValues.isEmpty() ? this.criteriaValues.get(0) : "";
            out.writeGenericValue((Object)valueToWrite);
        }
    }

    public static QueryRuleCriteria fromXContentBytes(BytesReference source, XContentType xContentType) {
        QueryRuleCriteria queryRuleCriteria;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                queryRuleCriteria = QueryRuleCriteria.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return queryRuleCriteria;
    }

    public static QueryRuleCriteria fromXContent(XContentParser parser) {
        return (QueryRuleCriteria)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD.getPreferredName(), (Enum)this.criteriaType);
        if (this.criteriaType == QueryRuleCriteriaType.ALWAYS) {
            builder.field(METADATA_FIELD.getPreferredName(), "");
            builder.startArray(VALUES_FIELD.getPreferredName()).endArray();
        } else {
            if (this.criteriaMetadata != null) {
                builder.field(METADATA_FIELD.getPreferredName(), this.criteriaMetadata);
            }
            if (this.criteriaValues != null) {
                builder.array(VALUES_FIELD.getPreferredName(), this.criteriaValues.toArray());
            }
        }
        builder.endObject();
        return builder;
    }

    public QueryRuleCriteriaType criteriaType() {
        return this.criteriaType;
    }

    public String criteriaMetadata() {
        return this.criteriaMetadata;
    }

    public List<Object> criteriaValues() {
        return this.criteriaValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRuleCriteria that = (QueryRuleCriteria)o;
        return this.criteriaType == that.criteriaType && Objects.equals(this.criteriaMetadata, that.criteriaMetadata) && Objects.equals(this.criteriaValues, that.criteriaValues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.criteriaType, this.criteriaMetadata, this.criteriaValues});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean isMatch(Object matchValue, QueryRuleCriteriaType matchType) {
        return this.isMatch(matchValue, matchType, true);
    }

    public boolean isMatch(Object matchValue, QueryRuleCriteriaType matchType, boolean throwOnInvalidInput) {
        if (matchType == QueryRuleCriteriaType.ALWAYS) {
            return true;
        }
        String matchString = matchValue.toString();
        for (Object criteriaValue : this.criteriaValues) {
            boolean isValid = matchType.validateInput(matchValue, throwOnInvalidInput);
            if (!isValid) {
                return false;
            }
            boolean matchFound = matchType.isMatch(matchString, criteriaValue);
            if (!matchFound) continue;
            return true;
        }
        return false;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), METADATA_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), VALUES_FIELD);
    }
}

