/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorNativeAction {
    public static final String NAME = "indices:data/write/xpack/connector/update_native";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/update_native");

    private UpdateConnectorNativeAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final boolean isNative;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_native_request", false, (args, connectorId) -> new Request((String)connectorId, (Boolean)args[0]));

        public Request(String connectorId, boolean indexName) {
            this.connectorId = connectorId;
            this.isNative = indexName;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.isNative = in.readBoolean();
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public boolean isNative() {
            return this.isNative;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.IS_NATIVE_FIELD.getPreferredName(), this.isNative);
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeBoolean(this.isNative);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.isNative == request.isNative && Objects.equals(this.connectorId, request.connectorId);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.isNative);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), Connector.IS_NATIVE_FIELD);
        }
    }
}

