/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.xpack.application.connector.ConnectorInvalidStatusTransitionException;
import org.elasticsearch.xpack.application.connector.ConnectorStatus;

public class ConnectorStateMachine {
    private static final Map<ConnectorStatus, Set<ConnectorStatus>> VALID_TRANSITIONS = Map.of(ConnectorStatus.CREATED, EnumSet.of(ConnectorStatus.NEEDS_CONFIGURATION, ConnectorStatus.ERROR), ConnectorStatus.NEEDS_CONFIGURATION, EnumSet.of(ConnectorStatus.CONFIGURED, ConnectorStatus.ERROR), ConnectorStatus.CONFIGURED, EnumSet.of(ConnectorStatus.NEEDS_CONFIGURATION, ConnectorStatus.CONFIGURED, ConnectorStatus.CONNECTED, ConnectorStatus.ERROR), ConnectorStatus.CONNECTED, EnumSet.of(ConnectorStatus.CONNECTED, ConnectorStatus.CONFIGURED, ConnectorStatus.ERROR), ConnectorStatus.ERROR, EnumSet.of(ConnectorStatus.CONNECTED, ConnectorStatus.CONFIGURED, ConnectorStatus.ERROR));

    public static boolean isValidTransition(ConnectorStatus current, ConnectorStatus next) {
        return ConnectorStateMachine.validNextStates(current).contains((Object)next);
    }

    public static void assertValidStateTransition(ConnectorStatus current, ConnectorStatus next) throws ConnectorInvalidStatusTransitionException {
        if (ConnectorStateMachine.isValidTransition(current, next)) {
            return;
        }
        throw new ConnectorInvalidStatusTransitionException(current, next);
    }

    public static Set<ConnectorStatus> validNextStates(ConnectorStatus current) {
        return VALID_TRANSITIONS.getOrDefault((Object)current, Collections.emptySet());
    }
}

