/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics;

import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollectionResolver;
import org.elasticsearch.xpack.application.analytics.action.PostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.ingest.AnalyticsEventEmitter;

public class AnalyticsEventIngestService {
    private final AnalyticsCollectionResolver collectionResolver;
    private final AnalyticsEventEmitter eventEmitter;

    @Inject
    public AnalyticsEventIngestService(AnalyticsEventEmitter eventEmitter, AnalyticsCollectionResolver collectionResolver) {
        this.eventEmitter = Objects.requireNonNull(eventEmitter, "eventEmitter cannot be null");
        this.collectionResolver = Objects.requireNonNull(collectionResolver, "collectionResolver cannot be null");
    }

    public void addEvent(PostAnalyticsEventAction.Request request, ActionListener<PostAnalyticsEventAction.Response> listener) {
        try {
            this.collectionResolver.collection(request.eventCollectionName());
        }
        catch (ResourceNotFoundException e) {
            listener.onFailure((Exception)((Object)e));
            return;
        }
        this.eventEmitter.emitEvent(request, listener);
    }
}

