/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.search.ClosePointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportClosePointInTimeAction;
import org.elasticsearch.action.search.TransportOpenPointInTimeAction;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.CountDownActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformEffectiveSettings;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformExtension;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.BulkIndexingException;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.transforms.TransformException;
import org.elasticsearch.xpack.transform.transforms.TransformIndexer;
import org.elasticsearch.xpack.transform.transforms.pivot.SchemaUtil;
import org.elasticsearch.xpack.transform.utils.ExceptionRootCauseFinder;

class ClientTransformIndexer
extends TransformIndexer {
    private static final TimeValue PIT_KEEP_ALIVE = TimeValue.timeValueSeconds((long)30L);
    private static final Logger logger = LogManager.getLogger(ClientTransformIndexer.class);
    private final ParentTaskAssigningClient client;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Settings destIndexSettings;
    private final AtomicBoolean oldStatsCleanedUp = new AtomicBoolean(false);
    private final AtomicReference<SeqNoPrimaryTermAndIndex> seqNoPrimaryTermAndIndexHolder;
    private final ConcurrentHashMap<String, PointInTimeBuilder> namedPits = new ConcurrentHashMap();
    private volatile long pitCheckpoint;
    private volatile boolean disablePit = false;

    ClientTransformIndexer(ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, TransformExtension transformExtension, TransformServices transformServices, CheckpointProvider checkpointProvider, AtomicReference<IndexerState> initialState, TransformIndexerPosition initialPosition, ParentTaskAssigningClient client, TransformIndexerStats initialStats, TransformConfig transformConfig, TransformProgress transformProgress, TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, TransformContext context, boolean shouldStopAtCheckpoint) {
        super((ThreadPool)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull((Object)threadPool, (String)"threadPool"), transformServices, checkpointProvider, transformConfig, (AtomicReference)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull(initialState, (String)"initialState"), initialPosition, initialStats == null ? new TransformIndexerStats() : initialStats, transformProgress, lastCheckpoint, nextCheckpoint, context);
        this.client = (ParentTaskAssigningClient)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull((Object)client, (String)"client");
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.destIndexSettings = transformExtension.getTransformDestinationIndexSettings();
        this.seqNoPrimaryTermAndIndexHolder = new AtomicReference<SeqNoPrimaryTermAndIndex>(seqNoPrimaryTermAndIndex);
        context.setShouldStopAtCheckpoint(shouldStopAtCheckpoint);
        this.disablePit = TransformEffectiveSettings.isPitDisabled((SettingsConfig)transformConfig.getSettings());
    }

    @Override
    public void applyNewSettings(SettingsConfig newSettings) {
        this.disablePit = TransformEffectiveSettings.isPitDisabled((SettingsConfig)newSettings);
        super.applyNewSettings(newSettings);
    }

    protected void doNextSearch(long waitTimeInNanos, ActionListener<SearchResponse> nextPhase) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to search while failed.", (Object)this.getJobId());
            nextPhase.onFailure((Exception)((Object)new ElasticsearchException("Attempted to do a search request for failed transform [{}].", new Object[]{this.getJobId()})));
            return;
        }
        if (this.getNextCheckpoint().getCheckpoint() != this.pitCheckpoint) {
            this.closePointInTime(() -> this.doNextSearch(nextPhase));
        } else {
            this.doNextSearch(nextPhase);
        }
    }

    private void doNextSearch(ActionListener<SearchResponse> nextPhase) {
        this.injectPointInTimeIfNeeded(this.buildSearchRequest(), (ActionListener<Tuple<String, SearchRequest>>)ActionListener.wrap(searchRequest -> this.doSearch((Tuple<String, SearchRequest>)searchRequest, nextPhase), arg_0 -> nextPhase.onFailure(arg_0)));
    }

    protected void doNextBulk(BulkRequest request, ActionListener<BulkResponse> nextPhase) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to bulk index while failed.", (Object)this.getJobId());
            nextPhase.onFailure((Exception)((Object)new ElasticsearchException("Attempted to do a bulk index request for failed transform [{}].", new Object[]{this.getJobId()})));
            return;
        }
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)TransportBulkAction.TYPE, (ActionRequest)request, (ActionListener)ActionListener.wrap(bulkResponse -> this.handleBulkResponse((BulkResponse)bulkResponse, nextPhase), arg_0 -> nextPhase.onFailure(arg_0)));
    }

    protected void handleBulkResponse(BulkResponse bulkResponse, ActionListener<BulkResponse> nextPhase) {
        if (!bulkResponse.hasFailures()) {
            this.context.resetReasonAndFailureCounter();
            nextPhase.onResponse((Object)bulkResponse);
            return;
        }
        int failureCount = 0;
        LinkedHashMap<String, BulkItemResponse> deduplicatedFailures = new LinkedHashMap<String, BulkItemResponse>();
        for (BulkItemResponse item : bulkResponse.getItems()) {
            if (!item.isFailed()) continue;
            Class<?> exceptionClass = item.getFailure().getCause().getClass();
            if (IndexNotFoundException.class.isAssignableFrom(exceptionClass)) {
                this.context.setShouldRecreateDestinationIndex(true);
            }
            deduplicatedFailures.putIfAbsent(exceptionClass.getSimpleName(), item);
            ++failureCount;
        }
        Throwable irrecoverableException = ExceptionRootCauseFinder.getFirstIrrecoverableExceptionFromBulkResponses(deduplicatedFailures.values());
        if (irrecoverableException == null) {
            String failureMessage = ClientTransformIndexer.getBulkIndexDetailedFailureMessage("Significant failures: ", deduplicatedFailures);
            logger.debug("[{}] Bulk index experienced [{}] failures. {}", (Object)this.getJobId(), (Object)failureCount, (Object)failureMessage);
            Exception firstException = ((BulkItemResponse)deduplicatedFailures.values().iterator().next()).getFailure().getCause();
            nextPhase.onFailure((Exception)((Object)new BulkIndexingException("Bulk index experienced [{}] failures. {}", firstException, false, failureCount, failureMessage)));
        } else {
            deduplicatedFailures.remove(irrecoverableException.getClass().getSimpleName());
            String failureMessage = ClientTransformIndexer.getBulkIndexDetailedFailureMessage("Other failures: ", deduplicatedFailures);
            irrecoverableException = ClientTransformIndexer.decorateBulkIndexException(irrecoverableException);
            logger.debug("[{}] Bulk index experienced [{}] failures and at least 1 irrecoverable [{}]. {}", (Object)this.getJobId(), (Object)failureCount, (Object)ExceptionRootCauseFinder.getDetailedMessage(irrecoverableException), (Object)failureMessage);
            nextPhase.onFailure((Exception)((Object)new BulkIndexingException("Bulk index experienced [{}] failures and at least 1 irrecoverable [{}]. {}", irrecoverableException, true, failureCount, ExceptionRootCauseFinder.getDetailedMessage(irrecoverableException), failureMessage)));
        }
    }

    @Override
    protected void doDeleteByQuery(DeleteByQueryRequest deleteByQueryRequest, ActionListener<BulkByScrollResponse> responseListener) {
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, responseListener);
    }

    @Override
    protected void refreshDestinationIndex(ActionListener<Void> responseListener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)RefreshAction.INSTANCE, (ActionRequest)new RefreshRequest(new String[]{this.transformConfig.getDestination().getIndex()}), (ActionListener)ActionListener.wrap(refreshResponse -> {
            if (refreshResponse.getFailedShards() > 0) {
                logger.warn("[{}] failed to refresh transform destination index, not all data might be available after checkpoint.", (Object)this.getJobId());
            }
            responseListener.onResponse(null);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                responseListener.onResponse(null);
                return;
            }
            responseListener.onFailure(e);
        }));
    }

    @Override
    void doGetInitialProgress(SearchRequest request, ActionListener<SearchResponse> responseListener) {
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)TransportSearchAction.TYPE, (ActionRequest)request, responseListener);
    }

    @Override
    void doGetFieldMappings(ActionListener<Map<String, String>> fieldMappingsListener) {
        SchemaUtil.getDestinationFieldMappings((Client)this.client, this.getConfig().getDestination().getIndex(), fieldMappingsListener);
    }

    @Override
    void doMaybeCreateDestIndex(Map<String, String> deducedDestIndexMappings, ActionListener<Boolean> listener) {
        TransformIndex.createDestinationIndex((Client)this.client, this.auditor, this.indexNameExpressionResolver, this.clusterService.state(), this.transformConfig, this.destIndexSettings, deducedDestIndexMappings, listener);
    }

    @Override
    void validate(ActionListener<ValidateTransformAction.Response> listener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)ValidateTransformAction.INSTANCE, (ActionRequest)new ValidateTransformAction.Request(this.transformConfig, false, AcknowledgedRequest.DEFAULT_ACK_TIMEOUT), listener);
    }

    @Override
    protected void persistState(TransformState state, ActionListener<Void> listener) {
        SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex = this.getSeqNoPrimaryTermAndIndex();
        this.transformsConfigManager.putOrUpdateTransformStoredDoc(new TransformStoredDoc(this.getJobId(), state, (TransformIndexerStats)this.getStats()), seqNoPrimaryTermAndIndex, (ActionListener<SeqNoPrimaryTermAndIndex>)ActionListener.wrap(r -> {
            this.updateSeqNoPrimaryTermAndIndex(seqNoPrimaryTermAndIndex, (SeqNoPrimaryTermAndIndex)r);
            this.context.resetStatePersistenceFailureCount();
            if (this.oldStatsCleanedUp.compareAndSet(false, true)) {
                this.transformsConfigManager.deleteOldTransformStoredDocuments(this.getJobId(), (ActionListener<Long>)ActionListener.wrap(deletedDocs -> {
                    logger.trace("[{}] deleted old transform stats and state document, deleted: [{}] documents", (Object)this.getJobId(), deletedDocs);
                    listener.onResponse(null);
                }, e -> {
                    String msg = LoggerMessageFormat.format((String)"[{}] failed deleting old transform configurations.", (String)this.getJobId(), (Object[])new Object[0]);
                    logger.warn(msg, (Throwable)e);
                    this.oldStatsCleanedUp.set(false);
                    listener.onResponse(null);
                }));
            } else {
                listener.onResponse(null);
            }
        }, statsExc -> {
            if (ExceptionsHelper.unwrapCause((Throwable)statsExc) instanceof VersionConflictEngineException) {
                logger.warn(() -> Strings.format((String)"[%s] updating stats of transform failed, unexpected version conflict of internal state, resetting to recover.", (Object[])new Object[]{this.transformConfig.getId()}), (Throwable)statsExc);
                this.auditor.warning(this.getJobId(), "Failure updating stats of transform, unexpected version conflict of internal state, resetting to recover: " + statsExc.getMessage());
                if (this.failureHandler.handleStatePersistenceFailure((Exception)statsExc, this.getConfig().getSettings())) {
                    this.transformsConfigManager.getTransformStoredDoc(this.transformConfig.getId(), false, (ActionListener<Tuple<TransformStoredDoc, SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(storedDocAndSeqNoPrimaryTerm -> {
                        this.updateSeqNoPrimaryTermAndIndex(seqNoPrimaryTermAndIndex, (SeqNoPrimaryTermAndIndex)storedDocAndSeqNoPrimaryTerm.v2());
                        listener.onFailure(statsExc);
                    }, e2 -> listener.onFailure(statsExc)));
                    return;
                }
            } else {
                logger.warn(() -> "[" + this.transformConfig.getId() + "] updating stats of transform failed.", (Throwable)statsExc);
                this.auditor.warning(this.getJobId(), "Failure updating stats of transform: " + statsExc.getMessage());
                this.failureHandler.handleStatePersistenceFailure((Exception)statsExc, this.getConfig().getSettings());
            }
            listener.onFailure(statsExc);
        }));
    }

    void updateSeqNoPrimaryTermAndIndex(SeqNoPrimaryTermAndIndex expectedValue, SeqNoPrimaryTermAndIndex newValue) {
        logger.debug(() -> Strings.format((String)"[%s] Updated state document from [%s] to [%s]", (Object[])new Object[]{this.transformConfig.getId(), expectedValue, newValue}));
        boolean updated = this.seqNoPrimaryTermAndIndexHolder.compareAndSet(expectedValue, newValue);
        if (!updated) {
            logger.warn("[{}] Unexpected change to internal state detected, expected [{}], got [{}]", (Object)this.transformConfig.getId(), (Object)expectedValue, (Object)this.seqNoPrimaryTermAndIndexHolder.get());
            assert (updated) : "[" + this.getJobId() + "] unexpected change to seqNoPrimaryTermAndIndex.";
        }
    }

    @Nullable
    SeqNoPrimaryTermAndIndex getSeqNoPrimaryTermAndIndex() {
        return this.seqNoPrimaryTermAndIndexHolder.get();
    }

    @Override
    protected void afterFinishOrFailure() {
        this.closePointInTime(() -> super.afterFinishOrFailure());
    }

    @Override
    public boolean maybeTriggerAsyncJob(long now) {
        if (TransformMetadata.upgradeMode((ClusterState)this.clusterService.state())) {
            logger.debug("[{}] schedule was triggered but the Transform is upgrading. Ignoring trigger.", (Object)this.getJobId());
            return false;
        }
        if (this.context.isWaitingForIndexToUnblock()) {
            if (this.destinationIndexHasWriteBlock()) {
                logger.debug("[{}] schedule was triggered but the destination index has a write block. Ignoring trigger.", (Object)this.getJobId());
                return false;
            }
            logger.debug("[{}] destination index is no longer blocked.", (Object)this.getJobId());
            this.context.setIsWaitingForIndexToUnblock(false);
        }
        return super.maybeTriggerAsyncJob(now);
    }

    private boolean destinationIndexHasWriteBlock() {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState == null) {
            return false;
        }
        String destinationIndexName = this.transformConfig.getDestination().getIndex();
        Index destinationIndex = this.indexNameExpressionResolver.concreteWriteIndex(clusterState, IndicesOptions.lenientExpandOpen(), destinationIndexName, true, false);
        return destinationIndex != null && clusterState.blocks().indexBlocked(ClusterBlockLevel.WRITE, destinationIndex.getName());
    }

    @Override
    protected void onStop() {
        this.closePointInTime(() -> super.onStop());
    }

    void closePointInTime(Runnable runAfter) {
        ArrayList<Map.Entry<String, PointInTimeBuilder>> pitEntries = new ArrayList<Map.Entry<String, PointInTimeBuilder>>(this.namedPits.size());
        Iterator<Map.Entry<String, PointInTimeBuilder>> iter = this.namedPits.entrySet().iterator();
        while (iter.hasNext()) {
            pitEntries.add(iter.next());
            iter.remove();
        }
        if (pitEntries.isEmpty()) {
            runAfter.run();
        } else {
            CountDownActionListener countDownActionListener = new CountDownActionListener(pitEntries.size(), ActionListener.running((Runnable)runAfter));
            pitEntries.stream().map(Map.Entry::getValue).filter(Objects::nonNull).forEach(pit -> this.closePointInTime((PointInTimeBuilder)pit, (ActionListener<Void>)countDownActionListener));
        }
    }

    private void closePointInTime(PointInTimeBuilder pit, ActionListener<Void> listener) {
        BytesReference oldPit = pit.getEncodedId();
        ClosePointInTimeRequest closePitRequest = new ClosePointInTimeRequest(oldPit);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)TransportClosePointInTimeAction.TYPE, (ActionRequest)closePitRequest, (ActionListener)ActionListener.runAfter((ActionListener)ActionListener.wrap(response -> logger.trace("[{}] closed pit search context [{}]", (Object)this.getJobId(), (Object)oldPit), e -> logger.error(() -> "[" + this.getJobId() + "] Failed to close point in time reader", (Throwable)e)), () -> listener.onResponse(null)));
    }

    private void injectPointInTimeIfNeeded(Tuple<String, SearchRequest> namedSearchRequest, ActionListener<Tuple<String, SearchRequest>> listener) {
        SearchRequest searchRequest = (SearchRequest)namedSearchRequest.v2();
        if (this.disablePit || searchRequest.indices().length == 0 || this.transformConfig.getSource().requiresRemoteCluster()) {
            listener.onResponse(namedSearchRequest);
            return;
        }
        PointInTimeBuilder pit = this.namedPits.get(namedSearchRequest.v1());
        if (pit != null) {
            searchRequest.source().pointInTimeBuilder(pit);
            listener.onResponse(namedSearchRequest);
            return;
        }
        OpenPointInTimeRequest pitRequest = new OpenPointInTimeRequest(searchRequest.indices()).keepAlive(PIT_KEEP_ALIVE);
        pitRequest.indexFilter(this.transformConfig.getSource().getQueryConfig().getQuery());
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)TransportOpenPointInTimeAction.TYPE, (ActionRequest)pitRequest, (ActionListener)ActionListener.wrap(response -> {
            PointInTimeBuilder newPit = new PointInTimeBuilder(response.getPointInTimeId()).setKeepAlive(PIT_KEEP_ALIVE);
            this.namedPits.put((String)namedSearchRequest.v1(), newPit);
            searchRequest.source().pointInTimeBuilder(newPit);
            this.pitCheckpoint = this.getNextCheckpoint().getCheckpoint();
            logger.trace("[{}] using pit search context with id [{}]; request [{}]", (Object)this.getJobId(), (Object)newPit.getEncodedId(), namedSearchRequest.v1());
            listener.onResponse((Object)namedSearchRequest);
        }, e -> {
            Throwable unwrappedException = org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.findSearchExceptionRootCause((Throwable)e);
            if (unwrappedException instanceof ResourceNotFoundException) {
                listener.onFailure(e);
                return;
            }
            if (unwrappedException instanceof ActionNotFoundTransportException) {
                logger.warn("[{}] source does not support point in time reader, falling back to normal search (more resource intensive)", (Object)this.getJobId());
                this.auditor.warning(this.getJobId(), "Source does not support point in time reader, falling back to normal search (more resource intensive)");
                this.disablePit = true;
            } else {
                logger.warn(() -> Strings.format((String)"[%s] Failed to create a point in time reader, falling back to normal search.", (Object[])new Object[]{this.getJobId()}), (Throwable)e);
            }
            listener.onResponse((Object)namedSearchRequest);
        }));
    }

    void doSearch(Tuple<String, SearchRequest> namedSearchRequest, ActionListener<SearchResponse> listener) {
        String name = (String)namedSearchRequest.v1();
        SearchRequest originalRequest = (SearchRequest)namedSearchRequest.v2();
        if (originalRequest.indices().length == 0) {
            logger.debug("[{}] Search request [{}] optimized to noop; searchRequest [{}]", (Object)this.getJobId(), (Object)name, (Object)originalRequest);
            listener.onResponse(null);
            return;
        }
        PointInTimeBuilder pit = originalRequest.pointInTimeBuilder();
        SearchRequest searchRequest = pit != null ? new SearchRequest(originalRequest).indices(new String[0]).indicesOptions(SearchRequest.DEFAULT_INDICES_OPTIONS) : originalRequest;
        logger.trace("searchRequest: [{}]", (Object)searchRequest);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.pointInTimeId() != null && !(pit == null || response.pointInTimeId().equals(pit.getEncodedId()))) {
                this.namedPits.put(name, new PointInTimeBuilder(response.pointInTimeId()).setKeepAlive(PIT_KEEP_ALIVE));
                logger.trace("point in time handle has changed; request [{}]", (Object)name);
            }
            listener.onResponse(response);
        }, e -> {
            Throwable unwrappedException = org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.findSearchExceptionRootCause((Throwable)e);
            if (unwrappedException instanceof SearchContextMissingException) {
                logger.warn(() -> Strings.format((String)"[%s] Search context missing, falling back to normal search; request [%s]", (Object[])new Object[]{this.getJobId(), name}), (Throwable)e);
                this.namedPits.remove(name);
                originalRequest.source().pointInTimeBuilder(null);
                ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)TransportSearchAction.TYPE, (ActionRequest)originalRequest, (ActionListener)listener);
                return;
            }
            if (unwrappedException instanceof IndexNotFoundException && pit != null) {
                this.namedPits.remove(name);
                originalRequest.source().pointInTimeBuilder(null);
                ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)TransportSearchAction.TYPE, (ActionRequest)originalRequest, (ActionListener)listener);
                return;
            }
            listener.onFailure(e);
        }));
    }

    private static String getBulkIndexDetailedFailureMessage(String prefix, Map<String, BulkItemResponse> failures) {
        if (failures.isEmpty()) {
            return "";
        }
        StringBuilder failureMessageBuilder = new StringBuilder(prefix);
        for (Map.Entry<String, BulkItemResponse> failure : failures.entrySet()) {
            failureMessageBuilder.append("\n[").append(failure.getKey()).append("] message [").append(failure.getValue().getFailureMessage()).append("]");
        }
        String failureMessage = failureMessageBuilder.toString();
        return failureMessage;
    }

    private static Throwable decorateBulkIndexException(Throwable irrecoverableException) {
        if (irrecoverableException instanceof DocumentParsingException) {
            return new TransformException("Destination index mappings are incompatible with the transform configuration.", irrecoverableException, new Object[0]);
        }
        return irrecoverableException;
    }
}

