/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.querydsl.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public final class SingleValueMatchQuery
extends Query {
    private static final int MULTI_VALUE_MATCH_COST = 1000;
    private static final IllegalArgumentException MULTI_VALUE_EXCEPTION = new IllegalArgumentException("single-value function encountered multi-value");
    private final IndexFieldData<?> fieldData;
    private final Warnings warnings;

    public SingleValueMatchQuery(IndexFieldData<?> fieldData, Warnings warnings) {
        this.fieldData = fieldData;
        this.warnings = warnings;
    }

    public String toString(String field) {
        StringBuilder builder = new StringBuilder("single_value_match(");
        if (!this.fieldData.getFieldName().equals(field)) {
            builder.append(this.fieldData.getFieldName());
        }
        return builder.append(")").toString();
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                LeafFieldData lfd = SingleValueMatchQuery.this.fieldData.load(context);
                if (lfd == null) {
                    return null;
                }
                if (lfd instanceof LeafNumericFieldData) {
                    LeafNumericFieldData n = (LeafNumericFieldData)lfd;
                    return this.scorerSupplier(context, n.getLongValues(), (Weight)this, boost, scoreMode);
                }
                if (lfd instanceof LeafOrdinalsFieldData) {
                    LeafOrdinalsFieldData o = (LeafOrdinalsFieldData)lfd;
                    return this.scorerSupplier(context, o.getOrdinalsValues(), (Weight)this, boost, scoreMode);
                }
                return this.scorerSupplier(context, lfd.getBytesValues(), (Weight)this, boost, scoreMode);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            private ScorerSupplier scorerSupplier(LeafReaderContext context, SortedNumericDocValues sortedNumerics, Weight weight, float boost2, ScoreMode scoreMode2) throws IOException {
                int maxDoc = context.reader().maxDoc();
                if (DocValues.unwrapSingleton((SortedNumericDocValues)sortedNumerics) != null) {
                    PointValues points = context.reader().getPointValues(SingleValueMatchQuery.this.fieldData.getFieldName());
                    if (points != null && points.getDocCount() == maxDoc) {
                        return new DocIdSetIteratorScorerSupplier(weight, boost2, scoreMode2, DocIdSetIterator.all((int)maxDoc));
                    }
                    return new PredicateScorerSupplier(weight, boost2, scoreMode2, maxDoc, 1000, x$0 -> sortedNumerics.advanceExact(x$0));
                }
                CheckedIntPredicate predicate = doc -> {
                    if (!sortedNumerics.advanceExact(doc)) {
                        return false;
                    }
                    if (sortedNumerics.docValueCount() != 1) {
                        SingleValueMatchQuery.this.warnings.registerException(MULTI_VALUE_EXCEPTION);
                        return false;
                    }
                    return true;
                };
                return new PredicateScorerSupplier(weight, boost2, scoreMode2, maxDoc, 1000, predicate);
            }

            private ScorerSupplier scorerSupplier(LeafReaderContext context, SortedSetDocValues sortedSetDocValues, Weight weight, float boost2, ScoreMode scoreMode2) throws IOException {
                int maxDoc = context.reader().maxDoc();
                if (DocValues.unwrapSingleton((SortedSetDocValues)sortedSetDocValues) != null) {
                    Terms terms = context.reader().terms(SingleValueMatchQuery.this.fieldData.getFieldName());
                    if (terms != null && terms.getDocCount() == maxDoc) {
                        return new DocIdSetIteratorScorerSupplier(weight, boost2, scoreMode2, DocIdSetIterator.all((int)maxDoc));
                    }
                    return new PredicateScorerSupplier(weight, boost2, scoreMode2, maxDoc, 1000, x$0 -> sortedSetDocValues.advanceExact(x$0));
                }
                CheckedIntPredicate predicate = doc -> {
                    if (!sortedSetDocValues.advanceExact(doc)) {
                        return false;
                    }
                    if (sortedSetDocValues.docValueCount() != 1) {
                        SingleValueMatchQuery.this.warnings.registerException(MULTI_VALUE_EXCEPTION);
                        return false;
                    }
                    return true;
                };
                return new PredicateScorerSupplier(weight, boost2, scoreMode2, maxDoc, 1000, predicate);
            }

            private ScorerSupplier scorerSupplier(LeafReaderContext context, SortedBinaryDocValues sortedBinaryDocValues, Weight weight, float boost2, ScoreMode scoreMode2) {
                int maxDoc = context.reader().maxDoc();
                if (FieldData.unwrapSingleton((SortedBinaryDocValues)sortedBinaryDocValues) != null) {
                    return new PredicateScorerSupplier(weight, boost2, scoreMode2, maxDoc, 1000, arg_0 -> ((SortedBinaryDocValues)sortedBinaryDocValues).advanceExact(arg_0));
                }
                CheckedIntPredicate predicate = doc -> {
                    if (!sortedBinaryDocValues.advanceExact(doc)) {
                        return false;
                    }
                    if (sortedBinaryDocValues.docValueCount() != 1) {
                        SingleValueMatchQuery.this.warnings.registerException(MULTI_VALUE_EXCEPTION);
                        return false;
                    }
                    return true;
                };
                return new PredicateScorerSupplier(weight, boost2, scoreMode2, maxDoc, 1000, predicate);
            }
        };
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        for (LeafReaderContext context : indexSearcher.getIndexReader().leaves()) {
            LeafFieldData lfd = this.fieldData.load(context);
            if (lfd instanceof LeafNumericFieldData) {
                PointValues pointValues = context.reader().getPointValues(this.fieldData.getFieldName());
                if (pointValues != null && pointValues.getDocCount() == context.reader().maxDoc() && pointValues.size() == (long)pointValues.getDocCount()) continue;
                return super.rewrite(indexSearcher);
            }
            if (lfd instanceof LeafOrdinalsFieldData) {
                Terms terms = context.reader().terms(this.fieldData.getFieldName());
                if (terms != null && terms.getDocCount() == context.reader().maxDoc() && terms.getSumDocFreq() == (long)terms.getDocCount()) continue;
                return super.rewrite(indexSearcher);
            }
            return super.rewrite(indexSearcher);
        }
        return new MatchAllDocsQuery();
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldData.getFieldName())) {
            visitor.visitLeaf((Query)this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        SingleValueMatchQuery other = (SingleValueMatchQuery)((Object)obj);
        return this.fieldData.getFieldName().equals(other.fieldData.getFieldName());
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.fieldData.getFieldName());
    }

    @FunctionalInterface
    private static interface CheckedIntPredicate {
        public boolean test(int var1) throws IOException;
    }

    private static class PredicateScorerSupplier
    extends ScorerSupplier {
        private final Weight weight;
        private final float score;
        private final ScoreMode scoreMode;
        private final int maxDoc;
        private final int matchCost;
        private final CheckedIntPredicate predicate;

        private PredicateScorerSupplier(Weight weight, float score, ScoreMode scoreMode, int maxDoc, int matchCost, CheckedIntPredicate predicate) {
            this.weight = weight;
            this.score = score;
            this.scoreMode = scoreMode;
            this.maxDoc = maxDoc;
            this.matchCost = matchCost;
            this.predicate = predicate;
        }

        public Scorer get(long leadCost) {
            TwoPhaseIterator iterator = new TwoPhaseIterator(DocIdSetIterator.all((int)this.maxDoc)){

                public boolean matches() throws IOException {
                    return predicate.test(this.approximation.docID());
                }

                public float matchCost() {
                    return matchCost;
                }
            };
            return new ConstantScoreScorer(this.weight, this.score, this.scoreMode, iterator);
        }

        public long cost() {
            return this.maxDoc;
        }
    }

    private static class DocIdSetIteratorScorerSupplier
    extends ScorerSupplier {
        private final Weight weight;
        private final float score;
        private final ScoreMode scoreMode;
        private final DocIdSetIterator docIdSetIterator;

        private DocIdSetIteratorScorerSupplier(Weight weight, float score, ScoreMode scoreMode, DocIdSetIterator docIdSetIterator) {
            this.weight = weight;
            this.score = score;
            this.scoreMode = scoreMode;
            this.docIdSetIterator = docIdSetIterator;
        }

        public Scorer get(long leadCost) {
            return new ConstantScoreScorer(this.weight, this.score, this.scoreMode, this.docIdSetIterator);
        }

        public long cost() {
            return this.docIdSetIterator.cost();
        }
    }
}

