/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class AddPage
implements Releasable {
    private final BlockFactory blockFactory;
    private final long emitBatchSize;
    private final GroupingAggregatorFunction.AddInput addInput;
    private int positionOffset = 0;
    private long added = 0L;
    private IntBlock.Builder ords;
    private int firstOrd = -1;

    public AddPage(BlockFactory blockFactory, int emitBatchSize, GroupingAggregatorFunction.AddInput addInput) {
        this.blockFactory = blockFactory;
        this.emitBatchSize = emitBatchSize;
        this.addInput = addInput;
        this.ords = blockFactory.newIntBlockBuilder(emitBatchSize);
    }

    long added() {
        return this.added;
    }

    protected final void appendOrdSv(int position, int ord) {
        assert (this.firstOrd == -1) : "currently in a multivalue position";
        this.ords.appendInt(ord);
        if (++this.added % this.emitBatchSize == 0L) {
            this.rollover(position + 1);
        }
    }

    @Deprecated
    protected final void appendNullSv(int position) {
        this.ords.appendNull();
        if (++this.added % this.emitBatchSize == 0L) {
            this.rollover(position + 1);
        }
    }

    protected final void appendOrdInMv(int position, int ord) {
        if (++this.added % this.emitBatchSize == 0L) {
            switch (this.firstOrd) {
                case -1: {
                    this.ords.appendInt(ord);
                    break;
                }
                case -2: {
                    this.ords.appendInt(ord);
                    this.ords.endPositionEntry();
                    break;
                }
                default: {
                    assert (this.firstOrd >= 0);
                    this.ords.beginPositionEntry();
                    this.ords.appendInt(this.firstOrd);
                    this.ords.appendInt(ord);
                    this.ords.endPositionEntry();
                }
            }
            this.rollover(position);
            this.firstOrd = -1;
            return;
        }
        switch (this.firstOrd) {
            case -1: {
                this.firstOrd = ord;
                break;
            }
            case -2: {
                this.ords.appendInt(ord);
                break;
            }
            default: {
                assert (this.firstOrd >= 0);
                this.ords.beginPositionEntry();
                this.ords.appendInt(this.firstOrd);
                this.ords.appendInt(ord);
                this.firstOrd = -2;
            }
        }
    }

    protected final void finishMv() {
        switch (this.firstOrd) {
            case -1: {
                this.ords.appendNull();
                break;
            }
            case -2: {
                this.ords.endPositionEntry();
                break;
            }
            default: {
                this.ords.appendInt(this.firstOrd);
            }
        }
        this.firstOrd = -1;
    }

    protected final void flushRemaining() {
        if (this.firstOrd != -1) {
            throw new IllegalStateException("in the middle of a position");
        }
        if (this.added % this.emitBatchSize != 0L) {
            this.emitOrds();
        }
    }

    private void emitOrds() {
        try (IntBlock ordsBlock = this.ords.build();){
            this.addInput.add(this.positionOffset, ordsBlock);
        }
    }

    private void rollover(int position) {
        this.emitOrds();
        this.positionOffset = position;
        this.ords = this.blockFactory.newIntBlockBuilder(Math.toIntExact(this.emitBatchSize));
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.ords);
    }
}

