/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.ValueSource;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class SetProcessor
extends AbstractProcessor {
    public static final String TYPE = "set";
    private final boolean overrideEnabled;
    private final TemplateScript.Factory field;
    private final ValueSource value;
    private final String copyFrom;
    private final boolean ignoreEmptyValue;

    SetProcessor(String tag, String description, TemplateScript.Factory field, ValueSource value, String copyFrom) {
        this(tag, description, field, value, copyFrom, true, false);
    }

    SetProcessor(String tag, String description, TemplateScript.Factory field, ValueSource value, String copyFrom, boolean overrideEnabled, boolean ignoreEmptyValue) {
        super(tag, description);
        this.overrideEnabled = overrideEnabled;
        this.field = field;
        this.value = value;
        this.copyFrom = copyFrom;
        this.ignoreEmptyValue = ignoreEmptyValue;
    }

    public boolean isOverrideEnabled() {
        return this.overrideEnabled;
    }

    public TemplateScript.Factory getField() {
        return this.field;
    }

    public ValueSource getValue() {
        return this.value;
    }

    public String getCopyFrom() {
        return this.copyFrom;
    }

    public boolean isIgnoreEmptyValue() {
        return this.ignoreEmptyValue;
    }

    public IngestDocument execute(IngestDocument document) {
        String path = document.renderTemplate(this.field);
        if (this.overrideEnabled || !document.hasField(path) || document.getFieldValue(path, Object.class) == null) {
            if (this.copyFrom != null) {
                Object fieldValue = document.getFieldValue(this.copyFrom, Object.class, this.ignoreEmptyValue);
                document.setFieldValue(path, IngestDocument.deepCopy((Object)fieldValue), this.ignoreEmptyValue);
            } else {
                document.setFieldValue(path, this.value, this.ignoreEmptyValue);
            }
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public SetProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"field");
            String copyFrom = ConfigurationUtils.readOptionalStringProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"copy_from");
            String mediaType = ConfigurationUtils.readMediaTypeProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"media_type", (String)"application/json");
            ValueSource valueSource = null;
            if (copyFrom == null) {
                value = ConfigurationUtils.readObject((String)SetProcessor.TYPE, (String)processorTag, config, (String)"value");
                valueSource = ValueSource.wrap((Object)value, (ScriptService)this.scriptService, Map.of("content_type", mediaType));
            } else {
                value = config.remove("value");
                if (value != null) {
                    throw ConfigurationUtils.newConfigurationException((String)SetProcessor.TYPE, (String)processorTag, (String)"copy_from", (String)"cannot set both `copy_from` and `value` in the same processor");
                }
            }
            boolean overrideEnabled = ConfigurationUtils.readBooleanProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"override", (boolean)true);
            TemplateScript.Factory compiledTemplate = ConfigurationUtils.compileTemplate((String)SetProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (ScriptService)this.scriptService);
            boolean ignoreEmptyValue = ConfigurationUtils.readBooleanProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"ignore_empty_value", (boolean)false);
            return new SetProcessor(processorTag, description, compiledTemplate, valueSource, copyFrom, overrideEnabled, ignoreEmptyValue);
        }
    }
}

