/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class RerouteProcessor
extends AbstractProcessor {
    public static final String TYPE = "reroute";
    private static final String NAMING_SCHEME_ERROR_MESSAGE = "invalid data stream name: [%s]; must follow naming scheme <type>-<dataset>-<namespace>";
    private static final String DATA_STREAM_PREFIX = "data_stream.";
    private static final String DATA_STREAM_TYPE = "data_stream.type";
    private static final String DATA_STREAM_DATASET = "data_stream.dataset";
    private static final String DATA_STREAM_NAMESPACE = "data_stream.namespace";
    private static final String EVENT_DATASET = "event.dataset";
    private final List<DataStreamValueSource> type;
    private final List<DataStreamValueSource> dataset;
    private final List<DataStreamValueSource> namespace;
    private final String destination;

    RerouteProcessor(String tag, String description, List<DataStreamValueSource> type, List<DataStreamValueSource> dataset, List<DataStreamValueSource> namespace, String destination) {
        super(tag, description);
        this.type = type.isEmpty() ? List.of(DataStreamValueSource.TYPE_VALUE_SOURCE) : type;
        this.dataset = dataset.isEmpty() ? List.of(DataStreamValueSource.DATASET_VALUE_SOURCE) : dataset;
        this.namespace = namespace.isEmpty() ? List.of(DataStreamValueSource.NAMESPACE_VALUE_SOURCE) : namespace;
        this.destination = destination;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        if (this.destination != null) {
            ingestDocument.reroute(this.destination);
            return ingestDocument;
        }
        String indexName = (String)ingestDocument.getFieldValue(IngestDocument.Metadata.INDEX.getFieldName(), String.class);
        int indexOfFirstDash = indexName.indexOf(45);
        if (indexOfFirstDash < 0) {
            throw new IllegalArgumentException(Strings.format((String)NAMING_SCHEME_ERROR_MESSAGE, (Object[])new Object[]{indexName}));
        }
        int indexOfSecondDash = indexName.indexOf(45, indexOfFirstDash + 1);
        if (indexOfSecondDash < 0) {
            throw new IllegalArgumentException(Strings.format((String)NAMING_SCHEME_ERROR_MESSAGE, (Object[])new Object[]{indexName}));
        }
        String currentType = RerouteProcessor.parseDataStreamType(indexName, indexOfFirstDash);
        String currentDataset = RerouteProcessor.parseDataStreamDataset(indexName, indexOfFirstDash, indexOfSecondDash);
        String currentNamespace = RerouteProcessor.parseDataStreamNamespace(indexName, indexOfSecondDash);
        String type = RerouteProcessor.determineDataStreamField(ingestDocument, this.type, currentType);
        String dataset = RerouteProcessor.determineDataStreamField(ingestDocument, this.dataset, currentDataset);
        String namespace = RerouteProcessor.determineDataStreamField(ingestDocument, this.namespace, currentNamespace);
        String newTarget = type + "-" + dataset + "-" + namespace;
        ingestDocument.reroute(newTarget);
        RerouteProcessor.setFieldValue(ingestDocument, DATA_STREAM_TYPE, type);
        RerouteProcessor.setFieldValue(ingestDocument, DATA_STREAM_DATASET, dataset);
        RerouteProcessor.setFieldValue(ingestDocument, DATA_STREAM_NAMESPACE, namespace);
        if (ingestDocument.getCtxMap().containsKey((Object)EVENT_DATASET) || ingestDocument.hasField(EVENT_DATASET)) {
            RerouteProcessor.setFieldValue(ingestDocument, EVENT_DATASET, dataset);
        }
        return ingestDocument;
    }

    private static void setFieldValue(IngestDocument doc, String path, String value) {
        Map source = doc.getSourceAndMetadata();
        if (source.containsKey(path)) {
            source.put(path, value);
        } else {
            doc.setFieldValue(path, (Object)value);
        }
    }

    private static String parseDataStreamType(String dataStreamName, int indexOfFirstDash) {
        return dataStreamName.substring(0, indexOfFirstDash);
    }

    private static String parseDataStreamDataset(String dataStreamName, int indexOfFirstDash, int indexOfSecondDash) {
        return dataStreamName.substring(indexOfFirstDash + 1, indexOfSecondDash);
    }

    private static String parseDataStreamNamespace(String dataStreamName, int indexOfSecondDash) {
        return dataStreamName.substring(indexOfSecondDash + 1);
    }

    private static String determineDataStreamField(IngestDocument ingestDocument, List<DataStreamValueSource> valueSources, String fallbackFromCurrentTarget) {
        for (DataStreamValueSource value : valueSources) {
            String result = value.resolve(ingestDocument);
            if (result == null) continue;
            return result;
        }
        return fallbackFromCurrentTarget;
    }

    public String getType() {
        return TYPE;
    }

    List<DataStreamValueSource> getDataStreamDataset() {
        return this.dataset;
    }

    List<DataStreamValueSource> getDataStreamNamespace() {
        return this.namespace;
    }

    String getDestination() {
        return this.destination;
    }

    static final class DataStreamValueSource {
        private static final int MAX_LENGTH = 100;
        private static final String REPLACEMENT = "_";
        private static final Pattern DISALLOWED_IN_TYPE = Pattern.compile("[\\\\/*?\"<>| ,#:-]");
        private static final Pattern DISALLOWED_IN_DATASET = Pattern.compile("[\\\\/*?\"<>| ,#:-]");
        private static final Pattern DISALLOWED_IN_NAMESPACE = Pattern.compile("[\\\\/*?\"<>| ,#:]");
        static final DataStreamValueSource TYPE_VALUE_SOURCE = DataStreamValueSource.type("{{data_stream.type}}");
        static final DataStreamValueSource DATASET_VALUE_SOURCE = DataStreamValueSource.dataset("{{data_stream.dataset}}");
        static final DataStreamValueSource NAMESPACE_VALUE_SOURCE = DataStreamValueSource.namespace("{{data_stream.namespace}}");
        private final String value;
        private final String fieldReference;
        private final Function<String, String> sanitizer;

        public static DataStreamValueSource type(String type) {
            return new DataStreamValueSource(type, ds -> DataStreamValueSource.sanitizeDataStreamField(ds, DISALLOWED_IN_TYPE));
        }

        public static DataStreamValueSource dataset(String dataset) {
            return new DataStreamValueSource(dataset, ds -> DataStreamValueSource.sanitizeDataStreamField(ds, DISALLOWED_IN_DATASET));
        }

        public static DataStreamValueSource namespace(String namespace) {
            return new DataStreamValueSource(namespace, nsp -> DataStreamValueSource.sanitizeDataStreamField(nsp, DISALLOWED_IN_NAMESPACE));
        }

        private static String sanitizeDataStreamField(String s, Pattern disallowedInDataset) {
            if (s == null) {
                return null;
            }
            s = s.toLowerCase(Locale.ROOT);
            s = s.substring(0, Math.min(s.length(), 100));
            return disallowedInDataset.matcher(s).replaceAll(REPLACEMENT);
        }

        private DataStreamValueSource(String value, Function<String, String> sanitizer) {
            this.sanitizer = sanitizer;
            this.value = value;
            if (value.contains("{{") || value.contains("}}")) {
                if (!value.startsWith("{{") || !value.endsWith("}}")) {
                    throw new IllegalArgumentException("'" + value + "' is not a valid field reference");
                }
                String fieldReference = value.substring(2, value.length() - 2);
                if (fieldReference.startsWith("{") && fieldReference.endsWith("}")) {
                    fieldReference = fieldReference.substring(1, fieldReference.length() - 1);
                }
                if ((fieldReference = fieldReference.trim()).contains("{") || fieldReference.contains("}")) {
                    throw new IllegalArgumentException("'" + value + "' is not a valid field reference");
                }
                this.fieldReference = fieldReference;
            } else {
                this.fieldReference = null;
                if (!Objects.equals(sanitizer.apply(value), value)) {
                    throw new IllegalArgumentException("'" + value + "' contains disallowed characters");
                }
            }
        }

        @Nullable
        public String resolve(IngestDocument ingestDocument) {
            if (this.fieldReference != null) {
                String value = (String)ingestDocument.getFieldValue(this.fieldReference, String.class, true);
                if (value == null) {
                    value = this.getStringFieldValueInDottedNotation(ingestDocument);
                }
                return this.sanitizer.apply(value);
            }
            return this.value;
        }

        private String getStringFieldValueInDottedNotation(IngestDocument ingestDocument) {
            String value = null;
            Object valueObject = ingestDocument.getCtxMap().get((Object)this.fieldReference);
            if (valueObject instanceof String) {
                value = (String)valueObject;
            } else if (valueObject != null) {
                throw new IllegalArgumentException("field [" + this.fieldReference + "] of type [" + valueObject.getClass().getName() + "] cannot be cast to [" + String.class.getName() + "]");
            }
            return value;
        }
    }

    public static final class Factory
    implements Processor.Factory {
        public RerouteProcessor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) throws Exception {
            List<DataStreamValueSource> namespace;
            List<DataStreamValueSource> dataset;
            List<DataStreamValueSource> type;
            try {
                type = ConfigurationUtils.readOptionalListOrString((String)RerouteProcessor.TYPE, (String)tag, config, (String)"type").stream().map(DataStreamValueSource::type).toList();
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)RerouteProcessor.TYPE, (String)tag, (String)"type", (String)e.getMessage());
            }
            try {
                dataset = ConfigurationUtils.readOptionalListOrString((String)RerouteProcessor.TYPE, (String)tag, config, (String)"dataset").stream().map(DataStreamValueSource::dataset).toList();
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)RerouteProcessor.TYPE, (String)tag, (String)"dataset", (String)e.getMessage());
            }
            try {
                namespace = ConfigurationUtils.readOptionalListOrString((String)RerouteProcessor.TYPE, (String)tag, config, (String)"namespace").stream().map(DataStreamValueSource::namespace).toList();
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)RerouteProcessor.TYPE, (String)tag, (String)"namespace", (String)e.getMessage());
            }
            String destination = ConfigurationUtils.readOptionalStringProperty((String)RerouteProcessor.TYPE, (String)tag, config, (String)"destination");
            if (!(destination == null || type.isEmpty() && dataset.isEmpty() && namespace.isEmpty())) {
                throw ConfigurationUtils.newConfigurationException((String)RerouteProcessor.TYPE, (String)tag, (String)"destination", (String)"can only be set if type, dataset, and namespace are not set");
            }
            return new RerouteProcessor(tag, description, type, dataset, namespace, destination);
        }
    }
}

