/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.NumberList;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Matrix2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.ConvexObjectiveFunction;
import org.ojalgo.optimisation.convex.DirectASS;
import org.ojalgo.optimisation.convex.IterativeASS;
import org.ojalgo.optimisation.convex.QPESolver;
import org.ojalgo.optimisation.convex.UnconstrainedSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.RowView;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;

public abstract class ConvexSolver
extends GenericSolver
implements UpdatableSolver {
    public static final ModelIntegration INTEGRATION = new ModelIntegration();
    private static final String Q_NOT_POSITIVE_SEMIDEFINITE = "Q not positive semidefinite!";
    private static final String Q_NOT_SYMMETRIC = "Q not symmetric!";
    private static final double SMALL_DIAGONAL_FACTOR = PrimitiveMath.RELATIVELY_SMALL + PrimitiveMath.MACHINE_EPSILON;
    private final Builder myMatrices;
    private boolean myPatchedQ = false;
    private final Primitive64Store mySolutionX;
    private final MatrixDecomposition.Solver<Double> mySolverGeneral;
    private final Cholesky<Double> mySolverQ;
    private boolean myZeroQ = false;

    @Override
    public UpdatableSolver.EntityMap getEntityMap() {
        return null;
    }

    public static void copy(ExpressionsBasedModel sourceModel, Builder destinationBuilder) {
        destinationBuilder.reset();
        List<Variable> freeVariables = sourceModel.getFreeVariables();
        Set<Structure1D.IntIndex> fixedVariables = sourceModel.getFixedVariables();
        int numbVars = freeVariables.size();
        List tmpEqExpr = sourceModel.constraints().filter(c -> c.isEqualityConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int numbEqExpr = tmpEqExpr.size();
        if (numbEqExpr > 0) {
            SparseStore<Double> mtrxAE = SparseStore.PRIMITIVE64.make(numbEqExpr, numbVars);
            PhysicalStore mtrxBE = (PhysicalStore)Primitive64Store.FACTORY.make(numbEqExpr, 1);
            for (int i = 0; i < numbEqExpr; ++i) {
                Expression tmpExpression = ((Expression)tmpEqExpr.get(i)).compensate(fixedVariables);
                for (Structure1D.IntIndex intIndex : tmpExpression.getLinearKeySet()) {
                    int tmpIndex = sourceModel.indexOfFreeVariable(intIndex.index);
                    mtrxAE.set((long)i, (long)tmpIndex, tmpExpression.getAdjustedLinearFactor(intIndex));
                }
                mtrxBE.set((long)i, 0L, tmpExpression.getAdjustedUpperLimit());
            }
            destinationBuilder.equalities(mtrxAE, mtrxBE);
        }
        Expression tmpObjExpr = sourceModel.objective().compensate(fixedVariables);
        PhysicalStore mtrxQ = null;
        if (tmpObjExpr.isAnyQuadraticFactorNonZero()) {
            mtrxQ = (PhysicalStore)Primitive64Store.FACTORY.make(numbVars, numbVars);
            PrimitiveFunction.Binary tmpBaseFunc = sourceModel.getOptimisationSense() == Optimisation.Sense.MAX ? PrimitiveMath.SUBTRACT : PrimitiveMath.ADD;
            for (Structure2D.IntRowColumn intRowColumn : tmpObjExpr.getQuadraticKeySet()) {
                int tmpRow = sourceModel.indexOfFreeVariable(intRowColumn.row);
                int tmpColumn = sourceModel.indexOfFreeVariable(intRowColumn.column);
                double adjustedQuadraticFactor = tmpObjExpr.getAdjustedQuadraticFactor(intRowColumn);
                UnaryFunction<double> tmpModifier = tmpBaseFunc.second(adjustedQuadraticFactor);
                mtrxQ.modifyOne(tmpRow, tmpColumn, tmpModifier);
                mtrxQ.modifyOne(tmpColumn, tmpRow, tmpModifier);
            }
        }
        PhysicalStore mtrxC = null;
        if (tmpObjExpr.isAnyLinearFactorNonZero()) {
            mtrxC = (PhysicalStore)Primitive64Store.FACTORY.make(numbVars, 1);
            if (sourceModel.getOptimisationSense() != Optimisation.Sense.MAX) {
                for (Structure1D.IntIndex tmpKey : tmpObjExpr.getLinearKeySet()) {
                    int n = sourceModel.indexOfFreeVariable(tmpKey.index);
                    mtrxC.set((long)n, 0L, -tmpObjExpr.getAdjustedLinearFactor(tmpKey));
                }
            } else {
                for (Structure1D.IntIndex tmpKey : tmpObjExpr.getLinearKeySet()) {
                    int n = sourceModel.indexOfFreeVariable(tmpKey.index);
                    mtrxC.set((long)n, 0L, tmpObjExpr.getAdjustedLinearFactor(tmpKey));
                }
            }
        }
        if (mtrxQ == null && mtrxC == null) {
            mtrxQ = Primitive64Store.FACTORY.makeEye(numbVars, numbVars);
        }
        destinationBuilder.objective(mtrxQ, mtrxC);
        List tmpUpExpr = sourceModel.constraints().filter(e -> e.isUpperConstraint() && !e.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int numbUpExpr = tmpUpExpr.size();
        List list = sourceModel.bounds().filter(c4 -> c4.isUpperConstraint()).collect(Collectors.toList());
        int numbUpVar = list.size();
        List tmpLoExpr = sourceModel.constraints().filter(c1 -> c1.isLowerConstraint() && !c1.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int numbLoExpr = tmpLoExpr.size();
        List tmpLoVar = sourceModel.bounds().filter(c3 -> c3.isLowerConstraint()).collect(Collectors.toList());
        int numbLoVar = tmpLoVar.size();
        if (numbUpExpr + numbUpVar + numbLoExpr + numbLoVar > 0) {
            Variable tmpVariable;
            int tmpIndex;
            Expression tmpExpression;
            SparseArray<Double> rowAI;
            int i;
            RowsSupplier<Double> mtrxAI = Primitive64Store.FACTORY.makeRowsSupplier(numbVars);
            PhysicalStore mtrxBI = (PhysicalStore)Primitive64Store.FACTORY.make(numbUpExpr + numbUpVar + numbLoExpr + numbLoVar, 1);
            if (numbUpExpr > 0) {
                for (i = 0; i < numbUpExpr; ++i) {
                    rowAI = mtrxAI.addRow();
                    tmpExpression = ((Expression)tmpUpExpr.get(i)).compensate(fixedVariables);
                    for (Structure1D.IntIndex tmpKey : tmpExpression.getLinearKeySet()) {
                        tmpIndex = sourceModel.indexOfFreeVariable(tmpKey.index);
                        rowAI.set((long)tmpIndex, tmpExpression.getAdjustedLinearFactor(tmpKey));
                    }
                    mtrxBI.set((long)i, 0L, tmpExpression.getAdjustedUpperLimit());
                }
            }
            if (numbUpVar > 0) {
                for (i = 0; i < numbUpVar; ++i) {
                    rowAI = mtrxAI.addRow();
                    tmpVariable = (Variable)list.get(i);
                    rowAI.set((long)sourceModel.indexOfFreeVariable(tmpVariable), tmpVariable.getAdjustmentFactor());
                    mtrxBI.set((long)(numbUpExpr + i), 0L, tmpVariable.getAdjustedUpperLimit());
                }
            }
            if (numbLoExpr > 0) {
                for (i = 0; i < numbLoExpr; ++i) {
                    rowAI = mtrxAI.addRow();
                    tmpExpression = ((Expression)tmpLoExpr.get(i)).compensate(fixedVariables);
                    for (Structure1D.IntIndex tmpKey : tmpExpression.getLinearKeySet()) {
                        tmpIndex = sourceModel.indexOfFreeVariable(tmpKey.index);
                        rowAI.set((long)tmpIndex, -tmpExpression.getAdjustedLinearFactor(tmpKey));
                    }
                    mtrxBI.set((long)(numbUpExpr + numbUpVar + i), 0L, -tmpExpression.getAdjustedLowerLimit());
                }
            }
            if (numbLoVar > 0) {
                for (i = 0; i < numbLoVar; ++i) {
                    rowAI = mtrxAI.addRow();
                    tmpVariable = (Variable)tmpLoVar.get(i);
                    rowAI.set((long)sourceModel.indexOfFreeVariable(tmpVariable), -tmpVariable.getAdjustmentFactor());
                    mtrxBI.set((long)(numbUpExpr + numbUpVar + numbLoExpr + i), 0L, -tmpVariable.getAdjustedLowerLimit());
                }
            }
            destinationBuilder.inequalities(mtrxAI, (Access1D)mtrxBI);
        }
    }

    public static void copyExperimental(ExpressionsBasedModel sourceModel, Builder destinationBuilder) {
        destinationBuilder.reset();
        List<Variable> freeVariables = sourceModel.getFreeVariables();
        Set<Structure1D.IntIndex> fixedVariables = sourceModel.getFixedVariables();
        int numbVars = freeVariables.size();
        Expression tmpObjExpr = sourceModel.objective().compensate(fixedVariables);
        boolean maximisation = sourceModel.getOptimisationSense() == Optimisation.Sense.MAX;
        PhysicalStore mtrxQ = null;
        if (tmpObjExpr.isAnyQuadraticFactorNonZero()) {
            mtrxQ = (PhysicalStore)Primitive64Store.FACTORY.make(numbVars, numbVars);
            for (Structure2D.IntRowColumn intRowColumn : tmpObjExpr.getQuadraticKeySet()) {
                int tmpRow = sourceModel.indexOfFreeVariable(intRowColumn.row);
                int tmpColumn = sourceModel.indexOfFreeVariable(intRowColumn.column);
                if (tmpRow < 0 || tmpColumn < 0) continue;
                double adjustedQuadraticFactor = tmpObjExpr.getAdjustedQuadraticFactor(intRowColumn);
                double addition = maximisation ? -adjustedQuadraticFactor : adjustedQuadraticFactor;
                mtrxQ.add((long)tmpRow, (long)tmpColumn, addition);
                mtrxQ.add((long)tmpColumn, (long)tmpRow, addition);
            }
        }
        PhysicalStore mtrxC = null;
        if (tmpObjExpr.isAnyLinearFactorNonZero()) {
            mtrxC = (PhysicalStore)Primitive64Store.FACTORY.make(numbVars, 1);
            for (Structure1D.IntIndex tmpKey : tmpObjExpr.getLinearKeySet()) {
                int tmpIndex = sourceModel.indexOfFreeVariable(tmpKey.index);
                if (tmpIndex < 0) continue;
                double adjustedLinearFactor = tmpObjExpr.getAdjustedLinearFactor(tmpKey);
                double value = maximisation ? adjustedLinearFactor : -adjustedLinearFactor;
                mtrxC.set((long)tmpIndex, value);
            }
        }
        if (mtrxQ == null && mtrxC == null) {
            mtrxQ = Primitive64Store.FACTORY.makeEye(numbVars, numbVars);
        }
        destinationBuilder.objective(mtrxQ, mtrxC);
        RowsSupplier<Double> rowsSupplier = Primitive64Store.FACTORY.makeRowsSupplier(numbVars);
        Access1D rhs = NumberList.factory(Primitive64Array.FACTORY).make();
        AtomicInteger rowIndex = new AtomicInteger(0);
        sourceModel.variables().forEach(arg_0 -> ConvexSolver.lambda$copyExperimental$5(rowsSupplier, rowIndex, sourceModel, (NumberList)rhs, arg_0));
        sourceModel.constraints().forEach(arg_0 -> ConvexSolver.lambda$copyExperimental$6(rowsSupplier, rowIndex, sourceModel, (NumberList)rhs, arg_0));
        destinationBuilder.inequalities(rowsSupplier, rhs);
    }

    @Deprecated
    public static Builder getBuilder() {
        return ConvexSolver.newBuilder();
    }

    @Deprecated
    public static Builder getBuilder(MatrixStore<Double> Q, MatrixStore<Double> C) {
        return ConvexSolver.newBuilder().objective(Q, C);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder builder(MatrixStore<Double>[] matrices) {
        return new Builder(matrices);
    }

    static ConvexSolver of(MatrixStore<Double>[] matrices) {
        return (ConvexSolver)ConvexSolver.builder(matrices).build();
    }

    static ConvexObjectiveFunction toObjectiveFunction(MatrixStore<Double> mtrxQ, MatrixStore<Double> mtrxC) {
        if (mtrxQ == null && mtrxC == null) {
            ProgrammingError.throwWithMessage("Both parameters can't be null!", new Object[0]);
        }
        PhysicalStore tmpQ = null;
        PhysicalStore tmpC = null;
        tmpQ = mtrxQ == null ? (PhysicalStore)Primitive64Store.FACTORY.make(mtrxC.count(), mtrxC.count()) : (mtrxQ instanceof PhysicalStore ? (PhysicalStore)mtrxQ : mtrxQ.copy());
        tmpC = mtrxC == null ? (PhysicalStore)Primitive64Store.FACTORY.make(tmpQ.countRows(), 1L) : (mtrxC instanceof PhysicalStore ? (PhysicalStore)mtrxC : mtrxC.copy());
        return new ConvexObjectiveFunction(tmpQ, tmpC);
    }

    private ConvexSolver(Optimisation.Options solverOptions) {
        this(null, solverOptions);
    }

    protected ConvexSolver(Builder matrices, Optimisation.Options solverOptions) {
        super(solverOptions);
        this.myMatrices = matrices;
        this.mySolutionX = (Primitive64Store)Primitive64Store.FACTORY.make((long)this.countVariables(), 1L);
        this.mySolverQ = (Cholesky)Cholesky.PRIMITIVE.make(this.getMatrixQ());
        this.mySolverGeneral = (MatrixDecomposition.Solver)LU.PRIMITIVE.make(this.getMatrixQ());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myMatrices.reset();
    }

    @Override
    public final Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (this.initialise(kickStarter)) {
            this.resetIterationsCount();
            if (this.isIteratingPossible()) {
                do {
                    this.performIteration();
                } while (this.isIterationAllowed() && this.needsAnotherIteration());
            }
        }
        return this.buildResult();
    }

    protected boolean isIteratingPossible() {
        return true;
    }

    public String toString() {
        return this.myMatrices.toString();
    }

    protected boolean computeGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        return this.mySolverGeneral.compute(matrix);
    }

    protected int countEqualityConstraints() {
        return this.myMatrices.countEqualityConstraints();
    }

    protected int countInequalityConstraints() {
        return this.myMatrices.countInequalityConstraints();
    }

    protected int countVariables() {
        return this.myMatrices.countVariables();
    }

    @Override
    protected double evaluateFunction(Access1D<?> solution) {
        PhysicalStore<Double> tmpX = this.getSolutionX();
        return tmpX.transpose().multiply(this.getMatrixQ().multiply((Double)((Object)tmpX))).multiply(0.5).subtract(tmpX.transpose().multiply(this.getMatrixC())).doubleValue(0L);
    }

    protected MatrixStore<Double> extractSolution() {
        return this.getSolutionX().copy();
    }

    protected abstract Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationKKT();

    protected abstract Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationRHS();

    protected MatrixStore<Double> getMatrixAE() {
        return this.myMatrices.getAE();
    }

    protected MatrixStore<Double> getMatrixAI() {
        return this.myMatrices.getAI();
    }

    protected SparseArray<Double> getMatrixAI(int row) {
        return this.myMatrices.getAI(row);
    }

    protected RowsSupplier<Double> getMatrixAI(int[] rows) {
        return this.myMatrices.getAI(rows);
    }

    protected MatrixStore<Double> getMatrixBE() {
        return this.myMatrices.getBE();
    }

    protected MatrixStore<Double> getMatrixBI() {
        return this.myMatrices.getBI();
    }

    protected double getMatrixBI(int row) {
        return this.myMatrices.getBI().doubleValue(row);
    }

    protected MatrixStore<Double> getMatrixBI(int[] selector) {
        return (MatrixStore)this.myMatrices.getBI().row(selector);
    }

    protected MatrixStore<Double> getMatrixC() {
        return this.myMatrices.getC();
    }

    protected PhysicalStore<Double> getMatrixQ() {
        return this.myMatrices.getQ();
    }

    protected int getRankGeneral() {
        if (this.mySolverGeneral instanceof MatrixDecomposition.RankRevealing) {
            return ((MatrixDecomposition.RankRevealing)((Object)this.mySolverGeneral)).getRank();
        }
        if (this.mySolverGeneral.isSolvable()) {
            return (int)this.mySolverGeneral.reconstruct().countColumns();
        }
        return 0;
    }

    protected MatrixStore<Double> getSolutionGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        return this.mySolverGeneral.getSolution(rhs);
    }

    protected MatrixStore<Double> getSolutionGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return this.mySolverGeneral.getSolution(rhs, preallocated);
    }

    protected MatrixStore<Double> getSolutionQ(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        return this.mySolverQ.getSolution(rhs);
    }

    protected MatrixStore<Double> getSolutionQ(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return this.mySolverQ.getSolution(rhs, preallocated);
    }

    protected PhysicalStore<Double> getSolutionX() {
        return this.mySolutionX;
    }

    protected boolean hasEqualityConstraints() {
        return this.myMatrices.hasEqualityConstraints();
    }

    protected boolean hasInequalityConstraints() {
        return this.myMatrices.hasInequalityConstraints();
    }

    protected boolean hasObjective() {
        return this.myMatrices.hasObjective();
    }

    protected boolean initialise(Optimisation.Result kickStarter) {
        PhysicalStore<Double> matrixQ = this.getMatrixQ();
        this.setState(Optimisation.State.VALID);
        boolean symmetric = true;
        if (this.options.validate && !matrixQ.isHermitian()) {
            symmetric = false;
            this.setState(Optimisation.State.INVALID);
            if (!this.isLogDebug()) {
                throw new IllegalArgumentException(Q_NOT_SYMMETRIC);
            }
            this.log(Q_NOT_SYMMETRIC, matrixQ);
        }
        this.myPatchedQ = false;
        this.myZeroQ = false;
        if (!this.mySolverQ.compute(matrixQ)) {
            double largest = (Double)matrixQ.aggregateAll(Aggregator.LARGEST);
            if (largest > SMALL_DIAGONAL_FACTOR) {
                matrixQ.modifyDiagonal(PrimitiveMath.ADD.by(SMALL_DIAGONAL_FACTOR * largest));
                this.mySolverQ.compute(matrixQ);
                this.myPatchedQ = true;
            } else {
                this.myZeroQ = true;
            }
        }
        boolean semidefinite = true;
        if (this.options.validate && !this.mySolverQ.isSPD()) {
            Eigenvalue<Double> decompEvD = Eigenvalue.PRIMITIVE.make(matrixQ, true);
            decompEvD.computeValuesOnly(matrixQ);
            Array1D<ComplexNumber> eigenvalues = decompEvD.getEigenvalues();
            decompEvD.reset();
            for (ComplexNumber eigval : eigenvalues) {
                if (!(eigval.doubleValue() < PrimitiveMath.ZERO && !eigval.isSmall(PrimitiveMath.TEN)) && eigval.isReal()) continue;
                semidefinite = false;
                this.setState(Optimisation.State.INVALID);
                if (!this.isLogDebug()) {
                    throw new IllegalArgumentException(Q_NOT_POSITIVE_SEMIDEFINITE);
                }
                this.log(Q_NOT_POSITIVE_SEMIDEFINITE, new Object[0]);
                this.log("The eigenvalues are: {}", eigenvalues);
            }
        }
        return symmetric && semidefinite;
    }

    protected boolean isSolvableGeneral() {
        return this.mySolverGeneral.isSolvable();
    }

    protected boolean isSolvableQ() {
        return this.mySolverQ.isSolvable();
    }

    protected abstract boolean needsAnotherIteration();

    protected abstract void performIteration();

    protected boolean solveFullKKT(PhysicalStore<Double> preallocated) {
        if (this.computeGeneral(this.getIterationKKT())) {
            this.getSolutionGeneral(this.getIterationRHS(), preallocated);
            return true;
        }
        if (this.isLogDebug()) {
            this.options.logger_appender.println("KKT system unsolvable!");
        }
        return false;
    }

    protected Optimisation.Result solveLP() {
        Optimisation.Result resultLP = LinearSolver.solve(this.myMatrices, this.options, !this.myZeroQ);
        if (!this.myZeroQ && resultLP.getState().isFeasible()) {
            return resultLP.withState(Optimisation.State.FEASIBLE);
        }
        return resultLP;
    }

    boolean isPatchedQ() {
        return this.myPatchedQ;
    }

    boolean isZeroQ() {
        return this.myZeroQ;
    }

    private static /* synthetic */ void lambda$copyExperimental$6(RowsSupplier body, AtomicInteger rowIndex, ExpressionsBasedModel sourceModel, NumberList rhs, Expression constraint) {
        int j;
        int i;
        SparseArray bodyRow;
        if (constraint.isLowerLimitSet()) {
            bodyRow = body.addRow();
            i = rowIndex.incrementAndGet();
            for (Structure1D.IntIndex tmpKey : constraint.getLinearKeySet()) {
                j = sourceModel.indexOfFreeVariable(tmpKey.index);
                bodyRow.set((long)j, -constraint.getAdjustedLinearFactor(tmpKey));
            }
            rhs.add(-constraint.getAdjustedLowerLimit());
        }
        if (constraint.isUpperLimitSet()) {
            bodyRow = body.addRow();
            i = rowIndex.incrementAndGet();
            for (Structure1D.IntIndex tmpKey : constraint.getLinearKeySet()) {
                j = sourceModel.indexOfFreeVariable(tmpKey.index);
                bodyRow.set((long)j, constraint.getAdjustedLinearFactor(tmpKey));
            }
            rhs.add(constraint.getAdjustedUpperLimit());
        }
    }

    private static /* synthetic */ void lambda$copyExperimental$5(RowsSupplier body, AtomicInteger rowIndex, ExpressionsBasedModel sourceModel, NumberList rhs, Variable variable) {
        int i;
        SparseArray bodyRow;
        if (variable.isLowerLimitSet()) {
            bodyRow = body.addRow();
            i = rowIndex.incrementAndGet();
            int j = sourceModel.indexOfFreeVariable(variable);
            bodyRow.set((long)j, -variable.getAdjustmentFactor());
            rhs.add(-variable.getAdjustedLowerLimit());
        }
        if (variable.isUpperLimitSet()) {
            bodyRow = body.addRow();
            i = rowIndex.incrementAndGet();
            int tmpIndex = sourceModel.indexOfFreeVariable(variable);
            bodyRow.set((long)tmpIndex, variable.getAdjustmentFactor());
            rhs.add(variable.getAdjustedUpperLimit());
        }
    }

    public static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<ConvexSolver> {
        @Override
        public ConvexSolver build(ExpressionsBasedModel model) {
            Builder builder = ConvexSolver.newBuilder();
            ConvexSolver.copy(model, builder);
            return (ConvexSolver)builder.build(model.options);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyVariableInteger() && model.isAnyObjectiveQuadratic() && !model.isAnyConstraintQuadratic();
        }

        @Override
        protected boolean isSolutionMapped() {
            return true;
        }
    }

    public static final class Builder
    extends GenericSolver.Builder<Builder, ConvexSolver> {
        private ConvexObjectiveFunction myObjective = null;

        @Deprecated
        public Builder() {
        }

        @Deprecated
        public Builder(MatrixStore<Double> C) {
            this.objective(C);
        }

        @Deprecated
        public Builder(MatrixStore<Double> Q, MatrixStore<Double> C) {
            this.objective(Q, C);
        }

        Builder(MatrixStore<Double>[] matrices) {
            if (matrices.length >= 2 && matrices[0] != null && matrices[1] != null) {
                this.equalities(matrices[0], matrices[1]);
            }
            if (matrices.length >= 4) {
                if (matrices[2] != null) {
                    this.objective(matrices[2], matrices[3]);
                } else if (matrices[3] != null) {
                    this.objective(matrices[3]);
                }
            }
            if (matrices.length >= 6 && matrices[4] != null && matrices[5] != null) {
                this.inequalities(matrices[4], matrices[5]);
            }
        }

        @Override
        public MatrixStore<Double> getAI() {
            return super.getAI();
        }

        @Override
        public SparseArray<Double> getAI(int row) {
            return super.getAI(row);
        }

        @Override
        public RowsSupplier<Double> getAI(int ... rows) {
            return super.getAI(rows);
        }

        @Override
        public MatrixStore<Double> getBI() {
            return super.getBI();
        }

        @Override
        public double getBI(int row) {
            return super.getBI(row);
        }

        public PhysicalStore<Double> getC() {
            return this.myObjective.linear();
        }

        public PhysicalStore<Double> getQ() {
            return this.myObjective.quadratic();
        }

        @Override
        public RowView<Double> getRowsAI() {
            return super.getRowsAI();
        }

        @Override
        public Builder inequalities(Access2D<Double> mtrxAI, Access1D<Double> mtrxBI) {
            return (Builder)super.inequalities(mtrxAI, mtrxBI);
        }

        @Deprecated
        public Builder objective(MatrixStore<Double> mtrxC) {
            this.myObjective = ConvexSolver.toObjectiveFunction(null, mtrxC);
            this.setObjective(this.myObjective);
            return this;
        }

        public Builder objective(MatrixStore<Double> mtrxQ, MatrixStore<Double> mtrxC) {
            this.myObjective = ConvexSolver.toObjectiveFunction(mtrxQ, mtrxC);
            this.setObjective(this.myObjective);
            return this;
        }

        @Override
        public void reset() {
            super.reset();
            this.myObjective = null;
        }

        public LinearSolver.GeneralBuilder toFeasibilityChecker() {
            MatrixStore<Double> mtrxAE = this.getAE();
            MatrixStore<Double> mtrxBE = this.getBE();
            MatrixStore<Double> mtrxAI = this.getAI();
            MatrixStore<Double> mtrxBI = this.getBI();
            LinearSolver.GeneralBuilder retVal = LinearSolver.newGeneralBuilder();
            int nbEqus = this.countEqualityConstraints();
            int nbIneq = this.countInequalityConstraints();
            int nbVars = this.countVariables();
            MatrixStore<Double> rhs = Primitive64Store.FACTORY.makeZero(nbVars, 1L);
            if (nbEqus > 0) {
                Matrix2D transpAE = mtrxAE.transpose();
                if (nbIneq > 0) {
                    retVal.objective(mtrxBE.below((Access2D<Double>)mtrxBE.negate()).below((Access2D<Double>)mtrxBI));
                    retVal.equalities(transpAE.right(transpAE.negate()).right(mtrxAI.transpose()), rhs);
                } else {
                    retVal.objective(mtrxBE.below((Access2D<Double>)mtrxBE.negate()));
                    retVal.equalities(transpAE.right(transpAE.negate()), rhs);
                }
            } else if (nbIneq > 0) {
                retVal.objective(mtrxBI);
                retVal.equalities(mtrxAI.transpose(), rhs);
            } else {
                throw new IllegalStateException("The problem is unconstrained!");
            }
            return retVal;
        }

        public LinearSolver.GeneralBuilder toLinearApproximation() {
            return this.toLinearApproximation(Primitive64Array.make(this.countVariables()));
        }

        public LinearSolver.GeneralBuilder toLinearApproximation(Access1D<Double> point) {
            MatrixStore<Double> mtrxC = this.getObjective().toFirstOrderApproximation(point).getLinearFactors();
            MatrixStore<Double> mtrxAE = this.getAE();
            MatrixStore<Double> mtrxBE = this.getBE();
            MatrixStore<Double> mtrxAI = this.getAI();
            MatrixStore<Double> mtrxBI = this.getBI();
            LinearSolver.GeneralBuilder retVal = LinearSolver.newGeneralBuilder();
            retVal.objective(mtrxC.below((Access2D<Double>)mtrxC.negate()));
            if (mtrxAE != null && mtrxBE != null) {
                retVal.equalities(mtrxAE.right((Access2D<Double>)mtrxAE.negate()), mtrxBE);
            }
            if (mtrxAI != null && mtrxBI != null) {
                retVal.inequalities(mtrxAI.right((Access2D<Double>)mtrxAI.negate()), mtrxBI);
            }
            return retVal;
        }

        @Override
        protected void append(StringBuilder builder) {
            super.append(builder);
            GenericSolver.Builder.append(builder, "Q", this.getQ());
        }

        @Override
        protected ConvexSolver doBuild(Optimisation.Options options) {
            if (this.hasInequalityConstraints()) {
                if (options.sparse == null || options.sparse.booleanValue()) {
                    return new IterativeASS(this, options);
                }
                return new DirectASS(this, options);
            }
            if (this.hasEqualityConstraints()) {
                return new QPESolver(this, options);
            }
            return new UnconstrainedSolver(this, options);
        }
    }
}

