/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import java.util.function.DoubleUnaryOperator;
import org.ojalgo.array.operation.ArrayOperation;

public final class ModifyAll
implements ArrayOperation {
    public static int THRESHOLD = 64;

    public static void modifyAll(double[][] target, DoubleUnaryOperator function) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = function.applyAsDouble(target[i][j]);
            }
        }
    }

    public static void modifyColumn(double[][] target, int row, int col, DoubleUnaryOperator function) {
        int limit = target.length;
        for (int i = row; i < limit; ++i) {
            target[i][col] = function.applyAsDouble(target[i][col]);
        }
    }

    public static void modifyDiagonal(double[][] target, int row, int col, DoubleUnaryOperator function) {
        int tmpLength = target.length;
        int ij = 0;
        while (row + ij < tmpLength && col + ij < target[row + ij].length) {
            target[row + ij][col + ij] = function.applyAsDouble(target[row + ij][col + ij]);
            ++ij;
        }
    }

    public static void modifyRow(double[][] target, int row, int col, DoubleUnaryOperator function) {
        double[] targetRow = target[row];
        int limit = targetRow.length;
        for (int j = col; j < limit; ++j) {
            targetRow[j] = function.applyAsDouble(targetRow[j]);
        }
    }
}

