/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.fleet.FleetTemplateRegistry;
import org.elasticsearch.xpack.fleet.action.DeleteSecretAction;
import org.elasticsearch.xpack.fleet.action.GetGlobalCheckpointsAction;
import org.elasticsearch.xpack.fleet.action.GetGlobalCheckpointsShardAction;
import org.elasticsearch.xpack.fleet.action.GetSecretAction;
import org.elasticsearch.xpack.fleet.action.PostSecretAction;
import org.elasticsearch.xpack.fleet.action.TransportDeleteSecretAction;
import org.elasticsearch.xpack.fleet.action.TransportGetSecretAction;
import org.elasticsearch.xpack.fleet.action.TransportPostSecretAction;
import org.elasticsearch.xpack.fleet.rest.RestDeleteSecretsAction;
import org.elasticsearch.xpack.fleet.rest.RestFleetMultiSearchAction;
import org.elasticsearch.xpack.fleet.rest.RestFleetSearchAction;
import org.elasticsearch.xpack.fleet.rest.RestGetGlobalCheckpointsAction;
import org.elasticsearch.xpack.fleet.rest.RestGetSecretsAction;
import org.elasticsearch.xpack.fleet.rest.RestPostSecretsAction;

public class Fleet
extends Plugin
implements SystemIndexPlugin {
    public static final String FLEET_SECRETS_INDEX_NAME = ".fleet-secrets";
    private static final int CURRENT_INDEX_VERSION = 7;
    private static final String VERSION_KEY = "version";
    private static final String MAPPING_VERSION_VARIABLE = "fleet.version";
    private static final List<String> ALLOWED_PRODUCTS = List.of("kibana", "fleet");
    private static final int FLEET_ACTIONS_MAPPINGS_VERSION = 2;
    private static final int FLEET_AGENTS_MAPPINGS_VERSION = 4;
    private static final int FLEET_ENROLLMENT_API_KEYS_MAPPINGS_VERSION = 3;
    private static final int FLEET_SECRETS_MAPPINGS_VERSION = 1;
    private static final int FLEET_POLICIES_MAPPINGS_VERSION = 2;
    private static final int FLEET_POLICIES_LEADER_MAPPINGS_VERSION = 1;
    private static final int FLEET_SERVERS_MAPPINGS_VERSION = 1;
    private static final int FLEET_ARTIFACTS_MAPPINGS_VERSION = 1;
    private static final int FLEET_ACTIONS_RESULTS_MAPPINGS_VERSION = 1;

    public Collection<?> createComponents(Plugin.PluginServices services) {
        FleetTemplateRegistry registry = new FleetTemplateRegistry(services.environment().settings(), services.clusterService(), services.threadPool(), services.client(), services.xContentRegistry());
        registry.initialize();
        return List.of();
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(Fleet.fleetActionsSystemIndexDescriptor(), Fleet.fleetAgentsSystemIndexDescriptor(), Fleet.fleetEnrollmentApiKeysSystemIndexDescriptor(), Fleet.fleetSecretsSystemIndexDescriptor(), Fleet.fleetPoliciesSystemIndexDescriptor(), Fleet.fleetPoliciesLeaderSystemIndexDescriptor(), Fleet.fleetServersSystemIndexDescriptors(), Fleet.fleetArtifactsSystemIndexDescriptors());
    }

    public Collection<SystemDataStreamDescriptor> getSystemDataStreamDescriptors() {
        return List.of(Fleet.fleetActionsResultsDescriptor());
    }

    public String getFeatureName() {
        return "fleet";
    }

    public String getFeatureDescription() {
        return "Manages configuration for Fleet";
    }

    private static SystemIndexDescriptor fleetActionsSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(Fleet.loadTemplateSource("/fleet-actions.json", 2), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings(request.mappings()).setSettings(request.settings()).setPrimaryIndex(".fleet-actions-7").setIndexPattern(".fleet-actions~(-results*)").setAliasName(".fleet-actions").setDescription("Fleet agents").build();
    }

    private static SystemIndexDescriptor fleetAgentsSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(Fleet.loadTemplateSource("/fleet-agents.json", 4), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings(request.mappings()).setSettings(request.settings()).setPrimaryIndex(".fleet-agents-7").setIndexPattern(".fleet-agents*").setAliasName(".fleet-agents").setDescription("Configuration of fleet servers").build();
    }

    private static SystemIndexDescriptor fleetEnrollmentApiKeysSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(Fleet.loadTemplateSource("/fleet-enrollment-api-keys.json", 3), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings(request.mappings()).setSettings(request.settings()).setPrimaryIndex(".fleet-enrollment-api-keys-7").setIndexPattern(".fleet-enrollment-api-keys*").setAliasName(".fleet-enrollment-api-keys").setDescription("Fleet API Keys for enrollment").build();
    }

    private static SystemIndexDescriptor fleetSecretsSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(Fleet.loadTemplateSource("/fleet-secrets.json", 1), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings(request.mappings()).setSettings(request.settings()).setPrimaryIndex(".fleet-secrets-7").setIndexPattern(".fleet-secrets*").setAliasName(FLEET_SECRETS_INDEX_NAME).setDescription("Secret values managed by Fleet").build();
    }

    private static SystemIndexDescriptor fleetPoliciesSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(Fleet.loadTemplateSource("/fleet-policies.json", 2), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings(request.mappings()).setSettings(request.settings()).setPrimaryIndex(".fleet-policies-7").setIndexPattern(".fleet-policies-[0-9]+*").setAliasName(".fleet-policies").setDescription("Fleet Policies").build();
    }

    private static SystemIndexDescriptor fleetPoliciesLeaderSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(Fleet.loadTemplateSource("/fleet-policies-leader.json", 1), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings(request.mappings()).setSettings(request.settings()).setPrimaryIndex(".fleet-policies-leader-7").setIndexPattern(".fleet-policies-leader*").setAliasName(".fleet-policies-leader").setDescription("Fleet Policies leader").build();
    }

    private static SystemIndexDescriptor fleetServersSystemIndexDescriptors() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(Fleet.loadTemplateSource("/fleet-servers.json", 1), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings(request.mappings()).setSettings(request.settings()).setPrimaryIndex(".fleet-servers-7").setIndexPattern(".fleet-servers*").setAliasName(".fleet-servers").setDescription("Fleet servers").build();
    }

    private static SystemIndexDescriptor fleetArtifactsSystemIndexDescriptors() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(Fleet.loadTemplateSource("/fleet-artifacts.json", 1), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings(request.mappings()).setSettings(request.settings()).setPrimaryIndex(".fleet-artifacts-7").setIndexPattern(".fleet-artifacts*").setAliasName(".fleet-artifacts").setDescription("Fleet artifacts").build();
    }

    private static SystemDataStreamDescriptor fleetActionsResultsDescriptor() {
        SystemDataStreamDescriptor systemDataStreamDescriptor;
        block8: {
            String source = Fleet.loadTemplateSource("/fleet-actions-results.json", 1);
            XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, source);
            try {
                ComposableIndexTemplate composableIndexTemplate = ComposableIndexTemplate.parse((XContentParser)parser);
                systemDataStreamDescriptor = new SystemDataStreamDescriptor(".fleet-actions-results", "Result history of fleet actions", SystemDataStreamDescriptor.Type.EXTERNAL, composableIndexTemplate, Map.of(), ALLOWED_PRODUCTS, "fleet", ExecutorNames.DEFAULT_SYSTEM_DATA_STREAM_THREAD_POOLS);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            parser.close();
        }
        return systemDataStreamDescriptor;
    }

    public void cleanUpFeature(ClusterService clusterService, Client client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> listener) {
        block5: {
            Collection<SystemDataStreamDescriptor> dataStreamDescriptors = this.getSystemDataStreamDescriptors();
            if (!dataStreamDescriptors.isEmpty()) {
                try {
                    DeleteDataStreamAction.Request request = new DeleteDataStreamAction.Request(TimeValue.THIRTY_SECONDS, (String[])dataStreamDescriptors.stream().map(SystemDataStreamDescriptor::getDataStreamName).toArray(String[]::new));
                    request.indicesOptions(IndicesOptions.builder((IndicesOptions)request.indicesOptions()).concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).build());
                    client.execute((ActionType)DeleteDataStreamAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> super.cleanUpFeature(clusterService, client, listener), e -> {
                        Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
                        if (unwrapped instanceof ResourceNotFoundException) {
                            super.cleanUpFeature(clusterService, client, listener);
                        } else {
                            listener.onFailure(e);
                        }
                    }));
                }
                catch (Exception e2) {
                    Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e2);
                    if (unwrapped instanceof ResourceNotFoundException) {
                        super.cleanUpFeature(clusterService, client, listener);
                        break block5;
                    }
                    listener.onFailure(e2);
                }
            } else {
                super.cleanUpFeature(clusterService, client, listener);
            }
        }
    }

    private static String loadTemplateSource(String resource, int mappingsVersion) {
        return TemplateUtils.loadTemplate((String)resource, (String)Version.CURRENT.toString(), (String)MAPPING_VERSION_VARIABLE, Map.of("fleet.managed.index.version", Integer.toString(mappingsVersion)));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)GetGlobalCheckpointsAction.INSTANCE, GetGlobalCheckpointsAction.LocalAction.class), new ActionPlugin.ActionHandler((ActionType)GetGlobalCheckpointsShardAction.INSTANCE, GetGlobalCheckpointsShardAction.TransportAction.class), new ActionPlugin.ActionHandler((ActionType)GetSecretAction.INSTANCE, TransportGetSecretAction.class), new ActionPlugin.ActionHandler((ActionType)PostSecretAction.INSTANCE, TransportPostSecretAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteSecretAction.INSTANCE, TransportDeleteSecretAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return List.of(new RestGetGlobalCheckpointsAction(), new RestFleetSearchAction(restController.getSearchUsageHolder(), clusterSupportsFeature), new RestFleetMultiSearchAction(settings, restController.getSearchUsageHolder(), clusterSupportsFeature), new RestGetSecretsAction(), new RestPostSecretsAction(), new RestDeleteSecretsAction());
    }
}

