/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.normalize;

import java.util.function.DoubleUnaryOperator;

class NormalizePipelineMethods {
    private NormalizePipelineMethods() {
    }

    static abstract class SinglePassSimpleStatisticsMethod
    implements DoubleUnaryOperator {
        protected final double max;
        protected final double min;
        protected final double sum;
        protected final double mean;
        protected final int count;

        SinglePassSimpleStatisticsMethod(double[] values) {
            int count = 0;
            double sum = 0.0;
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (double value : values) {
                if (Double.isNaN(value)) continue;
                ++count;
                min = Math.min(value, min);
                max = Math.max(value, max);
                sum += value;
            }
            this.count = count;
            this.min = min;
            this.max = max;
            this.sum = sum;
            this.mean = this.count == 0 ? Double.NaN : this.sum / (double)this.count;
        }
    }

    static class Softmax
    implements DoubleUnaryOperator {
        static final String NAME = "softmax";
        private final double sumExp;

        Softmax(double[] values) {
            double _sumExp = 0.0;
            double[] dArray = values;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double value = dArray[i];
                if (value.isNaN()) continue;
                _sumExp += Math.exp(value);
            }
            this.sumExp = _sumExp;
        }

        @Override
        public double applyAsDouble(double value) {
            return Math.exp(value) / this.sumExp;
        }
    }

    static class ZScore
    extends SinglePassSimpleStatisticsMethod {
        static final String NAME = "z-score";
        private final double stdev;

        ZScore(double[] values) {
            super(values);
            double variance = 0.0;
            double[] dArray = values;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double value = dArray[i];
                if (value.isNaN()) continue;
                variance += Math.pow(value - this.mean, 2.0);
            }
            this.stdev = Math.sqrt(variance / (double)this.count);
        }

        @Override
        public double applyAsDouble(double value) {
            return (value - this.mean) / this.stdev;
        }
    }

    static class Percent
    extends SinglePassSimpleStatisticsMethod {
        static final String NAME = "percent_of_sum";

        Percent(double[] values) {
            super(values);
        }

        @Override
        public double applyAsDouble(double value) {
            return value / this.sum;
        }
    }

    static class Mean
    extends SinglePassSimpleStatisticsMethod {
        static final String NAME = "mean";

        Mean(double[] values) {
            super(values);
        }

        @Override
        public double applyAsDouble(double value) {
            return (value - this.mean) / (this.max - this.min);
        }
    }

    static class RescaleZeroToOneHundred
    extends SinglePassSimpleStatisticsMethod {
        static final String NAME = "rescale_0_100";

        RescaleZeroToOneHundred(double[] values) {
            super(values);
        }

        @Override
        public double applyAsDouble(double value) {
            return 100.0 * (value - this.min) / (this.max - this.min);
        }
    }

    static class RescaleZeroToOne
    extends SinglePassSimpleStatisticsMethod {
        static final String NAME = "rescale_0_1";

        RescaleZeroToOne(double[] values) {
            super(values);
        }

        @Override
        public double applyAsDouble(double value) {
            return (value - this.min) / (this.max - this.min);
        }
    }
}

