/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.attachment;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.langdetect.tika.LanguageIdentifier;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.attachment.TikaImpl;

public final class AttachmentProcessor
extends AbstractProcessor {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(AttachmentProcessor.class);
    private static final int NUMBER_OF_CHARS_INDEXED = 100000;
    public static final String TYPE = "attachment";
    private final String field;
    private final String targetField;
    private final Set<Property> properties;
    private final int indexedChars;
    private final boolean ignoreMissing;
    private final boolean removeBinary;
    private final String indexedCharsField;
    private final String resourceName;

    AttachmentProcessor(String tag, String description, String field, String targetField, Set<Property> properties, int indexedChars, boolean ignoreMissing, String indexedCharsField, String resourceName, boolean removeBinary) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.properties = properties;
        this.indexedChars = indexedChars;
        this.ignoreMissing = ignoreMissing;
        this.indexedCharsField = indexedCharsField;
        this.resourceName = resourceName;
        this.removeBinary = removeBinary;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    boolean isRemoveBinary() {
        return this.removeBinary;
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        HashMap<String, Object> additionalFields = new HashMap<String, Object>();
        byte[] input = ingestDocument.getFieldValueAsBytes(this.field, this.ignoreMissing);
        String resourceNameInput = null;
        if (this.resourceName != null) {
            resourceNameInput = (String)ingestDocument.getFieldValue(this.resourceName, String.class, true);
        }
        if (input == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (input == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot parse.");
        }
        Integer indexedCharsValue = this.indexedChars;
        if (this.indexedCharsField != null && (indexedCharsValue = (Integer)ingestDocument.getFieldValue(this.indexedCharsField, Integer.class, true)) == null) {
            indexedCharsValue = this.indexedChars;
        }
        Metadata metadata = new Metadata();
        if (resourceNameInput != null) {
            metadata.set("resourceName", resourceNameInput);
        }
        String parsedContent = "";
        try {
            parsedContent = TikaImpl.parse(input, metadata, indexedCharsValue);
        }
        catch (ZeroByteFileException zeroByteFileException) {
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Error parsing document in field [{}]", (Throwable)e, new Object[]{this.field});
        }
        if (this.properties.contains((Object)Property.CONTENT) && Strings.hasLength((String)parsedContent)) {
            additionalFields.put(Property.CONTENT.toLowerCase(), parsedContent.trim());
        }
        if (this.properties.contains((Object)Property.LANGUAGE) && Strings.hasLength((String)parsedContent)) {
            LanguageIdentifier identifier = new LanguageIdentifier(parsedContent);
            String language = identifier.getLanguage();
            additionalFields.put(Property.LANGUAGE.toLowerCase(), language);
        }
        this.addAdditionalField(additionalFields, Property.DATE, metadata.get(TikaCoreProperties.CREATED));
        this.addAdditionalField(additionalFields, Property.TITLE, metadata.get(TikaCoreProperties.TITLE));
        this.addAdditionalField(additionalFields, Property.AUTHOR, metadata.get("Author"));
        this.addAdditionalField(additionalFields, Property.KEYWORDS, metadata.get("Keywords"));
        this.addAdditionalField(additionalFields, Property.KEYWORDS, metadata.get(TikaCoreProperties.SUBJECT));
        this.addAdditionalField(additionalFields, Property.CONTENT_TYPE, metadata.get("Content-Type"));
        if (this.properties.contains((Object)Property.CONTENT_LENGTH)) {
            String contentLength = metadata.get("Content-Length");
            long length = Strings.hasLength((String)contentLength) ? Long.parseLong(contentLength) : (long)parsedContent.length();
            additionalFields.put(Property.CONTENT_LENGTH.toLowerCase(), length);
        }
        this.addAdditionalField(additionalFields, Property.AUTHOR, metadata.get(TikaCoreProperties.CREATOR));
        this.addAdditionalField(additionalFields, Property.KEYWORDS, metadata.get(Office.KEYWORDS));
        this.addAdditionalField(additionalFields, Property.MODIFIED, metadata.get(TikaCoreProperties.MODIFIED));
        this.addAdditionalField(additionalFields, Property.FORMAT, metadata.get(TikaCoreProperties.FORMAT));
        this.addAdditionalField(additionalFields, Property.IDENTIFIER, metadata.get(TikaCoreProperties.IDENTIFIER));
        this.addAdditionalField(additionalFields, Property.CONTRIBUTOR, metadata.get(TikaCoreProperties.CONTRIBUTOR));
        this.addAdditionalField(additionalFields, Property.COVERAGE, metadata.get(TikaCoreProperties.COVERAGE));
        this.addAdditionalField(additionalFields, Property.MODIFIER, metadata.get(TikaCoreProperties.MODIFIER));
        this.addAdditionalField(additionalFields, Property.CREATOR_TOOL, metadata.get(TikaCoreProperties.CREATOR_TOOL));
        this.addAdditionalField(additionalFields, Property.PUBLISHER, metadata.get(TikaCoreProperties.PUBLISHER));
        this.addAdditionalField(additionalFields, Property.RELATION, metadata.get(TikaCoreProperties.RELATION));
        this.addAdditionalField(additionalFields, Property.RIGHTS, metadata.get(TikaCoreProperties.RIGHTS));
        this.addAdditionalField(additionalFields, Property.SOURCE, metadata.get(TikaCoreProperties.SOURCE));
        this.addAdditionalField(additionalFields, Property.TYPE, metadata.get(TikaCoreProperties.TYPE));
        this.addAdditionalField(additionalFields, Property.DESCRIPTION, metadata.get(TikaCoreProperties.DESCRIPTION));
        this.addAdditionalField(additionalFields, Property.PRINT_DATE, metadata.get(TikaCoreProperties.PRINT_DATE));
        this.addAdditionalField(additionalFields, Property.METADATA_DATE, metadata.get(TikaCoreProperties.METADATA_DATE));
        this.addAdditionalField(additionalFields, Property.LATITUDE, metadata.get(TikaCoreProperties.LATITUDE));
        this.addAdditionalField(additionalFields, Property.LONGITUDE, metadata.get(TikaCoreProperties.LONGITUDE));
        this.addAdditionalField(additionalFields, Property.ALTITUDE, metadata.get(TikaCoreProperties.ALTITUDE));
        this.addAdditionalField(additionalFields, Property.RATING, metadata.get(TikaCoreProperties.RATING));
        this.addAdditionalField(additionalFields, Property.COMMENTS, metadata.get(TikaCoreProperties.COMMENTS));
        ingestDocument.setFieldValue(this.targetField, additionalFields);
        if (this.removeBinary) {
            ingestDocument.removeField(this.field);
        }
        return ingestDocument;
    }

    private void addAdditionalField(Map<String, Object> additionalFields, Property property, String value) {
        if (this.properties.contains((Object)property) && Strings.hasLength((String)value)) {
            additionalFields.put(property.toLowerCase(), value);
        }
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    int getIndexedChars() {
        return this.indexedChars;
    }

    static enum Property {
        CONTENT,
        TITLE,
        AUTHOR,
        KEYWORDS,
        DATE,
        CONTENT_TYPE,
        CONTENT_LENGTH,
        LANGUAGE,
        MODIFIED,
        FORMAT,
        IDENTIFIER,
        CONTRIBUTOR,
        COVERAGE,
        MODIFIER,
        CREATOR_TOOL,
        PUBLISHER,
        RELATION,
        RIGHTS,
        SOURCE,
        TYPE,
        DESCRIPTION,
        PRINT_DATE,
        METADATA_DATE,
        LATITUDE,
        LONGITUDE,
        ALTITUDE,
        RATING,
        COMMENTS;


        public static Property parse(String value) {
            return Property.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toLowerCase() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final Set<Property> DEFAULT_PROPERTIES = EnumSet.allOf(Property.class);

        public AttachmentProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) {
            Set<Property> properties;
            String field = ConfigurationUtils.readStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"field");
            String resourceName = ConfigurationUtils.readOptionalStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"resource_name");
            String targetField = ConfigurationUtils.readStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)AttachmentProcessor.TYPE);
            List propertyNames = ConfigurationUtils.readOptionalList((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"properties");
            int indexedChars = ConfigurationUtils.readIntProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"indexed_chars", (Integer)100000);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            String indexedCharsField = ConfigurationUtils.readOptionalStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"indexed_chars_field");
            Boolean removeBinary = ConfigurationUtils.readOptionalBooleanProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"remove_binary");
            if (removeBinary == null) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.PARSING, "attachment-remove-binary", "The default [remove_binary] value of 'false' is deprecated and will be set to 'true' in a future release. Set [remove_binary] explicitly to 'true' or 'false' to ensure no behavior change.", new Object[0]);
                removeBinary = false;
            }
            if (propertyNames != null) {
                properties = EnumSet.noneOf(Property.class);
                for (String fieldName : propertyNames) {
                    try {
                        properties.add(Property.parse(fieldName));
                    }
                    catch (Exception e) {
                        throw ConfigurationUtils.newConfigurationException((String)AttachmentProcessor.TYPE, (String)processorTag, (String)"properties", (String)("illegal field option [" + fieldName + "]. valid values are " + Arrays.toString((Object[])Property.values())));
                    }
                }
            } else {
                properties = DEFAULT_PROPERTIES;
            }
            return new AttachmentProcessor(processorTag, description, field, targetField, properties, indexedChars, ignoreMissing, indexedCharsField, resourceName, removeBinary);
        }
    }
}

