/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.textstructure.structurefinder;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.textstructure.structurefinder.FieldStats;

public class TextStructure
implements ToXContentObject,
Writeable {
    public static final String EXPLAIN = "explain";
    public static final ParseField NUM_LINES_ANALYZED = new ParseField("num_lines_analyzed", new String[0]);
    public static final ParseField NUM_MESSAGES_ANALYZED = new ParseField("num_messages_analyzed", new String[0]);
    public static final ParseField SAMPLE_START = new ParseField("sample_start", new String[0]);
    public static final ParseField CHARSET = new ParseField("charset", new String[0]);
    public static final ParseField HAS_BYTE_ORDER_MARKER = new ParseField("has_byte_order_marker", new String[0]);
    public static final ParseField FORMAT = new ParseField("format", new String[0]);
    public static final ParseField MULTILINE_START_PATTERN = new ParseField("multiline_start_pattern", new String[0]);
    public static final ParseField EXCLUDE_LINES_PATTERN = new ParseField("exclude_lines_pattern", new String[0]);
    public static final ParseField COLUMN_NAMES = new ParseField("column_names", new String[0]);
    public static final ParseField HAS_HEADER_ROW = new ParseField("has_header_row", new String[0]);
    public static final ParseField DELIMITER = new ParseField("delimiter", new String[0]);
    public static final ParseField QUOTE = new ParseField("quote", new String[0]);
    public static final ParseField SHOULD_TRIM_FIELDS = new ParseField("should_trim_fields", new String[0]);
    public static final ParseField GROK_PATTERN = new ParseField("grok_pattern", new String[0]);
    public static final ParseField ECS_COMPATIBILITY = new ParseField("ecs_compatibility", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField JODA_TIMESTAMP_FORMATS = new ParseField("joda_timestamp_formats", new String[0]);
    public static final ParseField JAVA_TIMESTAMP_FORMATS = new ParseField("java_timestamp_formats", new String[0]);
    public static final ParseField NEED_CLIENT_TIMEZONE = new ParseField("need_client_timezone", new String[0]);
    public static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    public static final ParseField INGEST_PIPELINE = new ParseField("ingest_pipeline", new String[0]);
    public static final ParseField FIELD_STATS = new ParseField("field_stats", new String[0]);
    public static final ParseField EXPLANATION = new ParseField("explanation", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("file_structure", false, Builder::new);
    private final int numLinesAnalyzed;
    private final int numMessagesAnalyzed;
    private final String sampleStart;
    private final String charset;
    private final Boolean hasByteOrderMarker;
    private final Format format;
    private final String multilineStartPattern;
    private final String excludeLinesPattern;
    private final List<String> columnNames;
    private final Boolean hasHeaderRow;
    private final Character delimiter;
    private final Character quote;
    private final Boolean shouldTrimFields;
    private final String grokPattern;
    private final String ecsCompatibility;
    private final List<String> jodaTimestampFormats;
    private final List<String> javaTimestampFormats;
    private final String timestampField;
    private final boolean needClientTimezone;
    private final SortedMap<String, Object> mappings;
    private final Map<String, Object> ingestPipeline;
    private final SortedMap<String, FieldStats> fieldStats;
    private final List<String> explanation;

    private static String getNonNullEcsCompatibilityString(String ecsCompatibility) {
        return ecsCompatibility == null || ecsCompatibility.isEmpty() ? "disabled" : ecsCompatibility;
    }

    public TextStructure(int numLinesAnalyzed, int numMessagesAnalyzed, String sampleStart, String charset, Boolean hasByteOrderMarker, Format format, String multilineStartPattern, String excludeLinesPattern, List<String> columnNames, Boolean hasHeaderRow, Character delimiter, Character quote, Boolean shouldTrimFields, String grokPattern, String ecsCompatibility, String timestampField, List<String> jodaTimestampFormats, List<String> javaTimestampFormats, boolean needClientTimezone, Map<String, Object> mappings, Map<String, Object> ingestPipeline, Map<String, FieldStats> fieldStats, List<String> explanation) {
        this.numLinesAnalyzed = numLinesAnalyzed;
        this.numMessagesAnalyzed = numMessagesAnalyzed;
        this.sampleStart = Objects.requireNonNull(sampleStart);
        this.charset = Objects.requireNonNull(charset);
        this.hasByteOrderMarker = hasByteOrderMarker;
        this.format = Objects.requireNonNull(format);
        this.multilineStartPattern = multilineStartPattern;
        this.excludeLinesPattern = excludeLinesPattern;
        this.columnNames = columnNames == null ? null : List.copyOf(columnNames);
        this.hasHeaderRow = hasHeaderRow;
        this.delimiter = delimiter;
        this.quote = quote;
        this.shouldTrimFields = shouldTrimFields;
        this.grokPattern = grokPattern;
        this.ecsCompatibility = TextStructure.getNonNullEcsCompatibilityString(ecsCompatibility);
        this.timestampField = timestampField;
        this.jodaTimestampFormats = jodaTimestampFormats == null ? null : List.copyOf(jodaTimestampFormats);
        this.javaTimestampFormats = javaTimestampFormats == null ? null : List.copyOf(javaTimestampFormats);
        this.needClientTimezone = needClientTimezone;
        this.mappings = Collections.unmodifiableSortedMap(new TreeMap<String, Object>(mappings));
        this.ingestPipeline = ingestPipeline == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(ingestPipeline));
        this.fieldStats = Collections.unmodifiableSortedMap(new TreeMap<String, FieldStats>(fieldStats));
        this.explanation = List.copyOf(explanation);
    }

    public TextStructure(StreamInput in) throws IOException {
        this.numLinesAnalyzed = in.readVInt();
        this.numMessagesAnalyzed = in.readVInt();
        this.sampleStart = in.readString();
        this.charset = in.readString();
        this.hasByteOrderMarker = in.readOptionalBoolean();
        this.format = (Format)in.readEnum(Format.class);
        this.multilineStartPattern = in.readOptionalString();
        this.excludeLinesPattern = in.readOptionalString();
        this.columnNames = in.readBoolean() ? in.readCollectionAsImmutableList(StreamInput::readString) : null;
        this.hasHeaderRow = in.readOptionalBoolean();
        this.delimiter = in.readBoolean() ? Character.valueOf((char)in.readVInt()) : null;
        this.quote = in.readBoolean() ? Character.valueOf((char)in.readVInt()) : null;
        this.shouldTrimFields = in.readOptionalBoolean();
        this.grokPattern = in.readOptionalString();
        this.ecsCompatibility = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_5_0) ? TextStructure.getNonNullEcsCompatibilityString(in.readString()) : TextStructure.getNonNullEcsCompatibilityString(null);
        this.jodaTimestampFormats = in.readBoolean() ? in.readCollectionAsImmutableList(StreamInput::readString) : null;
        this.javaTimestampFormats = in.readBoolean() ? in.readCollectionAsImmutableList(StreamInput::readString) : null;
        this.timestampField = in.readOptionalString();
        this.needClientTimezone = in.readBoolean();
        this.mappings = Collections.unmodifiableSortedMap(new TreeMap(in.readGenericMap()));
        this.ingestPipeline = in.readBoolean() ? Collections.unmodifiableMap(in.readGenericMap()) : null;
        this.fieldStats = Collections.unmodifiableSortedMap(new TreeMap(in.readMap(FieldStats::new)));
        this.explanation = in.readCollectionAsImmutableList(StreamInput::readString);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numLinesAnalyzed);
        out.writeVInt(this.numMessagesAnalyzed);
        out.writeString(this.sampleStart);
        out.writeString(this.charset);
        out.writeOptionalBoolean(this.hasByteOrderMarker);
        out.writeEnum((Enum)this.format);
        out.writeOptionalString(this.multilineStartPattern);
        out.writeOptionalString(this.excludeLinesPattern);
        if (this.columnNames == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeStringCollection(this.columnNames);
        }
        out.writeOptionalBoolean(this.hasHeaderRow);
        if (this.delimiter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt((int)this.delimiter.charValue());
        }
        if (this.quote == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt((int)this.quote.charValue());
        }
        out.writeOptionalBoolean(this.shouldTrimFields);
        out.writeOptionalString(this.grokPattern);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_5_0)) {
            out.writeString(this.ecsCompatibility);
        }
        if (this.jodaTimestampFormats == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeStringCollection(this.jodaTimestampFormats);
        }
        if (this.javaTimestampFormats == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeStringCollection(this.javaTimestampFormats);
        }
        out.writeOptionalString(this.timestampField);
        out.writeBoolean(this.needClientTimezone);
        out.writeGenericMap(this.mappings);
        if (this.ingestPipeline == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeGenericMap(this.ingestPipeline);
        }
        out.writeMap(this.fieldStats, StreamOutput::writeWriteable);
        out.writeStringCollection(this.explanation);
    }

    public int getNumLinesAnalyzed() {
        return this.numLinesAnalyzed;
    }

    public int getNumMessagesAnalyzed() {
        return this.numMessagesAnalyzed;
    }

    public String getSampleStart() {
        return this.sampleStart;
    }

    public String getCharset() {
        return this.charset;
    }

    public Boolean getHasByteOrderMarker() {
        return this.hasByteOrderMarker;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getMultilineStartPattern() {
        return this.multilineStartPattern;
    }

    public String getExcludeLinesPattern() {
        return this.excludeLinesPattern;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Boolean getHasHeaderRow() {
        return this.hasHeaderRow;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public Character getQuote() {
        return this.quote;
    }

    public Boolean getShouldTrimFields() {
        return this.shouldTrimFields;
    }

    public String getGrokPattern() {
        return this.grokPattern;
    }

    public String getEcsCompatibility() {
        return this.ecsCompatibility;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public List<String> getJodaTimestampFormats() {
        return this.jodaTimestampFormats;
    }

    public List<String> getJavaTimestampFormats() {
        return this.javaTimestampFormats;
    }

    public boolean needClientTimezone() {
        return this.needClientTimezone;
    }

    public SortedMap<String, Object> getMappings() {
        return this.mappings;
    }

    public Map<String, Object> getIngestPipeline() {
        return this.ingestPipeline;
    }

    public SortedMap<String, FieldStats> getFieldStats() {
        return this.fieldStats;
    }

    public List<String> getExplanation() {
        return this.explanation;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_LINES_ANALYZED.getPreferredName(), this.numLinesAnalyzed);
        builder.field(NUM_MESSAGES_ANALYZED.getPreferredName(), this.numMessagesAnalyzed);
        builder.field(SAMPLE_START.getPreferredName(), this.sampleStart);
        builder.field(CHARSET.getPreferredName(), this.charset);
        if (this.hasByteOrderMarker != null) {
            builder.field(HAS_BYTE_ORDER_MARKER.getPreferredName(), this.hasByteOrderMarker.booleanValue());
        }
        builder.field(FORMAT.getPreferredName(), (Enum)this.format);
        if (this.multilineStartPattern != null && !this.multilineStartPattern.isEmpty()) {
            builder.field(MULTILINE_START_PATTERN.getPreferredName(), this.multilineStartPattern);
        }
        if (this.excludeLinesPattern != null && !this.excludeLinesPattern.isEmpty()) {
            builder.field(EXCLUDE_LINES_PATTERN.getPreferredName(), this.excludeLinesPattern);
        }
        if (this.columnNames != null && !this.columnNames.isEmpty()) {
            builder.field(COLUMN_NAMES.getPreferredName(), this.columnNames);
        }
        if (this.hasHeaderRow != null) {
            builder.field(HAS_HEADER_ROW.getPreferredName(), this.hasHeaderRow.booleanValue());
        }
        if (this.delimiter != null) {
            builder.field(DELIMITER.getPreferredName(), String.valueOf(this.delimiter));
        }
        if (this.quote != null) {
            builder.field(QUOTE.getPreferredName(), String.valueOf(this.quote));
        }
        if (this.shouldTrimFields != null) {
            builder.field(SHOULD_TRIM_FIELDS.getPreferredName(), this.shouldTrimFields.booleanValue());
        }
        if (this.grokPattern != null && !this.grokPattern.isEmpty()) {
            builder.field(GROK_PATTERN.getPreferredName(), this.grokPattern);
        }
        builder.field(ECS_COMPATIBILITY.getPreferredName(), this.ecsCompatibility);
        if (this.timestampField != null && !this.timestampField.isEmpty()) {
            builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestampField);
        }
        if (this.jodaTimestampFormats != null && !this.jodaTimestampFormats.isEmpty()) {
            builder.field(JODA_TIMESTAMP_FORMATS.getPreferredName(), this.jodaTimestampFormats);
        }
        if (this.javaTimestampFormats != null && !this.javaTimestampFormats.isEmpty()) {
            builder.field(JAVA_TIMESTAMP_FORMATS.getPreferredName(), this.javaTimestampFormats);
        }
        builder.field(NEED_CLIENT_TIMEZONE.getPreferredName(), this.needClientTimezone);
        builder.field(MAPPINGS.getPreferredName(), this.mappings);
        if (this.ingestPipeline != null) {
            builder.field(INGEST_PIPELINE.getPreferredName(), this.ingestPipeline);
        }
        if (!this.fieldStats.isEmpty()) {
            builder.startObject(FIELD_STATS.getPreferredName());
            for (Map.Entry<String, FieldStats> entry : this.fieldStats.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue());
            }
            builder.endObject();
        }
        if (params.paramAsBoolean(EXPLAIN, false)) {
            builder.field(EXPLANATION.getPreferredName(), this.explanation);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.numLinesAnalyzed, this.numMessagesAnalyzed, this.sampleStart, this.charset, this.hasByteOrderMarker, this.format, this.multilineStartPattern, this.excludeLinesPattern, this.columnNames, this.hasHeaderRow, this.delimiter, this.quote, this.shouldTrimFields, this.grokPattern, this.ecsCompatibility, this.timestampField, this.jodaTimestampFormats, this.javaTimestampFormats, this.needClientTimezone, this.mappings, this.fieldStats, this.explanation});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TextStructure that = (TextStructure)other;
        return this.numLinesAnalyzed == that.numLinesAnalyzed && this.numMessagesAnalyzed == that.numMessagesAnalyzed && Objects.equals(this.sampleStart, that.sampleStart) && Objects.equals(this.charset, that.charset) && Objects.equals(this.hasByteOrderMarker, that.hasByteOrderMarker) && Objects.equals((Object)this.format, (Object)that.format) && Objects.equals(this.multilineStartPattern, that.multilineStartPattern) && Objects.equals(this.excludeLinesPattern, that.excludeLinesPattern) && Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.hasHeaderRow, that.hasHeaderRow) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.quote, that.quote) && Objects.equals(this.shouldTrimFields, that.shouldTrimFields) && Objects.equals(this.grokPattern, that.grokPattern) && Objects.equals(this.ecsCompatibility, that.ecsCompatibility) && Objects.equals(this.timestampField, that.timestampField) && Objects.equals(this.jodaTimestampFormats, that.jodaTimestampFormats) && Objects.equals(this.javaTimestampFormats, that.javaTimestampFormats) && this.needClientTimezone == that.needClientTimezone && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.fieldStats, that.fieldStats) && Objects.equals(this.explanation, that.explanation);
    }

    static {
        PARSER.declareInt(Builder::setNumLinesAnalyzed, NUM_LINES_ANALYZED);
        PARSER.declareInt(Builder::setNumMessagesAnalyzed, NUM_MESSAGES_ANALYZED);
        PARSER.declareString(Builder::setSampleStart, SAMPLE_START);
        PARSER.declareString(Builder::setCharset, CHARSET);
        PARSER.declareBoolean(Builder::setHasByteOrderMarker, HAS_BYTE_ORDER_MARKER);
        PARSER.declareString((p, c) -> p.setFormat(Format.fromString(c)), FORMAT);
        PARSER.declareString(Builder::setMultilineStartPattern, MULTILINE_START_PATTERN);
        PARSER.declareString(Builder::setExcludeLinesPattern, EXCLUDE_LINES_PATTERN);
        PARSER.declareStringArray(Builder::setColumnNames, COLUMN_NAMES);
        PARSER.declareBoolean(Builder::setHasHeaderRow, HAS_HEADER_ROW);
        PARSER.declareString((p, c) -> p.setDelimiter(Character.valueOf(c.charAt(0))), DELIMITER);
        PARSER.declareString((p, c) -> p.setQuote(Character.valueOf(c.charAt(0))), QUOTE);
        PARSER.declareBoolean(Builder::setShouldTrimFields, SHOULD_TRIM_FIELDS);
        PARSER.declareString(Builder::setGrokPattern, GROK_PATTERN);
        PARSER.declareString(Builder::setEcsCompatibility, ECS_COMPATIBILITY);
        PARSER.declareString(Builder::setTimestampField, TIMESTAMP_FIELD);
        PARSER.declareStringArray(Builder::setJodaTimestampFormats, JODA_TIMESTAMP_FORMATS);
        PARSER.declareStringArray(Builder::setJavaTimestampFormats, JAVA_TIMESTAMP_FORMATS);
        PARSER.declareBoolean(Builder::setNeedClientTimezone, NEED_CLIENT_TIMEZONE);
        PARSER.declareObject(Builder::setMappings, (p, c) -> new TreeMap(p.map()), MAPPINGS);
        PARSER.declareObject(Builder::setIngestPipeline, (p, c) -> p.mapOrdered(), INGEST_PIPELINE);
        PARSER.declareObject(Builder::setFieldStats, (p, c) -> {
            TreeMap<String, FieldStats> fieldStats = new TreeMap<String, FieldStats>();
            while (p.nextToken() == XContentParser.Token.FIELD_NAME) {
                fieldStats.put(p.currentName(), (FieldStats)FieldStats.PARSER.apply(p, c));
            }
            return fieldStats;
        }, FIELD_STATS);
        PARSER.declareStringArray(Builder::setExplanation, EXPLANATION);
    }

    public static enum Format {
        NDJSON,
        XML,
        DELIMITED,
        SEMI_STRUCTURED_TEXT;


        public boolean supportsNesting() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NDJSON, XML -> true;
                case DELIMITED, SEMI_STRUCTURED_TEXT -> false;
            };
        }

        public boolean isStructured() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NDJSON, XML, DELIMITED -> true;
                case SEMI_STRUCTURED_TEXT -> false;
            };
        }

        public boolean isSemiStructured() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NDJSON, XML, DELIMITED -> false;
                case SEMI_STRUCTURED_TEXT -> true;
            };
        }

        public static Format fromString(String name) {
            return Format.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static final class Builder {
        private int numLinesAnalyzed;
        private int numMessagesAnalyzed;
        private String sampleStart;
        private String charset;
        private Boolean hasByteOrderMarker;
        private Format format;
        private String multilineStartPattern;
        private String excludeLinesPattern;
        private List<String> columnNames;
        private Boolean hasHeaderRow;
        private Character delimiter;
        private Character quote;
        private Boolean shouldTrimFields;
        private String grokPattern;
        private String ecsCompatibility;
        private String timestampField;
        private List<String> jodaTimestampFormats;
        private List<String> javaTimestampFormats;
        private boolean needClientTimezone;
        private Map<String, Object> mappings;
        private Map<String, Object> ingestPipeline;
        private Map<String, FieldStats> fieldStats = Collections.emptyMap();
        private List<String> explanation;

        public Builder() {
            this(Format.SEMI_STRUCTURED_TEXT);
        }

        public Builder(Format format) {
            this.setFormat(format);
        }

        public Builder setNumLinesAnalyzed(int numLinesAnalyzed) {
            this.numLinesAnalyzed = numLinesAnalyzed;
            return this;
        }

        public Builder setNumMessagesAnalyzed(int numMessagesAnalyzed) {
            this.numMessagesAnalyzed = numMessagesAnalyzed;
            return this;
        }

        public Builder setSampleStart(String sampleStart) {
            this.sampleStart = Objects.requireNonNull(sampleStart);
            return this;
        }

        public Builder setCharset(String charset) {
            this.charset = Objects.requireNonNull(charset);
            return this;
        }

        public Builder setHasByteOrderMarker(Boolean hasByteOrderMarker) {
            this.hasByteOrderMarker = hasByteOrderMarker;
            return this;
        }

        public Builder setFormat(Format format) {
            this.format = Objects.requireNonNull(format);
            return this;
        }

        public Builder setMultilineStartPattern(String multilineStartPattern) {
            this.multilineStartPattern = multilineStartPattern;
            return this;
        }

        public Builder setExcludeLinesPattern(String excludeLinesPattern) {
            this.excludeLinesPattern = excludeLinesPattern;
            return this;
        }

        public Builder setColumnNames(List<String> columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        public Builder setHasHeaderRow(Boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
            return this;
        }

        public Builder setDelimiter(Character delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder setQuote(Character quote) {
            this.quote = quote;
            return this;
        }

        public Builder setShouldTrimFields(Boolean shouldTrimFields) {
            this.shouldTrimFields = shouldTrimFields;
            return this;
        }

        public Builder setGrokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
            return this;
        }

        public Builder setEcsCompatibility(String ecsCompatibility) {
            this.ecsCompatibility = ecsCompatibility;
            return this;
        }

        public Builder setTimestampField(String timestampField) {
            this.timestampField = timestampField;
            return this;
        }

        public Builder setJodaTimestampFormats(List<String> jodaTimestampFormats) {
            this.jodaTimestampFormats = jodaTimestampFormats;
            return this;
        }

        public Builder setJavaTimestampFormats(List<String> javaTimestampFormats) {
            this.javaTimestampFormats = javaTimestampFormats;
            return this;
        }

        public Builder setNeedClientTimezone(boolean needClientTimezone) {
            this.needClientTimezone = needClientTimezone;
            return this;
        }

        public Builder setMappings(Map<String, Object> mappings) {
            this.mappings = Objects.requireNonNull(mappings);
            return this;
        }

        public Builder setIngestPipeline(Map<String, Object> ingestPipeline) {
            this.ingestPipeline = ingestPipeline;
            return this;
        }

        public Builder setFieldStats(Map<String, FieldStats> fieldStats) {
            this.fieldStats = Objects.requireNonNull(fieldStats);
            return this;
        }

        public Builder setExplanation(List<String> explanation) {
            this.explanation = Objects.requireNonNull(explanation);
            return this;
        }

        public TextStructure build() {
            boolean isJavaTimestampFormatsSpecified;
            if (this.numLinesAnalyzed <= 0) {
                throw new IllegalArgumentException("Number of lines analyzed must be positive.");
            }
            if (this.numMessagesAnalyzed <= 0) {
                throw new IllegalArgumentException("Number of messages analyzed must be positive.");
            }
            if (this.numMessagesAnalyzed > this.numLinesAnalyzed) {
                throw new IllegalArgumentException("Number of messages analyzed cannot be greater than number of lines analyzed.");
            }
            if (this.sampleStart == null || this.sampleStart.isEmpty()) {
                throw new IllegalArgumentException("Sample start must be specified.");
            }
            if (this.charset == null || this.charset.isEmpty()) {
                throw new IllegalArgumentException("A character set must be specified.");
            }
            if (!this.charset.toUpperCase(Locale.ROOT).startsWith("UTF") && this.hasByteOrderMarker != null) {
                throw new IllegalArgumentException("A byte order marker is only possible for UTF character sets.");
            }
            switch (this.format) {
                case NDJSON: {
                    if (this.shouldTrimFields != null) {
                        throw new IllegalArgumentException("Should trim fields may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                }
                case XML: {
                    if (this.columnNames != null) {
                        throw new IllegalArgumentException("Column names may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.hasHeaderRow != null) {
                        throw new IllegalArgumentException("Has header row may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.delimiter != null) {
                        throw new IllegalArgumentException("Delimiter may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.quote != null) {
                        throw new IllegalArgumentException("Quote may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.grokPattern == null) break;
                    throw new IllegalArgumentException("Grok pattern may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                }
                case DELIMITED: {
                    if (this.columnNames == null || this.columnNames.isEmpty()) {
                        throw new IllegalArgumentException("Column names must be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.hasHeaderRow == null) {
                        throw new IllegalArgumentException("Has header row must be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.delimiter == null) {
                        throw new IllegalArgumentException("Delimiter must be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.grokPattern == null) break;
                    throw new IllegalArgumentException("Grok pattern may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                }
                case SEMI_STRUCTURED_TEXT: {
                    if (this.columnNames != null) {
                        throw new IllegalArgumentException("Column names may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.hasHeaderRow != null) {
                        throw new IllegalArgumentException("Has header row may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.delimiter != null) {
                        throw new IllegalArgumentException("Delimiter may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.quote != null) {
                        throw new IllegalArgumentException("Quote may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.shouldTrimFields != null) {
                        throw new IllegalArgumentException("Should trim fields may not be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.grokPattern == null || this.grokPattern.isEmpty()) {
                        throw new IllegalArgumentException("Grok pattern must be specified for [" + String.valueOf((Object)this.format) + "] structures.");
                    }
                    if (this.ecsCompatibility == null || this.ecsCompatibility.isEmpty() || GrokBuiltinPatterns.isValidEcsCompatibilityMode((String)this.ecsCompatibility)) break;
                    throw new IllegalArgumentException(ECS_COMPATIBILITY.getPreferredName() + "] must be one of [" + String.join((CharSequence)", ", GrokBuiltinPatterns.ECS_COMPATIBILITY_MODES) + "] if specified");
                }
                default: {
                    throw new IllegalStateException("enum value [" + String.valueOf((Object)this.format) + "] missing from switch.");
                }
            }
            boolean isTimestampFieldSpecified = this.timestampField != null;
            boolean isJodaTimestampFormatsSpecified = this.jodaTimestampFormats != null && !this.jodaTimestampFormats.isEmpty();
            boolean bl = isJavaTimestampFormatsSpecified = this.javaTimestampFormats != null && !this.javaTimestampFormats.isEmpty();
            if (isTimestampFieldSpecified != isJodaTimestampFormatsSpecified) {
                throw new IllegalArgumentException("Timestamp field and Joda timestamp formats must both be specified or neither be specified.");
            }
            if (isTimestampFieldSpecified != isJavaTimestampFormatsSpecified) {
                throw new IllegalArgumentException("Timestamp field and Java timestamp formats must both be specified or neither be specified.");
            }
            if (this.needClientTimezone && !isTimestampFieldSpecified) {
                throw new IllegalArgumentException("Client timezone cannot be needed if there is no timestamp field.");
            }
            if (this.mappings == null || this.mappings.isEmpty()) {
                throw new IllegalArgumentException("Mappings must be specified.");
            }
            if (this.explanation == null || this.explanation.isEmpty()) {
                throw new IllegalArgumentException("Explanation must be specified.");
            }
            return new TextStructure(this.numLinesAnalyzed, this.numMessagesAnalyzed, this.sampleStart, this.charset, this.hasByteOrderMarker, this.format, this.multilineStartPattern, this.excludeLinesPattern, this.columnNames, this.hasHeaderRow, this.delimiter, this.quote, this.shouldTrimFields, this.grokPattern, this.ecsCompatibility, this.timestampField, this.jodaTimestampFormats, this.javaTimestampFormats, this.needClientTimezone, this.mappings, this.ingestPipeline, this.fieldStats, this.explanation);
        }
    }
}

