/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.AbstractConfusionMatrixMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.OutlierDetection;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.ScoreByThresholdResult;

public class Precision
extends AbstractConfusionMatrixMetric {
    public static final ParseField NAME = new ParseField("precision", new String[0]);
    private static final ConstructingObjectParser<Precision, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new Precision((List)a[0]));

    public static Precision fromXContent(XContentParser parser) {
        return (Precision)PARSER.apply(parser, null);
    }

    public Precision(List<Double> at) {
        super(at);
    }

    public Precision(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, NAME);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Precision that = (Precision)o;
        return Arrays.equals(this.thresholds, that.thresholds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.thresholds);
    }

    @Override
    protected List<AggregationBuilder> aggsAt(String actualField, String predictedProbabilityField) {
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>();
        for (int i = 0; i < this.thresholds.length; ++i) {
            double threshold = this.thresholds[i];
            aggs.add(this.buildAgg(actualField, predictedProbabilityField, threshold, AbstractConfusionMatrixMetric.Condition.TP));
            aggs.add(this.buildAgg(actualField, predictedProbabilityField, threshold, AbstractConfusionMatrixMetric.Condition.FP));
        }
        return aggs;
    }

    @Override
    public EvaluationMetricResult evaluate(InternalAggregations aggs) {
        double[] precisions = new double[this.thresholds.length];
        for (int i = 0; i < this.thresholds.length; ++i) {
            long fp;
            double threshold = this.thresholds[i];
            Filter tpAgg = (Filter)aggs.get(this.aggName(threshold, AbstractConfusionMatrixMetric.Condition.TP));
            Filter fpAgg = (Filter)aggs.get(this.aggName(threshold, AbstractConfusionMatrixMetric.Condition.FP));
            long tp = tpAgg.getDocCount();
            precisions[i] = tp + (fp = fpAgg.getDocCount()) == 0L ? 0.0 : (double)tp / (double)(tp + fp);
        }
        return new ScoreByThresholdResult(NAME.getPreferredName(), this.thresholds, precisions);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), AT);
    }
}

