/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class EstimateModelMemoryAction
extends ActionType<Response> {
    public static final EstimateModelMemoryAction INSTANCE = new EstimateModelMemoryAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/estimate_model_memory";

    private EstimateModelMemoryAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private static final ParseField MODEL_MEMORY_ESTIMATE = new ParseField("model_memory_estimate", new String[0]);
        private final ByteSizeValue modelMemoryEstimate;

        public Response(ByteSizeValue modelMemoryEstimate) {
            this.modelMemoryEstimate = Objects.requireNonNull(modelMemoryEstimate);
        }

        public Response(StreamInput in) throws IOException {
            this.modelMemoryEstimate = ByteSizeValue.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.modelMemoryEstimate.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MODEL_MEMORY_ESTIMATE.getPreferredName(), this.modelMemoryEstimate.getStringRep());
            builder.endObject();
            return builder;
        }

        public ByteSizeValue getModelMemoryEstimate() {
            return this.modelMemoryEstimate;
        }
    }

    public static class Request
    extends LegacyActionRequest {
        public static final ParseField ANALYSIS_CONFIG = Job.ANALYSIS_CONFIG;
        public static final ParseField OVERALL_CARDINALITY = new ParseField("overall_cardinality", new String[0]);
        public static final ParseField MAX_BUCKET_CARDINALITY = new ParseField("max_bucket_cardinality", new String[0]);
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/estimate_model_memory", Request::new);
        private AnalysisConfig analysisConfig;
        private Map<String, Long> overallCardinality = Collections.emptyMap();
        private Map<String, Long> maxBucketCardinality = Collections.emptyMap();

        public static Request parseRequest(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.analysisConfig = in.readBoolean() ? new AnalysisConfig(in) : null;
            this.overallCardinality = in.readMap(StreamInput::readVLong);
            this.maxBucketCardinality = in.readMap(StreamInput::readVLong);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.analysisConfig != null) {
                out.writeBoolean(true);
                this.analysisConfig.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeMap(this.overallCardinality, StreamOutput::writeVLong);
            out.writeMap(this.maxBucketCardinality, StreamOutput::writeVLong);
        }

        public ActionRequestValidationException validate() {
            if (this.analysisConfig == null) {
                ActionRequestValidationException e = new ActionRequestValidationException();
                e.addValidationError("[" + ANALYSIS_CONFIG.getPreferredName() + "] was not specified");
                return e;
            }
            return null;
        }

        public AnalysisConfig getAnalysisConfig() {
            return this.analysisConfig;
        }

        public void setAnalysisConfig(AnalysisConfig analysisConfig) {
            this.analysisConfig = ExceptionsHelper.requireNonNull(analysisConfig, ANALYSIS_CONFIG);
        }

        public Map<String, Long> getOverallCardinality() {
            return this.overallCardinality;
        }

        public void setOverallCardinality(Map<String, Long> overallCardinality) {
            this.overallCardinality = Collections.unmodifiableMap(ExceptionsHelper.requireNonNull(overallCardinality, OVERALL_CARDINALITY));
        }

        public Map<String, Long> getMaxBucketCardinality() {
            return this.maxBucketCardinality;
        }

        public void setMaxBucketCardinality(Map<String, Long> maxBucketCardinality) {
            this.maxBucketCardinality = Collections.unmodifiableMap(ExceptionsHelper.requireNonNull(maxBucketCardinality, MAX_BUCKET_CARDINALITY));
        }

        private static long parseNonNegativeLong(XContentParser parser, ParseField enclosingField) throws IOException {
            long value = parser.longValue();
            if (value < 0L) {
                throw ExceptionsHelper.badRequestException("[{}] contained negative cardinality [{}]", enclosingField.getPreferredName(), value);
            }
            return value;
        }

        static {
            PARSER.declareObject(Request::setAnalysisConfig, (p, c) -> ((AnalysisConfig.Builder)AnalysisConfig.STRICT_PARSER.apply(p, c)).build(), ANALYSIS_CONFIG);
            PARSER.declareObject(Request::setOverallCardinality, (p, c) -> p.map(HashMap::new, parser -> Request.parseNonNegativeLong(parser, OVERALL_CARDINALITY)), OVERALL_CARDINALITY);
            PARSER.declareObject(Request::setMaxBucketCardinality, (p, c) -> p.map(HashMap::new, parser -> Request.parseNonNegativeLong(parser, MAX_BUCKET_CARDINALITY)), MAX_BUCKET_CARDINALITY);
        }
    }
}

