/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic.Arithmetics;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic.BinaryArithmeticOperation;

public enum DefaultBinaryArithmeticOperation implements BinaryArithmeticOperation
{
    ADD(Arithmetics::add, "+"),
    SUB(Arithmetics::sub, "-"),
    MUL(Arithmetics::mul, "*"),
    DIV(Arithmetics::div, "/"),
    MOD(Arithmetics::mod, "%");

    public static final String NAME = "abn-def";
    private final BiFunction<Object, Object, Object> process;
    private final String symbol;

    private DefaultBinaryArithmeticOperation(BiFunction<Object, Object, Object> process, String symbol) {
        this.process = process;
        this.symbol = symbol;
    }

    private DefaultBinaryArithmeticOperation(Arithmetics.NumericArithmetic process, String symbol) {
        this(process::wrap, symbol);
    }

    @Override
    public String symbol() {
        return this.symbol;
    }

    @Override
    public final Object doApply(Object left, Object right) {
        return this.process.apply(left, right);
    }

    public String toString() {
        return this.symbol;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public static DefaultBinaryArithmeticOperation read(StreamInput in) throws IOException {
        return (DefaultBinaryArithmeticOperation)in.readEnum(DefaultBinaryArithmeticOperation.class);
    }
}

