/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.profiling.action.FrameGroupID;
import org.elasticsearch.xpack.profiling.action.GetStackTracesAction;
import org.elasticsearch.xpack.profiling.action.GetStackTracesRequest;
import org.elasticsearch.xpack.profiling.action.GetStackTracesResponse;
import org.elasticsearch.xpack.profiling.action.GetTopNFunctionsResponse;
import org.elasticsearch.xpack.profiling.action.StackFrame;
import org.elasticsearch.xpack.profiling.action.StackTrace;
import org.elasticsearch.xpack.profiling.action.StopWatch;
import org.elasticsearch.xpack.profiling.action.TopNFunction;

public class TransportGetTopNFunctionsAction
extends TransportAction<GetStackTracesRequest, GetTopNFunctionsResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetTopNFunctionsAction.class);
    private final NodeClient nodeClient;
    private final TransportService transportService;

    @Inject
    public TransportGetTopNFunctionsAction(NodeClient nodeClient, TransportService transportService, ActionFilters actionFilters) {
        super("indices:data/read/profiling/topn/functions", actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nodeClient = nodeClient;
        this.transportService = transportService;
    }

    protected void doExecute(Task task, GetStackTracesRequest request, ActionListener<GetTopNFunctionsResponse> listener) {
        ParentTaskAssigningClient client = new ParentTaskAssigningClient((Client)this.nodeClient, this.transportService.getLocalNode(), task);
        StopWatch watch = new StopWatch("getTopNFunctionsAction");
        client.execute((ActionType)GetStackTracesAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(searchResponse -> {
            StopWatch processingWatch = new StopWatch("Processing response");
            GetTopNFunctionsResponse topNFunctionsResponse = TransportGetTopNFunctionsAction.buildTopNFunctions(searchResponse, request.getLimit());
            log.debug(() -> watch.report() + " " + processingWatch.report());
            listener.onResponse((Object)topNFunctionsResponse);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static GetTopNFunctionsResponse buildTopNFunctions(GetStackTracesResponse response, Integer limit) {
        TopNFunctionsBuilder builder = new TopNFunctionsBuilder(limit);
        if (response.getTotalFrames() == 0) {
            return builder.build();
        }
        for (StackTrace stackTrace : response.getStackTraces().values()) {
            HashSet frameGroupsPerStackTrace = new HashSet();
            long samples = stackTrace.count;
            double annualCO2Tons = stackTrace.annualCO2Tons;
            double annualCostsUSD = stackTrace.annualCostsUSD;
            int frameCount = stackTrace.frameIds.length;
            for (int i = 0; i < frameCount; ++i) {
                String frameId = stackTrace.frameIds[i];
                String fileId = stackTrace.fileIds[i];
                int frameType = stackTrace.typeIds[i];
                int addressOrLine = stackTrace.addressOrLines[i];
                StackFrame stackFrame = response.getStackFrames().getOrDefault(frameId, StackFrame.EMPTY_STACKFRAME);
                String executable = response.getExecutables().getOrDefault(fileId, "");
                boolean isLeafFrame = i == frameCount - 1;
                stackFrame.forEach(frame -> {
                    String frameGroupId = FrameGroupID.create(fileId, addressOrLine, executable, frame.fileName(), frame.functionName());
                    if (!builder.isExists(frameGroupId)) {
                        builder.addTopNFunction(new TopNFunction(frameGroupId, frameType, frame.inline(), addressOrLine, frame.functionName(), frame.fileName(), frame.lineNumber(), executable));
                    }
                    TopNFunction current = builder.getTopNFunction(frameGroupId);
                    if (stackTrace.subGroups != null) {
                        current.addSubGroups(stackTrace.subGroups);
                    }
                    if (!frameGroupsPerStackTrace.contains(frameGroupId)) {
                        frameGroupsPerStackTrace.add(frameGroupId);
                        current.addTotalCount(samples);
                        current.addTotalAnnualCO2Tons(annualCO2Tons);
                        current.addTotalAnnualCostsUSD(annualCostsUSD);
                    }
                    if (isLeafFrame && frame.last()) {
                        current.addSelfCount(samples);
                        current.addSelfAnnualCO2Tons(annualCO2Tons);
                        current.addSelfAnnualCostsUSD(annualCostsUSD);
                    }
                });
            }
        }
        return builder.build();
    }

    static class TopNFunctionsBuilder {
        private final Integer limit;
        private final HashMap<String, TopNFunction> topNFunctions;

        TopNFunctionsBuilder(Integer limit) {
            this.limit = limit;
            this.topNFunctions = new HashMap();
        }

        public GetTopNFunctionsResponse build() {
            List<TopNFunction> functions = new ArrayList<TopNFunction>(this.topNFunctions.values());
            functions.sort(Collections.reverseOrder());
            long sumSelfCount = 0L;
            long sumTotalCount = 0L;
            double sumAnnualCo2Tons = 0.0;
            double sumAnnualCostsUsd = 0.0;
            for (int i = 0; i < functions.size(); ++i) {
                TopNFunction topNFunction = (TopNFunction)functions.get(i);
                topNFunction.setRank(i + 1);
                sumSelfCount += topNFunction.getSelfCount();
                sumTotalCount += topNFunction.getTotalCount();
                sumAnnualCo2Tons += topNFunction.getSelfAnnualCO2Tons();
                sumAnnualCostsUsd += topNFunction.getSelfAnnualCostsUSD();
            }
            if (this.limit != null && this.limit > 0 && this.limit < functions.size()) {
                functions = functions.subList(0, this.limit);
            }
            return new GetTopNFunctionsResponse(sumSelfCount, sumTotalCount, sumAnnualCo2Tons, sumAnnualCostsUsd, functions);
        }

        public boolean isExists(String frameGroupID) {
            return this.topNFunctions.containsKey(frameGroupID);
        }

        public TopNFunction getTopNFunction(String frameGroupID) {
            return this.topNFunctions.get(frameGroupID);
        }

        public void addTopNFunction(TopNFunction topNFunction) {
            this.topNFunctions.put(topNFunction.getId(), topNFunction);
        }
    }
}

